/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import com.ibm.xml.xlxp.api.stax.serializer.Encoding;
import com.ibm.xml.xlxp.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp.api.util.UnsynchronizedBag;
import java.io.IOException;

public final class UTF8Writer
extends StAXWriter {
    private static final ThreadLocal fInstances = new ThreadLocal(){

        public Object initialValue() {
            return new UnsynchronizedBag();
        }
    };

    private static final UnsynchronizedBag getPool() {
        return (UnsynchronizedBag)fInstances.get();
    }

    public static final UTF8Writer getInstance() {
        UTF8Writer uTF8Writer;
        UnsynchronizedBag unsynchronizedBag = UTF8Writer.getPool();
        int n = 0;
        while (n < unsynchronizedBag.size) {
            uTF8Writer = (UTF8Writer)unsynchronizedBag.array[n].get();
            if (uTF8Writer != null) {
                if (!uTF8Writer.fInUse) {
                    uTF8Writer.fInUse = true;
                    return uTF8Writer;
                }
                ++n;
                continue;
            }
            unsynchronizedBag.removeDeadReferences();
        }
        uTF8Writer = new UTF8Writer();
        uTF8Writer.fInUse = true;
        unsynchronizedBag.add(uTF8Writer);
        return uTF8Writer;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 * 3 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n, n2);
        } else {
            this.flushInternal();
            int n3 = n + n2;
            while (n + this.fBuffer.length / 3 < n3) {
                char c = cArray[n + this.fBuffer.length / 3 - 1];
                if (c >= '\ud800' && c <= '\udbff') {
                    this.encodeAndWrite(cArray, n, this.fBuffer.length / 3 - 1);
                    n += this.fBuffer.length / 3 - 1;
                } else {
                    this.encodeAndWrite(cArray, n, this.fBuffer.length / 3);
                    n += this.fBuffer.length / 3;
                }
                this.flushInternal();
            }
            this.encodeAndWrite(cArray, n, n3 - n);
        }
    }

    public void write(int n) throws IOException {
        if (this.fNumBytes + 3 >= this.fBuffer.length) {
            this.flushInternal();
        }
        if (n <= 127) {
            this.fBuffer[this.fNumBytes++] = (byte)n;
        } else if (n >= 128 && n <= 2047) {
            this.fBuffer[this.fNumBytes++] = (byte)(192 + (n >> 6));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n & 0x3F));
        } else {
            this.fBuffer[this.fNumBytes++] = (byte)(224 + (n >> 12));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n >> 6 & 0x3F));
            this.fBuffer[this.fNumBytes++] = (byte)(128 + (n & 0x3F));
        }
    }

    private void encodeAndWrite(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            char c = cArray[n3];
            if (c <= '\u007f') {
                this.fBuffer[this.fNumBytes++] = (byte)c;
            } else if (c >= '\u0080' && c <= '\u07ff') {
                this.fBuffer[this.fNumBytes++] = (byte)(192 + (c >> 6));
                this.fBuffer[this.fNumBytes++] = (byte)(128 + (c & 0x3F));
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c2 = cArray[++n3];
                int n4 = Encoding.toCodePoint(c, c2);
                this.fBuffer[this.fNumBytes++] = (byte)(240 + (n4 >> 18 & 0x1F));
                this.fBuffer[this.fNumBytes++] = (byte)(128 + (n4 >> 12 & 0x3F));
                this.fBuffer[this.fNumBytes++] = (byte)(128 + (n4 >> 6 & 0x3F));
                this.fBuffer[this.fNumBytes++] = (byte)(128 + (n4 & 0x3F));
            } else {
                this.fBuffer[this.fNumBytes++] = (byte)(224 + (c >> 12));
                this.fBuffer[this.fNumBytes++] = (byte)(128 + (c >> 6 & 0x3F));
                this.fBuffer[this.fNumBytes++] = (byte)(128 + (c & 0x3F));
            }
            ++n3;
        }
    }

    protected void release() {
        this.fInUse = false;
    }

    public static void release(UTF8Writer uTF8Writer) {
        uTF8Writer.reset(null);
        uTF8Writer.release();
    }
}

