/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.event;

import com.ibm.xml.xlxp.api.event.ScannerEvent;
import com.ibm.xml.xlxp.api.event.SimpleScannerEventQueue;
import com.ibm.xml.xlxp.scan.DTDScannerHelper;
import com.ibm.xml.xlxp.scan.DocumentEntityScanner;
import com.ibm.xml.xlxp.scan.util.DTDGrammar;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;

public class SimpleDTDScannerEventQueue
extends SimpleScannerEventQueue
implements DTDScannerHelper {
    protected ScannerEvent.Doctype fDoctypeProducer;
    protected ScannerEvent.Entity fStartEntityProducer;
    protected ScannerEvent.Entity fEndEntityProducer;
    protected ScannerEvent.Entity fEntityReferenceProducer;
    protected ScannerEvent.Doctype fDoctypeEvent;
    protected ScannerEvent.Entity fStartEntityEvent;
    protected ScannerEvent.Entity fEndEntityEvent;
    protected ScannerEvent.Entity fEntityReferenceEvent;
    private DTDGrammar fDTDGrammar;
    private boolean[] fInElementContentStack;

    public SimpleDTDScannerEventQueue() {
        this.initializeLocals();
    }

    public SimpleDTDScannerEventQueue(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory) {
        super(documentEntityScanner, dataBufferFactory);
        this.initializeLocals();
    }

    public SimpleDTDScannerEventQueue(DocumentEntityScanner documentEntityScanner, DataBufferFactory dataBufferFactory, SymbolTable symbolTable) {
        super(documentEntityScanner, dataBufferFactory, symbolTable);
        this.initializeLocals();
    }

    protected void initializeLocals() {
        this.fInElementContentStack = new boolean[16];
        this.fDoctypeEvent = this.createDoctypeEvent();
        this.fStartEntityEvent = this.createStartEntityEvent();
        this.fEndEntityEvent = this.createEndEntityEvent();
        this.fEntityReferenceEvent = this.createEntityReferenceEvent();
        this.fDoctypeProducer = this.createDoctypeProducer();
        this.fStartEntityProducer = this.createStartEntityProducer();
        this.fEndEntityProducer = this.createEndEntityProducer();
        this.fEntityReferenceProducer = this.createEntityReferenceProducer();
    }

    public void setEntityContent(ParsedEntity parsedEntity) {
        this.fCurrentEntityID = parsedEntity.id;
        this.fDocumentEntityScanner.setEntityContent(parsedEntity);
    }

    public void setNSDeclURI(int n, int n2) {
        this.fNamespaceContext.setNSDeclURI(this.fEventParams[this.fLastEventParam], n, n2);
    }

    public boolean addDefaultNSDecl(QName qName, XMLString xMLString) {
        if (this.fIsNamespaceAware) {
            this.processAttributeName(qName, false);
            return this.saveNamespaceDecl(qName, xMLString);
        }
        return this.addDefaultAttribute(qName, 14, xMLString);
    }

    public boolean addDefaultAttribute(QName qName, int n, XMLString xMLString) {
        this.processAttributeName(qName, false);
        this.fEventQNames[this.fCurAttName].setValues(qName);
        this.fEventParams[this.fCurAttParam] = n;
        this.fEventStrings[this.fCurAttVal].setValues(xMLString);
        return this.saveAttribute();
    }

    public void setGrammar(DTDGrammar dTDGrammar) {
        this.fDTDGrammar = dTDGrammar;
    }

    protected void pushElement(QName qName) {
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.fInElementContent = this.pushInElementContent(this.fDTDGrammar.hasElementContent(qName.handle));
        }
        super.pushElement(qName);
    }

    public QName popElement() {
        QName qName = super.popElement();
        if (this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements()) {
            this.fInElementContent = this.popInElementContent();
        }
        return qName;
    }

    protected boolean pushInElementContent(boolean bl) {
        if (this.fElementDepth == this.fInElementContentStack.length) {
            boolean[] blArray = new boolean[this.fElementDepth << 1];
            System.arraycopy(this.fInElementContentStack, 0, blArray, 0, this.fElementDepth);
            this.fInElementContentStack = blArray;
        }
        this.fInElementContentStack[this.fElementDepth] = this.fInElementContent;
        return bl;
    }

    protected boolean popInElementContent() {
        boolean bl = this.fInElementContentStack[this.fElementDepth];
        return bl;
    }

    public final XMLString rootElementTypeToProduce() {
        return this.fEventStrings[this.fLastEventString];
    }

    public final XMLString publicIDToProduce() {
        return this.fEventStrings[this.fLastEventString + 1];
    }

    public final XMLString systemIDToProduce() {
        return this.fEventStrings[this.fLastEventString + 2];
    }

    protected boolean commitDoctypeEvent(ScannerEvent.Doctype doctype, ScannerEvent.Doctype doctype2) {
        this.addStringsToQueue(3);
        this.addParamsToQueue(1);
        this.addEventToQueue(doctype);
        return false;
    }

    public final boolean produceDoctypeEvent(boolean bl) {
        this.fEventParams[this.fLastEventParam] = bl ? 1 : 0;
        return this.commitDoctypeEvent(this.fDoctypeEvent, this.fDoctypeProducer);
    }

    public final ScannerEvent.Doctype doctypeProducer() {
        return this.fDoctypeProducer;
    }

    private ScannerEvent.Doctype createDoctypeEvent() {
        DoctypeEvent doctypeEvent = new DoctypeEvent();
        return doctypeEvent;
    }

    private ScannerEvent.Doctype createDoctypeProducer() {
        DoctypeProducer doctypeProducer = new DoctypeProducer();
        return doctypeProducer;
    }

    protected boolean commitEntityEvent(ScannerEvent.Entity entity, ScannerEvent.Entity entity2) {
        this.addParamsToQueue(1);
        this.addStringsToQueue(1);
        this.addEventToQueue(entity);
        return true;
    }

    public final boolean produceStartEntityEvent(XMLString xMLString) {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        this.fEventStrings[this.fLastEventString].setValues(xMLString);
        return this.commitEntityEvent(this.fStartEntityEvent, this.fStartEntityProducer);
    }

    public final boolean produceEndEntityEvent(XMLString xMLString) {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        this.fEventStrings[this.fLastEventString].setValues(xMLString);
        return this.commitEntityEvent(this.fEndEntityEvent, this.fEndEntityProducer);
    }

    public final boolean produceEntityReferenceEvent(XMLString xMLString) {
        this.fEventParams[this.fLastEventParam] = this.fNamespaceContext.currentContext();
        this.fEventStrings[this.fLastEventString].setValues(xMLString);
        return this.commitEntityEvent(this.fEntityReferenceEvent, this.fEntityReferenceProducer);
    }

    public final ScannerEvent.Entity startEntityProducer() {
        return this.fStartEntityProducer;
    }

    public final ScannerEvent.Entity endEntityProducer() {
        return this.fEndEntityProducer;
    }

    public final ScannerEvent.Entity entityReferenceProducer() {
        return this.fEntityReferenceProducer;
    }

    private ScannerEvent.Entity createStartEntityEvent() {
        EntityEvent entityEvent = new EntityEvent(17);
        return entityEvent;
    }

    private ScannerEvent.Entity createEndEntityEvent() {
        EntityEvent entityEvent = new EntityEvent(18);
        return entityEvent;
    }

    private ScannerEvent.Entity createEntityReferenceEvent() {
        EntityEvent entityEvent = new EntityEvent(19);
        return entityEvent;
    }

    private ScannerEvent.Entity createStartEntityProducer() {
        EntityProducer entityProducer = new EntityProducer(17);
        return entityProducer;
    }

    private ScannerEvent.Entity createEndEntityProducer() {
        EntityProducer entityProducer = new EntityProducer(18);
        return entityProducer;
    }

    private ScannerEvent.Entity createEntityReferenceProducer() {
        EntityProducer entityProducer = new EntityProducer(19);
        return entityProducer;
    }

    protected final class EntityProducer
    extends ScannerEvent.Entity {
        public EntityProducer(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleDTDScannerEventQueue.this.fEventParams[SimpleDTDScannerEventQueue.this.fLastEventParam];
        }

        public XMLString entityName() {
            return SimpleDTDScannerEventQueue.this.fEventStrings[SimpleDTDScannerEventQueue.this.fLastEventString];
        }
    }

    protected final class EntityEvent
    extends ScannerEvent.Entity {
        public EntityEvent(int n) {
            super(n);
        }

        public int nsContext() {
            return SimpleDTDScannerEventQueue.this.fEventParams[SimpleDTDScannerEventQueue.this.fCurrentEventParam];
        }

        public XMLString entityName() {
            return SimpleDTDScannerEventQueue.this.fEventStrings[SimpleDTDScannerEventQueue.this.fCurrentEventString];
        }
    }

    protected final class DoctypeProducer
    extends ScannerEvent.Doctype {
        public XMLString rootElementType() {
            return SimpleDTDScannerEventQueue.this.fEventStrings[SimpleDTDScannerEventQueue.this.fLastEventString];
        }

        public XMLString publicID() {
            return SimpleDTDScannerEventQueue.this.fEventStrings[SimpleDTDScannerEventQueue.this.fLastEventString + 1];
        }

        public XMLString systemID() {
            return SimpleDTDScannerEventQueue.this.fEventStrings[SimpleDTDScannerEventQueue.this.fLastEventString + 2];
        }

        public boolean internalSubset() {
            return SimpleDTDScannerEventQueue.this.fEventParams[SimpleDTDScannerEventQueue.this.fLastEventParam] == 1;
        }
    }

    protected final class DoctypeEvent
    extends ScannerEvent.Doctype {
        public XMLString rootElementType() {
            return SimpleDTDScannerEventQueue.this.fEventStrings[SimpleDTDScannerEventQueue.this.fCurrentEventString];
        }

        public XMLString publicID() {
            XMLString xMLString = SimpleDTDScannerEventQueue.this.fEventStrings[SimpleDTDScannerEventQueue.this.fCurrentEventString + 1];
            if (xMLString.length == 0) {
                xMLString = null;
            }
            return xMLString;
        }

        public XMLString systemID() {
            XMLString xMLString = SimpleDTDScannerEventQueue.this.fEventStrings[SimpleDTDScannerEventQueue.this.fCurrentEventString + 2];
            if (xMLString.length == 0) {
                xMLString = null;
            }
            return xMLString;
        }

        public boolean internalSubset() {
            return SimpleDTDScannerEventQueue.this.fEventParams[SimpleDTDScannerEventQueue.this.fCurrentEventParam] == 1;
        }
    }
}

