/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.XMLString;

public final class QName {
    public byte[] bytes;
    public int startOffset;
    public int endOffset;
    public int length;
    public int handle;
    public int nsHandle;
    public int localHandle;
    public int prefixHandle;
    public DataBuffer firstBuffer;
    public DataBuffer lastBuffer;

    public QName() {
        this.handle = -1;
    }

    public QName(QName qName) {
        this.bytes = qName.bytes;
        this.startOffset = qName.startOffset;
        this.endOffset = qName.endOffset;
        this.length = qName.length;
        this.handle = qName.handle;
        this.nsHandle = qName.nsHandle;
        this.localHandle = qName.localHandle;
        this.prefixHandle = qName.prefixHandle;
        this.firstBuffer = qName.firstBuffer;
        this.lastBuffer = qName.lastBuffer;
        if (this.firstBuffer != null) {
            this.firstBuffer.addReference();
            if (this.lastBuffer != null) {
                DataBuffer dataBuffer = this.firstBuffer;
                do {
                    dataBuffer = dataBuffer.next;
                    dataBuffer.addReference();
                } while (dataBuffer != this.lastBuffer);
            }
        }
    }

    public void clear() {
        if (this.firstBuffer != null) {
            this.bytes = null;
            this.startOffset = 0;
            this.endOffset = 0;
            this.length = 0;
            this.handle = -1;
            this.nsHandle = 0;
            this.localHandle = 0;
            this.prefixHandle = 0;
            this.dropBufferReferences();
        }
    }

    private void dropBufferReferences() {
        if (this.lastBuffer == null) {
            this.firstBuffer.removeReference();
            this.firstBuffer = null;
        } else {
            DataBuffer dataBuffer;
            do {
                dataBuffer = this.firstBuffer;
                this.firstBuffer = dataBuffer.next;
                dataBuffer.removeReference();
            } while (dataBuffer != this.lastBuffer);
            this.firstBuffer = null;
            this.lastBuffer = null;
        }
    }

    private void setBufferAndReferences(DataBuffer dataBuffer) {
        dataBuffer.addReference();
        if (this.firstBuffer != null) {
            this.firstBuffer.removeReference();
        }
        this.firstBuffer = dataBuffer;
    }

    public void setValues(DataBuffer dataBuffer, int n, int n2) {
        if (this.lastBuffer == null && n < dataBuffer.endOffset) {
            if (dataBuffer != this.firstBuffer) {
                this.setBufferAndReferences(dataBuffer);
            }
            this.startOffset = n;
            this.endOffset = n2;
            this.length = n2 - n;
            this.bytes = dataBuffer.bytes;
        } else {
            this.setValuesSlowly(dataBuffer, n, n2);
        }
    }

    private void setValuesSlowly(DataBuffer dataBuffer, int n, int n2) {
        this.setStartPos(dataBuffer, n);
        this.setEndPos(dataBuffer, n2);
    }

    public void setStartPos(DataBuffer dataBuffer, int n) {
        if (dataBuffer == this.firstBuffer) {
            if (this.lastBuffer == null) {
                this.startOffset = n;
            } else {
                this.setStartPosClearLast(n);
            }
        } else {
            this.setStartPosNewBuffer(dataBuffer, n);
        }
    }

    private void setStartPosClearLast(int n) {
        this.lastBuffer.removeReference();
        this.lastBuffer = null;
        this.startOffset = n;
    }

    private void setStartPosNewBuffer(DataBuffer dataBuffer, int n) {
        dataBuffer.addReference();
        if (this.firstBuffer != null) {
            this.dropBufferReferences();
        }
        this.firstBuffer = dataBuffer;
        this.startOffset = n;
    }

    public void setEndPos(DataBuffer dataBuffer, int n) {
        if (this.startOffset < this.firstBuffer.endOffset && dataBuffer == this.firstBuffer) {
            this.endOffset = n;
            this.length = n - this.startOffset;
            this.bytes = dataBuffer.bytes;
        } else {
            this.setEndPosSpecial(dataBuffer, n);
        }
    }

    private void setEndPosSpecial(DataBuffer dataBuffer, int n) {
        if (this.startOffset < this.firstBuffer.endOffset) {
            if (n > dataBuffer.startOffset) {
                this.setEndPosAcrossBuffers(dataBuffer, n);
            } else {
                this.fixEndPos(dataBuffer);
            }
        } else {
            this.fixStartPos(dataBuffer, n);
        }
    }

    private void setEndPosAcrossBuffers(DataBuffer dataBuffer, int n) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        this.endOffset = n;
        this.length = dataBuffer2.endOffset - this.startOffset;
        dataBuffer2 = dataBuffer2.next;
        while (dataBuffer2 != dataBuffer) {
            dataBuffer2.addReference();
            this.length += dataBuffer2.endOffset - dataBuffer2.startOffset;
            dataBuffer2 = dataBuffer2.next;
        }
        this.length += n - dataBuffer2.startOffset;
        dataBuffer2.addReference();
        this.lastBuffer = dataBuffer2;
        this.bytes = null;
    }

    private void fixStartPos(DataBuffer dataBuffer, int n) {
        if (dataBuffer != this.firstBuffer) {
            DataBuffer dataBuffer2 = this.firstBuffer;
            this.firstBuffer = dataBuffer2.next;
            this.firstBuffer.addReference();
            dataBuffer2.removeReference();
            this.startOffset = this.firstBuffer.startOffset;
            this.setEndPos(dataBuffer, n);
        }
    }

    private void fixEndPos(DataBuffer dataBuffer) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        while (dataBuffer2.next != dataBuffer) {
            dataBuffer2 = dataBuffer2.next;
        }
        this.setEndPos(dataBuffer2, dataBuffer2.endOffset);
    }

    public void shareValues(XMLString xMLString) {
        if (this.bytes != null) {
            xMLString.setValues(this.firstBuffer, this.startOffset, this.endOffset, 0);
        } else if (this.firstBuffer != null) {
            xMLString.setValues(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, 0);
        } else {
            xMLString.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setValues(QName var1_1) {
        block13: {
            block11: {
                block15: {
                    block14: {
                        block12: {
                            if (var1_1 == null || var1_1.firstBuffer == null) break block11;
                            this.bytes = var1_1.bytes;
                            this.startOffset = var1_1.startOffset;
                            this.endOffset = var1_1.endOffset;
                            this.length = var1_1.length;
                            this.handle = var1_1.handle;
                            this.nsHandle = var1_1.nsHandle;
                            this.localHandle = var1_1.localHandle;
                            this.prefixHandle = var1_1.prefixHandle;
                            if (this.firstBuffer == var1_1.firstBuffer) break block12;
                            var2_2 = var1_1.firstBuffer;
                            if (var2_2 != null) {
                                var2_2.addReference();
                                if (var1_1.lastBuffer != null) {
                                    do {
                                        var2_2 = var2_2.next;
                                        var2_2.addReference();
                                    } while (var2_2 != var1_1.lastBuffer);
                                }
                            }
                            if (this.firstBuffer != null) {
                                this.dropBufferReferences();
                            }
                            this.firstBuffer = var1_1.firstBuffer;
                            this.lastBuffer = var1_1.lastBuffer;
                            break block13;
                        }
                        if (this.lastBuffer == var1_1.lastBuffer) break block13;
                        var2_3 = this.firstBuffer;
                        if (this.lastBuffer != null) break block14;
                        do {
                            var2_3 = var2_3.next;
                            var2_3.addReference();
                        } while (var2_3 != var1_1.lastBuffer);
                        break block15;
                    }
                    if (var1_1.lastBuffer != null) ** GOTO lbl44
                    var3_4 = var2_3.next;
                    do {
                        var2_3 = var3_4;
                        var3_4 = var2_3.next;
                        var2_3.removeReference();
                    } while (var2_3 != this.lastBuffer);
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        var2_3 = var2_3.next;
lbl44:
                        // 2 sources

                        ** while (var2_3 != this.lastBuffer && var2_3 != var1_1.lastBuffer)
                    }
lbl45:
                    // 1 sources

                    if (var2_3 == this.lastBuffer) {
                        do {
                            var2_3 = var2_3.next;
                            var2_3.addReference();
                        } while (var2_3 != var1_1.lastBuffer);
                    } else {
                        var3_5 = var2_3.next;
                        do {
                            var2_3 = var3_5;
                            var3_5 = var2_3.next;
                            var2_3.removeReference();
                        } while (var2_3 != this.lastBuffer);
                    }
                }
                this.lastBuffer = var1_1.lastBuffer;
                break block13;
            }
            this.clear();
        }
    }

    public int lengthAsCharacters(int[] nArray) {
        return UTF8Support.lengthAsCharacters(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, 0, nArray);
    }
}

