/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rpcadapter.annotations;

import com.ibm.websphere.rpcadapter.ConfigurationException;
import com.ibm.websphere.rpcadapter.Messages;
import com.ibm.websphere.rpcadapter.XmlConfigErrorHandler;
import com.ibm.websphere.rpcadapter.annotations.Method;
import com.ibm.websphere.rpcadapter.annotations.Params;
import com.ibm.websphere.rpcadapter.annotations.Pojo;
import com.ibm.websphere.rpcadapter.annotations.Pojos;
import com.ibm.websphere.rpcadapter.util.RPCAdapterConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class AnnotationParser
extends RPCAdapterConstants {
    private static Document doc = AnnotationParser.getDocument();
    private static String configFile = null;
    private static int counter1 = -1;
    private static int counter2 = -1;
    private static Element service = doc.createElementNS(SCHEMA_NAMESPACE, "services");
    private static Element rpcAdapter = doc.createElementNS(SCHEMA_NAMESPACE, "rpcAdapter");

    public static void main(String[] stringArray) {
    }

    public Document annotationParser(ServletConfig servletConfig) throws ConfigurationException {
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting method annotationParser of AnnotationParser");
        }
        Enumeration enumeration = servletConfig.getInitParameterNames();
        doc.appendChild(rpcAdapter);
        rpcAdapter.appendChild(service);
        configFile = servletConfig.getServletContext().getRealPath("/WEB-INF/RpcAdapterConfig.xml");
        if (configFile == null) {
            logger.error((Object)Messages.getMessage((String)"rpcadapter.msg.config_file"));
        }
        Boolean bl = false;
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                if (!string.toLowerCase().startsWith("class")) continue;
                String string2 = servletConfig.getInitParameter(string);
                Class<?> clazz = Class.forName(string2);
                this.printAnnotationsForClass(clazz);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error((Object)Messages.getMessage((String)"rpcadapter.msg.annotation_error"), (Throwable)classNotFoundException);
                throw new ConfigurationException(Messages.getMessage((String)"rpcadapter.msg.annotation_error"), (Throwable)classNotFoundException);
            }
        }
        if (bl.booleanValue()) {
            return AnnotationParser.writeOut(doc);
        }
        return null;
    }

    public void printAnnotationsForClass(Class clazz) {
        this.parseAnnotation(clazz);
    }

    public void parseAnnotation(Class clazz) {
        Class clazz2;
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting method parseAnnotation of AnnotationParser");
        }
        if ((clazz2 = clazz) != null && clazz2.isAnnotationPresent(Pojos.class)) {
            Pojos pojos = clazz2.getAnnotation(Pojos.class);
            Pojo[] pojoArray = pojos.pojo();
            for (int i = 0; i < pojoArray.length; ++i) {
                java.lang.reflect.Method[] methodArray;
                String string = pojoArray[i].id();
                this.buildPojoXml(pojoArray[i], clazz);
                for (java.lang.reflect.Method method : methodArray = clazz.getDeclaredMethods()) {
                    Method method2;
                    String string2;
                    if (!method.isAnnotationPresent(Method.class) || !(string2 = (method2 = method.getAnnotation(Method.class)).id()).equals(string)) continue;
                    this.buildMethodXml(method2);
                    if (!method.isAnnotationPresent(Params.class)) continue;
                    this.buildParamsXml(method);
                }
            }
        } else if (clazz2 != null && clazz2.isAnnotationPresent(Pojo.class)) {
            java.lang.reflect.Method[] methodArray;
            Pojo pojo = clazz2.getAnnotation(Pojo.class);
            this.buildPojoXml(pojo, clazz);
            for (java.lang.reflect.Method method : methodArray = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Method.class)) continue;
                Method method3 = method.getAnnotation(Method.class);
                this.buildMethodXml(method3);
                if (!method.isAnnotationPresent(Params.class)) continue;
                this.buildParamsXml(method);
            }
        } else {
            return;
        }
        if (this.isDebugEnabled) {
            logger.trace((Object)"End of method parseAnnotation of AnnotationParser");
        }
    }

    private void buildPojoXml(Pojo pojo, Class clazz) {
        Element element;
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting method buildPojoXml of AnnotationParser");
        }
        Element element2 = doc.createElementNS(SCHEMA_NAMESPACE, "pojo");
        service.appendChild(element2);
        String string = pojo.name();
        String string2 = pojo.filter();
        String string3 = pojo.description();
        String string4 = pojo.valref();
        String string5 = pojo.scope();
        String string6 = clazz.getCanonicalName();
        if (string2.equals("")) {
            string2 = "whitelisting";
        }
        Element element3 = doc.createElementNS(SCHEMA_NAMESPACE, "name");
        element3.setTextContent(string);
        element2.appendChild(element3);
        Element element4 = doc.createElementNS(SCHEMA_NAMESPACE, "implementation");
        element4.setTextContent(string6);
        element2.appendChild(element4);
        if (!string3.equals("")) {
            element = doc.createElementNS(SCHEMA_NAMESPACE, "description");
            element.setTextContent(string3);
            element2.appendChild(element);
        }
        if (!string4.equals("")) {
            element = doc.createElementNS(SCHEMA_NAMESPACE, "validator-ref");
            element.setTextContent(string4);
            element2.appendChild(element);
        }
        if (!string5.equals("")) {
            element = doc.createElementNS(SCHEMA_NAMESPACE, "scope");
            element.setTextContent(string5);
            element2.appendChild(element);
        }
        element = doc.createElementNS(SCHEMA_NAMESPACE, "methods");
        element.setAttribute("filter", string2);
        element2.appendChild(element);
        ++counter1;
    }

    private void buildMethodXml(Method method) {
        Element element;
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting method buildMethodXml of AnnotationParser");
        }
        String string = method.httpmethod();
        String string2 = method.name();
        String string3 = method.description();
        String string4 = method.addtosession();
        String string5 = method.securityroles();
        Element element2 = doc.createElementNS(SCHEMA_NAMESPACE, "method");
        Element element3 = doc.createElementNS(SCHEMA_NAMESPACE, "name");
        element3.setTextContent(string2);
        element2.appendChild(element3);
        if (!string3.equals("")) {
            element = doc.createElementNS(SCHEMA_NAMESPACE, "description");
            element.setTextContent(string3);
            element2.appendChild(element);
        }
        if (!string4.equals("")) {
            element = doc.createElementNS(SCHEMA_NAMESPACE, "add-to-session");
            element.setTextContent(string3);
            element2.appendChild(element);
        }
        if (!string5.equals("")) {
            element = doc.createElementNS(SCHEMA_NAMESPACE, "security-roles");
            element.setTextContent(string3);
            element2.appendChild(element);
        }
        element = doc.createElementNS(SCHEMA_NAMESPACE, "http-method");
        element.setTextContent(string);
        element2.appendChild(element);
        NodeList nodeList = doc.getElementsByTagName("methods");
        Element element4 = (Element)nodeList.item(counter1);
        element4.appendChild(element2);
        ++counter2;
    }

    private void buildParamsXml(java.lang.reflect.Method method) {
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting method buildParamsXml of AnnotationParser");
        }
        Params params = method.getAnnotation(Params.class);
        String[] stringArray = params.name();
        String string = params.description();
        String string2 = params.validatorref();
        if (stringArray.length != 0) {
            Element element;
            Element element2 = doc.createElementNS(SCHEMA_NAMESPACE, "parameters");
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3;
                element = doc.createElementNS(SCHEMA_NAMESPACE, "parameter");
                Element element4 = doc.createElementNS(SCHEMA_NAMESPACE, "name");
                element4.setTextContent(stringArray[i]);
                element.appendChild(element4);
                element2.appendChild(element);
                if (!string.equals("")) {
                    element3 = doc.createElementNS(SCHEMA_NAMESPACE, "description");
                    element3.setTextContent(string);
                    element.appendChild(element3);
                }
                if (string2.equals("")) continue;
                element3 = doc.createElementNS(SCHEMA_NAMESPACE, "validator-ref");
                element3.setTextContent(string);
                element.appendChild(element3);
            }
            NodeList nodeList = doc.getElementsByTagName("method");
            element = (Element)nodeList.item(counter2);
            element.appendChild(element2);
        }
    }

    private static Document getDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            doc = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return doc;
    }

    private static Document writeOut(Document document) throws ConfigurationException {
        Document document2 = null;
        try {
            document2 = AnnotationParser.getDocumentRoot();
            Element element = (Element)document.getElementsByTagNameNS(SCHEMA_NAMESPACE, "services").item(0);
            NodeList nodeList = element.getElementsByTagNameNS(SCHEMA_NAMESPACE, "pojo");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = document2.importNode(nodeList.item(i), true);
                if (document2.getDocumentElement().getElementsByTagNameNS(SCHEMA_NAMESPACE, "services").item(0) == null) {
                    document2.getDocumentElement().getElementsByTagNameNS(SCHEMA_NAMESPACE, "rpcAdapter").item(0).appendChild(service);
                }
                document2.getDocumentElement().getElementsByTagNameNS(SCHEMA_NAMESPACE, "services").item(0).appendChild(node);
            }
        }
        catch (SAXException sAXException) {
            logger.error((Object)Messages.getMessage((String)"rpcadapter.msg.config_file"), (Throwable)sAXException);
            throw new ConfigurationException(Messages.getMessage((String)"rpcadapter.msg.config_file"), (Throwable)sAXException);
        }
        catch (IOException iOException) {
            logger.error((Object)Messages.getMessage((String)"rpcadapter.msg.config_file"), (Throwable)iOException);
            throw new ConfigurationException(Messages.getMessage((String)"rpcadapter.msg.config_file"), (Throwable)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)Messages.getMessage((String)"rpcadapter.msg.dbf_error"), (Throwable)parserConfigurationException);
            throw new ConfigurationException(Messages.getMessage((String)"rpcadapter.msg.dbf_error"), (Throwable)parserConfigurationException);
        }
        return document2;
    }

    private static Document getDocumentRoot() throws SAXException, IOException, ParserConfigurationException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("RpcAdapterConfig.xsd");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", inputStream);
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler((ErrorHandler)new XmlConfigErrorHandler());
        Document document = documentBuilder.parse(configFile);
        return document;
    }
}

