/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.i18n.text.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import org.apache.abdera.i18n.text.io.PeekAheadInputStream;

public class CharsetSniffingInputStream
extends FilterInputStream {
    protected String encoding;
    protected boolean bomset = false;
    protected final boolean preserve;

    public CharsetSniffingInputStream(InputStream in) {
        this(in, true);
    }

    public CharsetSniffingInputStream(InputStream in, boolean preserveBom) {
        super(!(in instanceof PeekAheadInputStream) ? new PeekAheadInputStream(in, 4) : in);
        this.preserve = preserveBom;
        try {
            this.encoding = this.detectEncoding();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isBomSet() {
        return this.bomset;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected PeekAheadInputStream getInternal() {
        return (PeekAheadInputStream)this.in;
    }

    private static boolean equals(byte[] a1, int len, byte[] a2) {
        int n = 0;
        int i = 0;
        while (n < len) {
            if (a1[n] != a2[i]) {
                return false;
            }
            ++n;
            ++i;
        }
        return true;
    }

    protected String detectEncoding() throws IOException {
        PeekAheadInputStream pin = (PeekAheadInputStream)this.in;
        byte[] bom = new byte[4];
        pin.peek(bom);
        this.bomset = false;
        Encoding[] arr$ = Encoding.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Encoding enc = arr$[i$];
            int bomlen = enc.equals(bom);
            if (bomlen <= 0) continue;
            this.bomset = enc.getBom();
            if (this.bomset && !this.preserve) {
                pin.read(new byte[bomlen]);
            }
            return enc.getEncoding();
        }
        return null;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Encoding
    extends Enum<Encoding> {
        public static final /* enum */ Encoding UTF32be = new Encoding("UTF32be", 0, "UTF-32", true, new byte[][]{{0, 0, -2, -1}});
        public static final /* enum */ Encoding UTF32le = new Encoding("UTF32le", 1, "UTF-32", true, new byte[][]{{-1, -2, 0, 0}});
        public static final /* enum */ Encoding INVALID = new Encoding("INVALID", 2, null, true, {-2, -1, 0, 0}, {0, 0, -1, -2});
        public static final /* enum */ Encoding UTF16be = new Encoding("UTF16be", 3, "UTF-16", true, new byte[][]{{-2, -1}});
        public static final /* enum */ Encoding UTF16le = new Encoding("UTF16le", 4, "UTF-16", true, new byte[][]{{-1, -2}});
        public static final /* enum */ Encoding UTF8 = new Encoding("UTF8", 5, "UTF-8", true, new byte[][]{{-17, -69, -65}});
        public static final /* enum */ Encoding UTF32be2 = new Encoding("UTF32be2", 6, "UTF-32be", false, new byte[][]{{0, 0, 0, 60}});
        public static final /* enum */ Encoding UTF32le2 = new Encoding("UTF32le2", 7, "UTF-32le", false, new byte[][]{{60, 0, 0, 0}});
        public static final /* enum */ Encoding UTF16be2 = new Encoding("UTF16be2", 8, "UTF-16be", false, new byte[][]{{0, 60, 0, 63}});
        public static final /* enum */ Encoding UTF16le2 = new Encoding("UTF16le2", 9, "UTF-16le", false, new byte[][]{{60, 0, 63, 0}});
        private final String enc;
        private final byte[][] checks;
        private final boolean bom;
        private static final /* synthetic */ Encoding[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$i18n$text$io$CharsetSniffingInputStream$Encoding;

        public static final Encoding[] values() {
            return (Encoding[])$VALUES.clone();
        }

        public static Encoding valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$i18n$text$io$CharsetSniffingInputStream$Encoding;
            if (clazz == null) {
                clazz = class$org$apache$abdera$i18n$text$io$CharsetSniffingInputStream$Encoding = new Encoding[0].getClass().getComponentType();
            }
            return (Encoding)Enum.valueOf((Class)clazz, (String)name);
        }

        private Encoding(String string, int n, String name, boolean bom, byte[] ... checks) {
            super(string, n);
            this.enc = name;
            this.checks = checks;
            this.bom = bom;
        }

        public String getEncoding() {
            return this.enc;
        }

        public boolean getBom() {
            return this.bom;
        }

        public int equals(byte[] bom) {
            for (byte[] check : this.checks) {
                if (!CharsetSniffingInputStream.equals(bom, check.length, check)) continue;
                return check.length;
            }
            return 0;
        }

        static {
            $VALUES = new Encoding[]{UTF32be, UTF32le, INVALID, UTF16be, UTF16le, UTF8, UTF32be2, UTF32le2, UTF16be2, UTF16le2};
            Encoding[] encodingArray = Encoding.values();
            Class<?> clazz = class$org$apache$abdera$i18n$text$io$CharsetSniffingInputStream$Encoding;
            if (clazz == null) {
                clazz = class$org$apache$abdera$i18n$text$io$CharsetSniffingInputStream$Encoding = new Encoding[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])encodingArray, (Class)clazz);
        }
    }
}

