/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.i18n.text;

import java.io.IOException;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import org.apache.abdera.i18n.text.CharUtils;
import org.apache.abdera.i18n.text.Codepoint;
import org.apache.abdera.i18n.text.CodepointIterator;
import org.apache.abdera.i18n.text.data.UnicodeCharacterDatabase;

public final class Normalizer {
    private Normalizer() {
    }

    public static String normalize(CharSequence source) {
        return Normalizer.normalize(source, Form.KC);
    }

    public static String normalize(CharSequence source, Form form) {
        return Normalizer.normalize(source, form, new StringBuffer());
    }

    public static String normalize(CharSequence source, Form form, StringBuffer buf) {
        if (source.length() != 0) {
            try {
                Normalizer.decompose(source, form, buf);
                Normalizer.compose(form, buf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return buf.toString();
    }

    private static void decompose(CharSequence source, Form form, StringBuffer buf) throws IOException {
        StringBuffer internal = new StringBuffer();
        CodepointIterator ci = CodepointIterator.forCharSequence(source);
        boolean canonical = form.isCanonical();
        while (ci.hasNext()) {
            Codepoint c = ci.next();
            internal.setLength(0);
            UnicodeCharacterDatabase.decompose(c.getValue(), canonical, internal);
            CodepointIterator ii = CodepointIterator.forCharSequence(internal);
            while (ii.hasNext()) {
                Codepoint ch = ii.next();
                int i = Normalizer.findInsertionPoint(buf, ch.getValue());
                buf.insert(i, CharUtils.toString(ch.getValue()));
            }
        }
    }

    private static int findInsertionPoint(StringBuffer buf, int c) {
        int i;
        int cc = UnicodeCharacterDatabase.getCanonicalClass(c);
        if (cc != 0) {
            int ch;
            for (i = buf.length(); i > 0 && UnicodeCharacterDatabase.getCanonicalClass(ch = CharUtils.codepointAt(buf, i - 1).getValue()) > cc; i -= CharUtils.length(c)) {
            }
        }
        return i;
    }

    private static void compose(Form form, StringBuffer buf) throws IOException {
        int c;
        if (!form.isComposition()) {
            return;
        }
        int pos = 0;
        int lc = CharUtils.codepointAt(buf, pos).getValue();
        int cpos = CharUtils.length(lc);
        int lcc = UnicodeCharacterDatabase.getCanonicalClass(lc);
        if (lcc != 0) {
            lcc = 256;
        }
        int len = buf.length();
        for (int dpos = cpos; dpos < buf.length(); dpos += CharUtils.length(c)) {
            c = CharUtils.codepointAt(buf, dpos).getValue();
            int cc = UnicodeCharacterDatabase.getCanonicalClass(c);
            char composite = UnicodeCharacterDatabase.getPairComposition(lc, c);
            if (composite != '\uffff' && (lcc < cc || lcc == 0)) {
                CharUtils.setChar((CharSequence)buf, pos, composite);
                lc = composite;
                continue;
            }
            if (cc == 0) {
                pos = cpos;
                lc = c;
            }
            lcc = cc;
            CharUtils.setChar((CharSequence)buf, cpos, c);
            if (buf.length() != len) {
                dpos += buf.length() - len;
                len = buf.length();
            }
            cpos += CharUtils.length(c);
        }
        buf.setLength(cpos);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Form
    extends Enum<Form> {
        public static final /* enum */ Form D = new Form("D", 0, new Mask[0]);
        public static final /* enum */ Form C = new Form("C", 1, Mask.COMPOSITION);
        public static final /* enum */ Form KD = new Form("KD", 2, Mask.COMPATIBILITY);
        public static final /* enum */ Form KC = new Form("KC", 3, Mask.COMPATIBILITY, Mask.COMPOSITION);
        private int mask = 0;
        private static final /* synthetic */ Form[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$i18n$text$Normalizer$Form;

        public static final Form[] values() {
            return (Form[])$VALUES.clone();
        }

        public static Form valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$i18n$text$Normalizer$Form;
            if (clazz == null) {
                clazz = class$org$apache$abdera$i18n$text$Normalizer$Form = new Form[0].getClass().getComponentType();
            }
            return (Form)Enum.valueOf((Class)clazz, (String)name);
        }

        private Form(String string, int n, Mask ... masks) {
            super(string, n);
            for (Mask mask : masks) {
                this.mask |= mask.ordinal();
            }
        }

        public boolean isCompatibility() {
            return (this.mask & Mask.COMPATIBILITY.ordinal()) != 0;
        }

        public boolean isCanonical() {
            return !this.isCompatibility();
        }

        public boolean isComposition() {
            return (this.mask & Mask.COMPOSITION.ordinal()) != 0;
        }

        static {
            $VALUES = new Form[]{D, C, KD, KC};
            Form[] formArray = Form.values();
            Class<?> clazz = class$org$apache$abdera$i18n$text$Normalizer$Form;
            if (clazz == null) {
                clazz = class$org$apache$abdera$i18n$text$Normalizer$Form = new Form[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])formArray, (Class)clazz);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Mask
    extends Enum<Mask> {
        public static final /* enum */ Mask NONE = new Mask("NONE", 0);
        public static final /* enum */ Mask COMPATIBILITY = new Mask("COMPATIBILITY", 1);
        public static final /* enum */ Mask COMPOSITION = new Mask("COMPOSITION", 2);
        private static final /* synthetic */ Mask[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$i18n$text$Normalizer$Mask;

        public static final Mask[] values() {
            return (Mask[])$VALUES.clone();
        }

        public static Mask valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$i18n$text$Normalizer$Mask;
            if (clazz == null) {
                clazz = class$org$apache$abdera$i18n$text$Normalizer$Mask = new Mask[0].getClass().getComponentType();
            }
            return (Mask)Enum.valueOf((Class)clazz, (String)name);
        }

        private Mask(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new Mask[]{NONE, COMPATIBILITY, COMPOSITION};
            Mask[] maskArray = Mask.values();
            Class<?> clazz = class$org$apache$abdera$i18n$text$Normalizer$Mask;
            if (clazz == null) {
                clazz = class$org$apache$abdera$i18n$text$Normalizer$Mask = new Mask[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])maskArray, (Class)clazz);
        }
    }
}

