/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.i18n.text;

import java.util.Arrays;
import org.apache.abdera.i18n.text.CharUtils;
import org.apache.abdera.i18n.text.Codepoint;
import org.apache.abdera.i18n.text.CodepointIterator;
import org.apache.abdera.i18n.text.DelegatingCodepointIterator;
import org.apache.abdera.i18n.text.Filter;
import org.apache.abdera.i18n.text.Normalizer;

public class Nameprep {
    private static final int[] B1 = new int[]{128, 129, 134, 136, 139, 143, 160, 173, 847, 6150, 6155, 6156, 6157, 8203, 8204, 8205, 8288, 65024, 65025, 65026, 65027, 65028, 65029, 65030, 65031, 65032, 65033, 65034, 65035, 65036, 65037, 65038, 65039, 65279};
    private static final int[] PROHIBITED = new int[]{128, 161, 832, 834, 1757, 1758, 1807, 2064, 5760, 5761, 6158, 6159, 8192, 8208, 8232, 8234, 8234, 8240, 8287, 8288, 8288, 8292, 8298, 8304, 12272, 12284, 12288, 12289, 55296, 63744, 64976, 65008, 65279, 65280, 65529, 65534, 119155, 119163, 917505, 917506, 917536, 917632, 983040, 1048574, 0x100000, 1114110};
    private static final int[] RandAL = new int[]{1470, 1471, 1472, 1473, 1475, 1476, 1488, 1515, 1520, 1525, 1563, 1564, 1567, 1568, 1569, 1595, 1600, 1611, 1645, 1648, 1649, 1750, 1757, 1758, 1765, 1767, 1786, 1791, 1792, 1806, 1808, 1809, 1810, 1837, 1920, 1958, 1969, 1970, 8207, 8208, 64285, 64286, 64287, 64297, 64298, 64311, 64312, 64317, 64318, 64319, 64320, 64322, 64323, 64325, 64326, 64434, 64467, 64830, 64848, 64912, 64914, 64968, 65008, 65021, 65136, 65141, 65142, 65277};
    private static final int[] notLCat = new int[]{0, 65, 91, 97, 123, 170, 171, 181, 182, 186, 187, 192, 215, 216, 247, 248, 545, 546, 564, 592, 686, 688, 697, 699, 706, 720, 722, 736, 741, 750, 751, 890, 891, 902, 903, 904, 907, 908, 909, 910, 930, 931, 975, 976, 1014, 1024, 1155, 1162, 1231, 1232, 1270, 1272, 1274, 1280, 1296, 1329, 1367, 1369, 1376, 1377, 1416, 1417, 1418, 2307, 2308, 2309, 2362, 2365, 2369, 2377, 2381, 2384, 2385, 2392, 2402, 2404, 2417, 2434, 2436, 2437, 2445, 2447, 2449, 2451, 2473, 2474, 2481, 2482, 2483, 2486, 2490, 2494, 2497, 2503, 2505, 2507, 2509, 2519, 2520, 2524, 2526, 2527, 2530, 2534, 2546, 2548, 2555, 2565, 2571, 2575, 2577, 2579, 2601, 2602, 2609, 2610, 2612, 2613, 2615, 2616, 2618, 2622, 2625, 2649, 2653, 2654, 2655, 2662, 2672, 2674, 2677, 2691, 2692, 2693, 2700, 2701, 2702, 2703, 2706, 2707, 2729, 2730, 2737, 2738, 2740, 2741, 2746, 2749, 2753, 2761, 2762, 2763, 2765, 2768, 2769, 2784, 2785, 2790, 2800, 2818, 2820, 2821, 2829, 2831, 2833, 2835, 2857, 2858, 2865, 2866, 2868, 2870, 2874, 2877, 2879, 2880, 2881, 2887, 2889, 2891, 2893, 2903, 2904, 2908, 2910, 2911, 2914, 2918, 2929, 2947, 2948, 2949, 2955, 2958, 2961, 2962, 2966, 2969, 2971, 2972, 2973, 2974, 2976, 2979, 2981, 2984, 2987, 2990, 2998, 2999, 3002, 3006, 3008, 3009, 3011, 3014, 3017, 3018, 3021, 3031, 3032, 3047, 3059, 3073, 3076, 3077, 3085, 3086, 3089, 3090, 3113, 3114, 3124, 3125, 3130, 3137, 3141, 3168, 3170, 3174, 3184, 3202, 3204, 3205, 3213, 3214, 3217, 3218, 3241, 3242, 3252, 3253, 3258, 3262, 3263, 3264, 3269, 3271, 3273, 3274, 3276, 3285, 3287, 3294, 3295, 3296, 3298, 3302, 3312, 3330, 3332, 3333, 3341, 3342, 3345, 3346, 3369, 3370, 3386, 3390, 3393, 3398, 3401, 3402, 3405, 3415, 3416, 3424, 3426, 3430, 3440, 3458, 3460, 3461, 3479, 3482, 3506, 3507, 3516, 3517, 3518, 3520, 3527, 3535, 3538, 3544, 3552, 3570, 3573, 3585, 3633, 3634, 3636, 3648, 3655, 3663, 3676, 3713, 3715, 3716, 3717, 3719, 3721, 3722, 3723, 3725, 3726, 3732, 3736, 3737, 3744, 3745, 3748, 3749, 3750, 3751, 3752, 3754, 3756, 3757, 3761, 3762, 3764, 3773, 3774, 3776, 3781, 3782, 3783, 3792, 3802, 3804, 3806, 3840, 3864, 3866, 3893, 3894, 3895, 3896, 3897, 3902, 3912, 3913, 3947, 3967, 3968, 3973, 3974, 3976, 3980, 4030, 4038, 4039, 4045, 4047, 4048, 4096, 4130, 4131, 4136, 4137, 4139, 4140, 4141, 4145, 4146, 4152, 4153, 4160, 4184, 4256, 4294, 4304, 4345, 4347, 4348, 4352, 4442, 4447, 4515, 4520, 4602, 4608, 4615, 4616, 4679, 4680, 4681, 4682, 4686, 4688, 4695, 4696, 4697, 4698, 4702, 4704, 4743, 4744, 4745, 4746, 4750, 4752, 4783, 4784, 4785, 4786, 4790, 4792, 4799, 4800, 4801, 4802, 4806, 4808, 4815, 4816, 4823, 4824, 4847, 4848, 4879, 4880, 4881, 4882, 4886, 4888, 4895, 4896, 4935, 4936, 4955, 4961, 4989, 5024, 5109, 5121, 5751, 5761, 5787, 5792, 5873, 5888, 5901, 5902, 5906, 5920, 5938, 5941, 5943, 5952, 5970, 5984, 5997, 5998, 6001, 6016, 6071, 6078, 6086, 6087, 6089, 6100, 6107, 6108, 6109, 6112, 6122, 6160, 6170, 6176, 6264, 6272, 6313, 7680, 7836, 7840, 7930, 7936, 7958, 7960, 7966, 7968, 8006, 8008, 8014, 8016, 8024, 8025, 8026, 8027, 8028, 8029, 8030, 8031, 8062, 8064, 8117, 8118, 8125, 8126, 8127, 8130, 8133, 8134, 8141, 8144, 8148, 8150, 8156, 8160, 8173, 8178, 8181, 8182, 8189, 8206, 8207, 8305, 8306, 8319, 8320, 8450, 8451, 8455, 8456, 8458, 8468, 8469, 8470, 8473, 8478, 8484, 8485, 8486, 8487, 8488, 8489, 8490, 8494, 8495, 8498, 8499, 8506, 8509, 8512, 8517, 8522, 8544, 8580, 9014, 9083, 9109, 9110, 9372, 9450, 12293, 12296, 12321, 12330, 12337, 12342, 12344, 12349, 12353, 12439, 12445, 12448, 12449, 12539, 12540, 12544, 12549, 12589, 12593, 12687, 12688, 12728, 12784, 12829, 12832, 12868, 12896, 12924, 12927, 12977, 12992, 13004, 13008, 13055, 13056, 13175, 13179, 13278, 13280, 13311, 13312, 19894, 19968, 40870, 40960, 42125, 44032, 55204, 55296, 64046, 64048, 64107, 64256, 64263, 64275, 64280, 65313, 65339, 65345, 65371, 65382, 65471, 65474, 65480, 65482, 65488, 65490, 65496, 65498, 65501, 66304, 66335, 66336, 66340, 66352, 66379, 66560, 66598, 66600, 66638, 118784, 119030, 119040, 119079, 119082, 119143, 119146, 119155, 119171, 119173, 119180, 119210, 119214, 119262, 119808, 119893, 119894, 119965, 119966, 119968, 119970, 119971, 119973, 119975, 119977, 119981, 119982, 119994, 119995, 119996, 119997, 120001, 120002, 120004, 120005, 120070, 120071, 120075, 120077, 120085, 120086, 120093, 120094, 120122, 120123, 120127, 120128, 120133, 120134, 120135, 120138, 120145, 120146, 120484, 120488, 120778, 131072, 173783, 194560, 195102, 983040, 1048574, 0x100000, 1114110};
    public static final int[] b2index = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 181, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 216, 217, 218, 219, 220, 221, 222, 223, 256, 258, 260, 262, 264, 266, 268, 270, 272, 274, 276, 278, 280, 282, 284, 286, 288, 290, 292, 294, 296, 298, 300, 302, 304, 306, 308, 310, 313, 315, 317, 319, 321, 323, 325, 327, 329, 330, 332, 334, 336, 338, 340, 342, 344, 346, 348, 350, 352, 354, 356, 358, 360, 362, 364, 366, 368, 370, 372, 374, 376, 377, 379, 381, 383, 385, 386, 388, 390, 391, 393, 394, 395, 398, 399, 400, 401, 403, 404, 406, 407, 408, 412, 413, 415, 416, 418, 420, 422, 423, 425, 428, 430, 431, 433, 434, 435, 437, 439, 440, 444, 452, 453, 455, 456, 458, 459, 461, 463, 465, 467, 469, 471, 473, 475, 478, 480, 482, 484, 486, 488, 490, 492, 494, 496, 497, 498, 500, 502, 503, 504, 506, 508, 510, 512, 514, 516, 518, 520, 522, 524, 526, 528, 530, 532, 534, 536, 538, 540, 542, 544, 546, 548, 550, 552, 554, 556, 558, 560, 562, 837, 890, 902, 904, 905, 906, 908, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 944, 962, 976, 977, 978, 979, 980, 981, 982, 984, 986, 988, 990, 992, 994, 996, 998, 1000, 1002, 1004, 1006, 1008, 1009, 1010, 1012, 1013, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1120, 1122, 1124, 1126, 1128, 1130, 1132, 1134, 1136, 1138, 1140, 1142, 1144, 1146, 1148, 1150, 1152, 1162, 1164, 1166, 1168, 1170, 1172, 1174, 1176, 1178, 1180, 1182, 1184, 1186, 1188, 1190, 1192, 1194, 1196, 1198, 1200, 1202, 1204, 1206, 1208, 1210, 1212, 1214, 1217, 1219, 1221, 1223, 1225, 1227, 1229, 1232, 1234, 1236, 1238, 1240, 1242, 1244, 1246, 1248, 1250, 1252, 1254, 1256, 1258, 1260, 1262, 1264, 1266, 1268, 1272, 1280, 1282, 1284, 1286, 1288, 1290, 1292, 1294, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1415, 7680, 7682, 7684, 7686, 7688, 7690, 7692, 7694, 7696, 7698, 7700, 7702, 7704, 7706, 7708, 7710, 7712, 7714, 7716, 7718, 7720, 7722, 7724, 7726, 7728, 7730, 7732, 7734, 7736, 7738, 7740, 7742, 7744, 7746, 7748, 7750, 7752, 7754, 7756, 7758, 7760, 7762, 7764, 7766, 7768, 7770, 7772, 7774, 7776, 7778, 7780, 7782, 7784, 7786, 7788, 7790, 7792, 7794, 7796, 7798, 7800, 7802, 7804, 7806, 7808, 7810, 7812, 7814, 7816, 7818, 7820, 7822, 7824, 7826, 7828, 7830, 7831, 7832, 7833, 7834, 7835, 7840, 7842, 7844, 7846, 7848, 7850, 7852, 7854, 7856, 7858, 7860, 7862, 7864, 7866, 7868, 7870, 7872, 7874, 7876, 7878, 7880, 7882, 7884, 7886, 7888, 7890, 7892, 7894, 7896, 7898, 7900, 7902, 7904, 7906, 7908, 7910, 7912, 7914, 7916, 7918, 7920, 7922, 7924, 7926, 7928, 7944, 7945, 7946, 7947, 7948, 7949, 7950, 7951, 7960, 7961, 7962, 7963, 7964, 7965, 7976, 7977, 7978, 7979, 7980, 7981, 7982, 7983, 7992, 7993, 7994, 7995, 7996, 7997, 7998, 7999, 8008, 8009, 8010, 8011, 8012, 8013, 8016, 8018, 8020, 8022, 8025, 8027, 8029, 8031, 8040, 8041, 8042, 8043, 8044, 8045, 8046, 8047, 8064, 8065, 8066, 8067, 8068, 8069, 8070, 8071, 8072, 8073, 8074, 8075, 8076, 8077, 8078, 8079, 8080, 8081, 8082, 8083, 8084, 8085, 8086, 8087, 8088, 8089, 8090, 8091, 8092, 8093, 8094, 8095, 8096, 8097, 8098, 8099, 8100, 8101, 8102, 8103, 8104, 8105, 8106, 8107, 8108, 8109, 8110, 8111, 8114, 8115, 8116, 8118, 8119, 8120, 8121, 8122, 8123, 8124, 8126, 8130, 8131, 8132, 8134, 8135, 8136, 8137, 8138, 8139, 8140, 8146, 8147, 8150, 8151, 8152, 8153, 8154, 8155, 8162, 8163, 8164, 8166, 8167, 8168, 8169, 8170, 8171, 8172, 8178, 8179, 8180, 8182, 8183, 8184, 8185, 8186, 8187, 8188, 8360, 8450, 8451, 8455, 8457, 8459, 8460, 8461, 8464, 8465, 8466, 8469, 8470, 8473, 8474, 8475, 8476, 8477, 8480, 8481, 8482, 8484, 8486, 8488, 8490, 8491, 8492, 8493, 8496, 8497, 8499, 8510, 8511, 8517, 8544, 8545, 8546, 8547, 8548, 8549, 8550, 8551, 8552, 8553, 8554, 8555, 8556, 8557, 8558, 8559, 9398, 9399, 9400, 9401, 9402, 9403, 9404, 9405, 9406, 9407, 9408, 9409, 9410, 9411, 9412, 9413, 9414, 9415, 9416, 9417, 9418, 9419, 9420, 9421, 9422, 9423, 13169, 13171, 13173, 13184, 13185, 13186, 13187, 13188, 13189, 13190, 13191, 13194, 13195, 13196, 13200, 13201, 13202, 13203, 13204, 13225, 13226, 13227, 13228, 13236, 13237, 13238, 13239, 13240, 13241, 13242, 13243, 13244, 13245, 13246, 13247, 13248, 13249, 13251, 13254, 13255, 13256, 13257, 13259, 13261, 13262, 13271, 13273, 13274, 13276, 13277, 64256, 64257, 64258, 64259, 64260, 64261, 64262, 64275, 64276, 64277, 64278, 64279, 65313, 65314, 65315, 65316, 65317, 65318, 65319, 65320, 65321, 65322, 65323, 65324, 65325, 65326, 65327, 65328, 65329, 65330, 65331, 65332, 65333, 65334, 65335, 65336, 65337, 65338, 66560, 66561, 66562, 66563, 66564, 66565, 66566, 66567, 66568, 66569, 66570, 66571, 66572, 66573, 66574, 66575, 66576, 66577, 66578, 66579, 66580, 66581, 66582, 66583, 66584, 66585, 66586, 66587, 66588, 66589, 66590, 66591, 66592, 66593, 66594, 66595, 66596, 66597, 119808, 119809, 119810, 119811, 119812, 119813, 119814, 119815, 119816, 119817, 119818, 119819, 119820, 119821, 119822, 119823, 119824, 119825, 119826, 119827, 119828, 119829, 119830, 119831, 119832, 119833, 119860, 119861, 119862, 119863, 119864, 119865, 119866, 119867, 119868, 119869, 119870, 119871, 119872, 119873, 119874, 119875, 119876, 119877, 119878, 119879, 119880, 119881, 119882, 119883, 119884, 119885, 119912, 119913, 119914, 119915, 119916, 119917, 119918, 119919, 119920, 119921, 119922, 119923, 119924, 119925, 119926, 119927, 119928, 119929, 119930, 119931, 119932, 119933, 119934, 119935, 119936, 119937, 119964, 119966, 119967, 119970, 119973, 119974, 119977, 119978, 119979, 119980, 119982, 119983, 119984, 119985, 119986, 119987, 119988, 119989, 120016, 120017, 120018, 120019, 120020, 120021, 120022, 120023, 120024, 120025, 120026, 120027, 120028, 120029, 120030, 120031, 120032, 120033, 120034, 120035, 120036, 120037, 120038, 120039, 120040, 120041, 120068, 120069, 120071, 120072, 120073, 120074, 120077, 120078, 120079, 120080, 120081, 120082, 120083, 120084, 120086, 120087, 120088, 120089, 120090, 120091, 120092, 120120, 120121, 120123, 120124, 120125, 120126, 120128, 120129, 120130, 120131, 120132, 120134, 120138, 120139, 120140, 120141, 120142, 120143, 120144, 120172, 120173, 120174, 120175, 120176, 120177, 120178, 120179, 120180, 120181, 120182, 120183, 120184, 120185, 120186, 120187, 120188, 120189, 120190, 120191, 120192, 120193, 120194, 120195, 120196, 120197, 120224, 120225, 120226, 120227, 120228, 120229, 120230, 120231, 120232, 120233, 120234, 120235, 120236, 120237, 120238, 120239, 120240, 120241, 120242, 120243, 120244, 120245, 120246, 120247, 120248, 120249, 120276, 120277, 120278, 120279, 120280, 120281, 120282, 120283, 120284, 120285, 120286, 120287, 120288, 120289, 120290, 120291, 120292, 120293, 120294, 120295, 120296, 120297, 120298, 120299, 120300, 120301, 120328, 120329, 120330, 120331, 120332, 120333, 120334, 120335, 120336, 120337, 120338, 120339, 120340, 120341, 120342, 120343, 120344, 120345, 120346, 120347, 120348, 120349, 120350, 120351, 120352, 120353, 120380, 120381, 120382, 120383, 120384, 120385, 120386, 120387, 120388, 120389, 120390, 120391, 120392, 120393, 120394, 120395, 120396, 120397, 120398, 120399, 120400, 120401, 120402, 120403, 120404, 120405, 120432, 120433, 120434, 120435, 120436, 120437, 120438, 120439, 120440, 120441, 120442, 120443, 120444, 120445, 120446, 120447, 120448, 120449, 120450, 120451, 120452, 120453, 120454, 120455, 120456, 120457, 120488, 120489, 120490, 120491, 120492, 120493, 120494, 120495, 120496, 120497, 120498, 120499, 120500, 120501, 120502, 120503, 120504, 120505, 120506, 120507, 120508, 120509, 120510, 120511, 120512, 120531, 120546, 120547, 120548, 120549, 120550, 120551, 120552, 120553, 120554, 120555, 120556, 120557, 120558, 120559, 120560, 120561, 120562, 120563, 120564, 120565, 120566, 120567, 120568, 120569, 120570, 120589, 120604, 120605, 120606, 120607, 120608, 120609, 120610, 120611, 120612, 120613, 120614, 120615, 120616, 120617, 120618, 120619, 120620, 120621, 120622, 120623, 120624, 120625, 120626, 120627, 120628, 120647, 120662, 120663, 120664, 120665, 120666, 120667, 120668, 120669, 120670, 120671, 120672, 120673, 120674, 120675, 120676, 120677, 120678, 120679, 120680, 120681, 120682, 120683, 120684, 120685, 120686, 120705, 120720, 120721, 120722, 120723, 120724, 120725, 120726, 120727, 120728, 120729, 120730, 120731, 120732, 120733, 120734, 120735, 120736, 120737, 120738, 120739, 120740, 120741, 120742, 120743, 120744, 120763};
    public static final int[][] b2data = new int[][]{{97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {956}, {224}, {225}, {226}, {227}, {228}, {229}, {230}, {231}, {232}, {233}, {234}, {235}, {236}, {237}, {238}, {239}, {240}, {241}, {242}, {243}, {244}, {245}, {246}, {248}, {249}, {250}, {251}, {252}, {253}, {254}, {115, 115}, {257}, {259}, {261}, {263}, {265}, {267}, {269}, {271}, {273}, {275}, {277}, {279}, {281}, {283}, {285}, {287}, {289}, {291}, {293}, {295}, {297}, {299}, {301}, {303}, {105, 775}, {307}, {309}, {311}, {314}, {316}, {318}, {320}, {322}, {324}, {326}, {328}, {700, 110}, {331}, {333}, {335}, {337}, {339}, {341}, {343}, {345}, {347}, {349}, {351}, {353}, {355}, {357}, {359}, {361}, {363}, {365}, {367}, {369}, {371}, {373}, {375}, {255}, {378}, {380}, {382}, {115}, {595}, {387}, {389}, {596}, {392}, {598}, {599}, {396}, {477}, {601}, {603}, {402}, {608}, {611}, {617}, {616}, {409}, {623}, {626}, {629}, {417}, {419}, {421}, {640}, {424}, {643}, {429}, {648}, {432}, {650}, {651}, {436}, {438}, {658}, {441}, {445}, {454}, {454}, {457}, {457}, {460}, {460}, {462}, {464}, {466}, {468}, {470}, {472}, {474}, {476}, {479}, {481}, {483}, {485}, {487}, {489}, {491}, {493}, {495}, {106, 780}, {499}, {499}, {501}, {405}, {447}, {505}, {507}, {509}, {511}, {513}, {515}, {517}, {519}, {521}, {523}, {525}, {527}, {529}, {531}, {533}, {535}, {537}, {539}, {541}, {543}, {414}, {547}, {549}, {551}, {553}, {555}, {557}, {559}, {561}, {563}, {953}, {32, 953}, {940}, {941}, {942}, {943}, {972}, {973}, {974}, {953, 776, 769}, {945}, {946}, {947}, {948}, {949}, {950}, {951}, {952}, {953}, {954}, {955}, {956}, {957}, {958}, {959}, {960}, {961}, {963}, {964}, {965}, {966}, {967}, {968}, {969}, {970}, {971}, {965, 776, 769}, {963}, {946}, {952}, {965}, {973}, {971}, {966}, {960}, {985}, {987}, {989}, {991}, {993}, {995}, {997}, {999}, {1001}, {1003}, {1005}, {1007}, {954}, {961}, {963}, {952}, {949}, {1104}, {1105}, {1106}, {1107}, {1108}, {1109}, {1110}, {1111}, {1112}, {1113}, {1114}, {1115}, {1116}, {1117}, {1118}, {1119}, {1072}, {1073}, {1074}, {1075}, {1076}, {1077}, {1078}, {1079}, {1080}, {1081}, {1082}, {1083}, {1084}, {1085}, {1086}, {1087}, {1088}, {1089}, {1090}, {1091}, {1092}, {1093}, {1094}, {1095}, {1096}, {1097}, {1098}, {1099}, {1100}, {1101}, {1102}, {1103}, {1121}, {1123}, {1125}, {1127}, {1129}, {1131}, {1133}, {1135}, {1137}, {1139}, {1141}, {1143}, {1145}, {1147}, {1149}, {1151}, {1153}, {1163}, {1165}, {1167}, {1169}, {1171}, {1173}, {1175}, {1177}, {1179}, {1181}, {1183}, {1185}, {1187}, {1189}, {1191}, {1193}, {1195}, {1197}, {1199}, {1201}, {1203}, {1205}, {1207}, {1209}, {1211}, {1213}, {1215}, {1218}, {1220}, {1222}, {1224}, {1226}, {1228}, {1230}, {1233}, {1235}, {1237}, {1239}, {1241}, {1243}, {1245}, {1247}, {1249}, {1251}, {1253}, {1255}, {1257}, {1259}, {1261}, {1263}, {1265}, {1267}, {1269}, {1273}, {1281}, {1283}, {1285}, {1287}, {1289}, {1291}, {1293}, {1295}, {1377}, {1378}, {1379}, {1380}, {1381}, {1382}, {1383}, {1384}, {1385}, {1386}, {1387}, {1388}, {1389}, {1390}, {1391}, {1392}, {1393}, {1394}, {1395}, {1396}, {1397}, {1398}, {1399}, {1400}, {1401}, {1402}, {1403}, {1404}, {1405}, {1406}, {1407}, {1408}, {1409}, {1410}, {1411}, {1412}, {1413}, {1414}, {1381, 1410}, {7681}, {7683}, {7685}, {7687}, {7689}, {7691}, {7693}, {7695}, {7697}, {7699}, {7701}, {7703}, {7705}, {7707}, {7709}, {7711}, {7713}, {7715}, {7717}, {7719}, {7721}, {7723}, {7725}, {7727}, {7729}, {7731}, {7733}, {7735}, {7737}, {7739}, {7741}, {7743}, {7745}, {7747}, {7749}, {7751}, {7753}, {7755}, {7757}, {7759}, {7761}, {7763}, {7765}, {7767}, {7769}, {7771}, {7773}, {7775}, {7777}, {7779}, {7781}, {7783}, {7785}, {7787}, {7789}, {7791}, {7793}, {7795}, {7797}, {7799}, {7801}, {7803}, {7805}, {7807}, {7809}, {7811}, {7813}, {7815}, {7817}, {7819}, {7821}, {7823}, {7825}, {7827}, {7829}, {104, 817}, {116, 776}, {119, 778}, {121, 778}, {97, 702}, {7777}, {7841}, {7843}, {7845}, {7847}, {7849}, {7851}, {7853}, {7855}, {7857}, {7859}, {7861}, {7863}, {7865}, {7867}, {7869}, {7871}, {7873}, {7875}, {7877}, {7879}, {7881}, {7883}, {7885}, {7887}, {7889}, {7891}, {7893}, {7895}, {7897}, {7899}, {7901}, {7903}, {7905}, {7907}, {7909}, {7911}, {7913}, {7915}, {7917}, {7919}, {7921}, {7923}, {7925}, {7927}, {7929}, {7936}, {7937}, {7938}, {7939}, {7940}, {7941}, {7942}, {7943}, {7952}, {7953}, {7954}, {7955}, {7956}, {7957}, {7968}, {7969}, {7970}, {7971}, {7972}, {7973}, {7974}, {7975}, {7984}, {7985}, {7986}, {7987}, {7988}, {7989}, {7990}, {7991}, {8000}, {8001}, {8002}, {8003}, {8004}, {8005}, {965, 787}, {965, 787, 768}, {965, 787, 769}, {965, 787, 834}, {8017}, {8019}, {8021}, {8023}, {8032}, {8033}, {8034}, {8035}, {8036}, {8037}, {8038}, {8039}, {7936, 953}, {7937, 953}, {7938, 953}, {7939, 953}, {7940, 953}, {7941, 953}, {7942, 953}, {7943, 953}, {7936, 953}, {7937, 953}, {7938, 953}, {7939, 953}, {7940, 953}, {7941, 953}, {7942, 953}, {7943, 953}, {7968, 953}, {7969, 953}, {7970, 953}, {7971, 953}, {7972, 953}, {7973, 953}, {7974, 953}, {7975, 953}, {7968, 953}, {7969, 953}, {7970, 953}, {7971, 953}, {7972, 953}, {7973, 953}, {7974, 953}, {7975, 953}, {8032, 953}, {8033, 953}, {8034, 953}, {8035, 953}, {8036, 953}, {8037, 953}, {8038, 953}, {8039, 953}, {8032, 953}, {8033, 953}, {8034, 953}, {8035, 953}, {8036, 953}, {8037, 953}, {8038, 953}, {8039, 953}, {8048, 953}, {945, 953}, {940, 953}, {945, 834}, {945, 834, 953}, {8112}, {8113}, {8048}, {8049}, {945, 953}, {953}, {8052, 953}, {951, 953}, {942, 953}, {951, 834}, {951, 834, 953}, {8050}, {8051}, {8052}, {8053}, {951, 953}, {953, 776, 768}, {953, 776, 769}, {953, 834}, {953, 776, 834}, {8144}, {8145}, {8054}, {8055}, {965, 776, 768}, {965, 776, 769}, {961, 787}, {965, 834}, {965, 776, 834}, {8160}, {8161}, {8058}, {8059}, {8165}, {8060, 953}, {969, 953}, {974, 953}, {969, 834}, {969, 834, 953}, {8056}, {8057}, {8060}, {8061}, {969, 953}, {114, 115}, {99}, {176, 99}, {603}, {176, 102}, {104}, {104}, {104}, {105}, {105}, {108}, {110}, {110, 111}, {112}, {113}, {114}, {114}, {114}, {115, 109}, {116, 101, 108}, {116, 109}, {122}, {969}, {122}, {107}, {229}, {98}, {99}, {101}, {102}, {109}, {947}, {960}, {100}, {8560}, {8561}, {8562}, {8563}, {8564}, {8565}, {8566}, {8567}, {8568}, {8569}, {8570}, {8571}, {8572}, {8573}, {8574}, {8575}, {9424}, {9425}, {9426}, {9427}, {9428}, {9429}, {9430}, {9431}, {9432}, {9433}, {9434}, {9435}, {9436}, {9437}, {9438}, {9439}, {9440}, {9441}, {9442}, {9443}, {9444}, {9445}, {9446}, {9447}, {9448}, {9449}, {104, 112, 97}, {97, 117}, {111, 118}, {112, 97}, {110, 97}, {956, 97}, {109, 97}, {107, 97}, {107, 98}, {109, 98}, {103, 98}, {112, 102}, {110, 102}, {956, 102}, {104, 122}, {107, 104, 122}, {109, 104, 122}, {103, 104, 122}, {116, 104, 122}, {112, 97}, {107, 112, 97}, {109, 112, 97}, {103, 112, 97}, {112, 118}, {110, 118}, {956, 118}, {109, 118}, {107, 118}, {109, 118}, {112, 119}, {110, 119}, {956, 119}, {109, 119}, {107, 119}, {109, 119}, {107, 969}, {109, 969}, {98, 113}, {99, 8725, 107, 103}, {99, 111, 46}, {100, 98}, {103, 121}, {104, 112}, {107, 107}, {107, 109}, {112, 104}, {112, 112, 109}, {112, 114}, {115, 118}, {119, 98}, {102, 102}, {102, 105}, {102, 108}, {102, 102, 105}, {102, 102, 108}, {115, 116}, {115, 116}, {1396, 1398}, {1396, 1381}, {1396, 1387}, {1406, 1398}, {1396, 1389}, {65345}, {65346}, {65347}, {65348}, {65349}, {65350}, {65351}, {65352}, {65353}, {65354}, {65355}, {65356}, {65357}, {65358}, {65359}, {65360}, {65361}, {65362}, {65363}, {65364}, {65365}, {65366}, {65367}, {65368}, {65369}, {65370}, {66600}, {66601}, {66602}, {66603}, {66604}, {66605}, {66606}, {66607}, {66608}, {66609}, {66610}, {66611}, {66612}, {66613}, {66614}, {66615}, {66616}, {66617}, {66618}, {66619}, {66620}, {66621}, {66622}, {66623}, {66624}, {66625}, {66626}, {66627}, {66628}, {66629}, {66630}, {66631}, {66632}, {66633}, {66634}, {66635}, {66636}, {66637}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {99}, {100}, {103}, {106}, {107}, {110}, {111}, {112}, {113}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {100}, {101}, {102}, {103}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {97}, {98}, {100}, {101}, {102}, {103}, {105}, {106}, {107}, {108}, {109}, {111}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {97}, {98}, {99}, {100}, {101}, {102}, {103}, {104}, {105}, {106}, {107}, {108}, {109}, {110}, {111}, {112}, {113}, {114}, {115}, {116}, {117}, {118}, {119}, {120}, {121}, {122}, {945}, {946}, {947}, {948}, {949}, {950}, {951}, {952}, {953}, {954}, {955}, {956}, {957}, {958}, {959}, {960}, {961}, {952}, {963}, {964}, {965}, {966}, {967}, {968}, {969}, {963}, {945}, {946}, {947}, {948}, {949}, {950}, {951}, {952}, {953}, {954}, {955}, {956}, {957}, {958}, {959}, {960}, {961}, {952}, {963}, {964}, {965}, {966}, {967}, {968}, {969}, {963}, {945}, {946}, {947}, {948}, {949}, {950}, {951}, {952}, {953}, {954}, {955}, {956}, {957}, {958}, {959}, {960}, {961}, {952}, {963}, {964}, {965}, {966}, {967}, {968}, {969}, {963}, {945}, {946}, {947}, {948}, {949}, {950}, {951}, {952}, {953}, {954}, {955}, {956}, {957}, {958}, {959}, {960}, {961}, {952}, {963}, {964}, {965}, {966}, {967}, {968}, {969}, {963}, {945}, {946}, {947}, {948}, {949}, {950}, {951}, {952}, {953}, {954}, {955}, {956}, {957}, {958}, {959}, {960}, {961}, {952}, {963}, {964}, {965}, {966}, {967}, {968}, {969}, {963}};

    public static String prep(String s) {
        NameprepCodepointIterator r = null;
        try {
            StringBuffer buf = new StringBuffer();
            CodepointIterator ci = CodepointIterator.forCharSequence(s);
            r = new NameprepCodepointIterator(ci);
            while (r.hasNext()) {
                Codepoint cp = r.next();
                int i = cp != null ? cp.getValue() : -1;
                if (i == -1) continue;
                CharUtils.append(buf, cp);
            }
            String n = Normalizer.normalize(buf.toString(), Normalizer.Form.KC).toString();
            CharUtils.verify(CodepointIterator.forCharSequence(n), new Filter(){

                public boolean accept(int c) {
                    return Nameprep.isProhibited(c);
                }
            });
            return n;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static final int[] B2(int c) {
        int i = Arrays.binarySearch(b2index, c);
        return i > -1 ? b2data[i] : null;
    }

    public static boolean isB1(int c) {
        return Arrays.binarySearch(B1, c) > -1;
    }

    public static boolean isProhibited(int c) {
        if ((c & 0xFFFF) == 65535) {
            return true;
        }
        if ((c & 0xFFFE) == 65534) {
            return true;
        }
        return CharUtils.invset_contains(PROHIBITED, c);
    }

    public static boolean isRandAL(int c) {
        return CharUtils.invset_contains(RandAL, c);
    }

    public static boolean isLCat(int c) {
        return !CharUtils.invset_contains(notLCat, c);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class NameprepCodepointIterator
    extends DelegatingCodepointIterator {
        private int[] rep = null;
        private int reppos = 0;
        private boolean haslcat = false;
        private boolean hasrandalcat = false;
        private boolean firstisrandalcat = false;

        public boolean hasNext() {
            return this.rep != null || super.hasNext();
        }

        protected NameprepCodepointIterator(CodepointIterator internal) {
            super(internal);
        }

        public Codepoint next() {
            int r = -1;
            if (this.rep == null) {
                r = super.next().getValue();
                if (r != -1) {
                    int[] rep;
                    if (Nameprep.isLCat(r)) {
                        this.haslcat = true;
                    }
                    if (Nameprep.isRandAL(r)) {
                        this.hasrandalcat = true;
                        if (this.position() == 1) {
                            this.firstisrandalcat = true;
                        }
                    }
                    if (this.haslcat && this.hasrandalcat) {
                        throw new RuntimeException("Bidi Exception");
                    }
                    while (r != -1 && Nameprep.isB1(r)) {
                        Codepoint cp = super.next();
                        r = cp != null ? cp.getValue() : -1;
                    }
                    if (r != -1 && (rep = Nameprep.B2(r)) != null) {
                        if (rep.length > 1) {
                            this.rep = rep;
                            this.reppos = 0;
                        }
                        r = rep[0];
                    }
                }
            } else {
                r = this.rep[++this.reppos];
                if (this.reppos + 1 >= this.rep.length) {
                    this.rep = null;
                }
            }
            if (!(r != -1 && this.hasNext() || !this.hasrandalcat || this.firstisrandalcat && Nameprep.isRandAL(r == -1 ? this.peek(this.position()).getValue() : r))) {
                throw new RuntimeException("Bidi Exception");
            }
            return r != -1 ? new Codepoint(r) : null;
        }

        public char[] nextChars() {
            return super.nextChars();
        }

        public Object next() {
            return this.next();
        }
    }
}

