/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.File;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactoryFinder;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SchemaFactory {
    private static final String DEFAULT_SCHEMA_FACTORY_W3C = "org.apache.xerces.jaxp.validation.XMLSchemaFactory";
    private static final String PROPERTY_NAME = "javax.xml.validation.SchemaFactory";

    protected SchemaFactory() {
    }

    public static final SchemaFactory newInstance(String string) {
        if (string == null) {
            throw new NullPointerException("schemaLanguage should not be null in SchemaFactory.newInstance(String schemaLanguage)");
        }
        try {
            return (SchemaFactory)SchemaFactoryFinder.find(PROPERTY_NAME, string, DEFAULT_SCHEMA_FACTORY_W3C);
        }
        catch (SchemaFactoryFinder.ConfigurationError configurationError) {
            throw new IllegalArgumentException(configurationError.getMessage());
        }
    }

    public abstract boolean isSchemaLanguageSupported(String var1);

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException();
        }
        throw new SAXNotRecognizedException(string);
    }

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract ErrorHandler getErrorHandler();

    public abstract void setResourceResolver(LSResourceResolver var1);

    public abstract LSResourceResolver getResourceResolver();

    public abstract Schema newSchema(Source[] var1) throws SAXException;

    public abstract Schema newSchema() throws SAXException;

    public Schema newSchema(Source source) throws SAXException {
        if (source == null) {
            throw new NullPointerException();
        }
        return this.newSchema(new Source[]{source});
    }

    public Schema newSchema(File file) throws SAXException {
        if (file == null) {
            throw new NullPointerException();
        }
        return this.newSchema(new StreamSource(file));
    }

    public Schema newSchema(URL uRL) throws SAXException {
        if (uRL == null) {
            throw new NullPointerException();
        }
        return this.newSchema(new StreamSource(uRL.toString()));
    }
}

