/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.xml.internal;

import com.ibm.json.xml.internal.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JSONSAXHandler
extends DefaultHandler {
    private static String className = "com.ibm.json.xml.transform.impl.JSONSAXHandler";
    private static Logger logger = Logger.getLogger(className, null);
    private OutputStreamWriter osWriter = null;
    private JSONObject current = null;
    private Stack previousObjects = new Stack();
    private JSONObject head = null;
    private boolean compact = false;

    public JSONSAXHandler(OutputStream outputStream) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "JSONHander(OutputStream) <constructor>");
        }
        this.osWriter = new OutputStreamWriter(outputStream, "UTF-8");
        this.compact = true;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "JSONHander(OutputStream) <constructor>");
        }
    }

    public JSONSAXHandler(OutputStream outputStream, boolean bl) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "JSONHander(OutputStream, boolean) <constructor>");
        }
        this.osWriter = new OutputStreamWriter(outputStream, "UTF-8");
        boolean bl2 = this.compact = !bl;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "JSONHander(OutputStream, boolean) <constructor>");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "startElement(String,String,String,org.xml.sax.Attributes)");
        }
        Properties properties = new Properties();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            properties.put(attributes.getQName(i), attributes.getValue(i));
        }
        JSONObject jSONObject = new JSONObject(string2, properties);
        if (this.head == null) {
            this.current = this.head = jSONObject;
        } else {
            if (this.current != null) {
                this.previousObjects.push(this.current);
                this.current.addJSONObject(jSONObject);
            }
            this.current = jSONObject;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "startElement(String,String,String,org.xml.sax.Attributes)");
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "endElement(String,String,String)");
        }
        this.current = !this.previousObjects.isEmpty() ? (JSONObject)this.previousObjects.pop() : null;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "endElement(String,String,String)");
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "characters(char[], int, int)");
        }
        String string = new String(cArray, n, n2);
        if (this.current.getTagText() != null) {
            string = this.current.getTagText() + string;
        }
        this.current.setTagText(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "characters(char[], int, int)");
        }
    }

    public void startDocument() throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "startDocument()");
        }
        this.startJSON();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "startDocument()");
        }
    }

    public void endDocument() throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "endDocument()");
        }
        this.endJSON();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "endDocument()");
        }
    }

    public void flushBuffer() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "flushBuffer()");
        }
        if (this.osWriter != null) {
            this.osWriter.flush();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "flushBuffer()");
        }
    }

    private void startJSON() throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "startJSON()");
        }
        this.current = this.head = new JSONObject("", null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "startJSON()");
        }
    }

    private void endJSON() throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "endJSON()");
        }
        try {
            this.head.writeObject(this.osWriter, 0, true, this.compact);
            this.head = null;
            this.current = null;
            this.previousObjects.clear();
        }
        catch (Exception exception) {
            SAXException sAXException = new SAXException(exception);
            sAXException.initCause(exception);
            throw sAXException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "endJSON()");
        }
    }
}

