/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.xml.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSONObject {
    private static String className = "com.ibm.json.xml.internal.JSONObject";
    private static Logger logger = Logger.getLogger(className, null);
    private static final String indent = "   ";
    private String objectName = null;
    private Properties attrs = null;
    private Hashtable jsonObjects = null;
    private String tagText = null;

    public JSONObject(String string, Properties properties) {
        this.objectName = string;
        this.attrs = properties;
        this.jsonObjects = new Hashtable();
    }

    public void addJSONObject(JSONObject jSONObject) {
        Vector<JSONObject> vector;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "addJSONObject(JSONObject)");
        }
        if ((vector = (Vector<JSONObject>)this.jsonObjects.get(jSONObject.objectName)) != null) {
            vector.add(jSONObject);
        } else {
            vector = new Vector<JSONObject>();
            vector.add(jSONObject);
            this.jsonObjects.put(jSONObject.objectName, vector);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "addJSONObject(JSONObject)");
        }
    }

    public void setTagText(String string) {
        this.tagText = string;
    }

    public String getTagText() {
        return this.tagText;
    }

    public void writeObject(Writer writer, int n, boolean bl) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeObject(Writer, int, boolean)");
        }
        this.writeObject(writer, n, bl, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeObject(Writer, int, boolean)");
        }
    }

    public void writeObject(Writer writer, int n, boolean bl, boolean bl2) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeObject(Writer, int, boolean, boolean)");
        }
        if (writer != null) {
            try {
                if (this.isEmptyObject()) {
                    this.writeEmptyObject(writer, n, bl, bl2);
                }
                if (this.isTextOnlyObject()) {
                    this.writeTextOnlyObject(writer, n, bl, bl2);
                }
                this.writeComplexObject(writer, n, bl, bl2);
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Error occurred on serialization of JSON text.");
                iOException.initCause(exception);
                throw iOException;
            }
        } else {
            throw new IOException("The writer cannot be null.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeObject(Writer, int, boolean, boolean)");
        }
    }

    private void writeAttribute(Writer writer, String string, String string2, int n, boolean bl) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeAttribute(Writer, String, String, int)");
        }
        if (!bl) {
            this.writeIndention(writer, n);
        }
        try {
            if (!bl) {
                writer.write("\"" + string + "\"" + " : " + "\"" + this.escapeStringSpecialCharacters(string2) + "\"");
            } else {
                writer.write("\"" + string + "\"" + ":" + "\"" + this.escapeStringSpecialCharacters(string2) + "\"");
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error occurred on serialization of JSON text.");
            iOException.initCause(exception);
            throw iOException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeAttribute(Writer, String, String, int)");
        }
    }

    private void writeIndention(Writer writer, int n) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeIndention(Writer, int)");
        }
        try {
            for (int i = 0; i < n; ++i) {
                writer.write(indent);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error occurred on serialization of JSON text.");
            iOException.initCause(exception);
            throw iOException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeIndention(Writer, int)");
        }
    }

    private void writeAttributes(Writer writer, Properties properties, int n, boolean bl) throws IOException {
        Enumeration<?> enumeration;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeAttributes(Writer, Properties, int, boolean)");
        }
        if (properties != null && (enumeration = properties.propertyNames()) != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.writeAttribute(writer, this.escapeAttributeNameSpecialCharacters(string), (String)properties.get(string), n + 1, bl);
                if (!enumeration.hasMoreElements()) continue;
                try {
                    if (!bl) {
                        writer.write(",\n");
                        continue;
                    }
                    writer.write(",");
                }
                catch (Exception exception) {
                    IOException iOException = new IOException("Error occurred on serialization of JSON text.");
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeAttributes(Writer, Properties, int, boolean)");
        }
    }

    private String escapeAttributeNameSpecialCharacters(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer("");
            block3: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ':': {
                        stringBuffer.append("_ns-sep_");
                        continue block3;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private String escapeStringSpecialCharacters(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "escapeStringSpecialCharacters(String)");
        }
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer("");
            block9: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\"': {
                        stringBuffer.append("\\\"");
                        continue block9;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        continue block9;
                    }
                    case '\b': {
                        stringBuffer.append("\\b");
                        continue block9;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block9;
                    }
                    case '\f': {
                        stringBuffer.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        continue block9;
                    }
                    case '/': {
                        stringBuffer.append("\\/");
                        continue block9;
                    }
                    default: {
                        if (c >= ' ' && c <= '~') {
                            stringBuffer.append(c);
                            continue block9;
                        }
                        stringBuffer.append("\\u");
                        StringBuffer stringBuffer2 = new StringBuffer(Integer.toHexString(c));
                        while (stringBuffer2.length() < 4) {
                            stringBuffer2.insert(0, '0');
                        }
                        stringBuffer.append(stringBuffer2.toString());
                    }
                }
            }
            string = stringBuffer.toString();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "escapeStringSpecialCharacters(String)");
        }
        return string;
    }

    private void writeChildren(Writer writer, int n, boolean bl) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeChildren(Writer, int, boolean)");
        }
        if (!this.jsonObjects.isEmpty()) {
            Enumeration enumeration = this.jsonObjects.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                Vector vector = (Vector)this.jsonObjects.get(string);
                if (vector == null || vector.isEmpty()) continue;
                if (vector.size() == 1) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, className, "writeChildren(Writer, int, boolean)", "Writing child object: [" + string + "]");
                    }
                    JSONObject jSONObject = (JSONObject)vector.elementAt(0);
                    jSONObject.writeObject(writer, n + 1, false, bl);
                    if (enumeration.hasMoreElements()) {
                        try {
                            if (!bl) {
                                if (!jSONObject.isTextOnlyObject() && !jSONObject.isEmptyObject()) {
                                    this.writeIndention(writer, n + 1);
                                }
                                writer.write(",\n");
                                continue;
                            }
                            writer.write(",");
                            continue;
                        }
                        catch (Exception exception) {
                            IOException iOException = new IOException("Error occurred on serialization of JSON text.");
                            iOException.initCause(exception);
                            throw iOException;
                        }
                    }
                    if (!jSONObject.isTextOnlyObject() || bl) continue;
                    writer.write("\n");
                    continue;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, className, "writeChildren(Writer, int, boolean)", "Writing array of JSON objects with attribute name: [" + string + "]");
                }
                try {
                    if (!bl) {
                        this.writeIndention(writer, n + 1);
                        writer.write("\"" + string + "\"");
                        writer.write(" : [\n");
                    } else {
                        writer.write("\"" + string + "\"");
                        writer.write(":[");
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        object = (JSONObject)vector.elementAt(i);
                        ((JSONObject)object).writeObject(writer, n + 2, true, bl);
                        if (i == vector.size() - 1) continue;
                        if (!bl) {
                            if (!super.isTextOnlyObject() && !super.isEmptyObject()) {
                                this.writeIndention(writer, n + 2);
                            }
                            writer.write(",\n");
                            continue;
                        }
                        writer.write(",");
                    }
                    if (!bl) {
                        writer.write("\n");
                        this.writeIndention(writer, n + 1);
                    }
                    writer.write("]");
                    if (enumeration.hasMoreElements()) {
                        writer.write(",");
                    }
                    if (bl) continue;
                    writer.write("\n");
                }
                catch (Exception exception) {
                    object = new IOException("Error occurred on serialization of JSON text.");
                    ((Throwable)object).initCause(exception);
                    throw object;
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeChildren(Writer, int, boolean)");
        }
    }

    private void writeEmptyObject(Writer writer, int n, boolean bl, boolean bl2) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeEmptyObject(Writer, int, boolean, boolean)");
        }
        if (!bl) {
            if (!bl2) {
                this.writeIndention(writer, n);
                writer.write("\"" + this.objectName + "\"");
                writer.write(" : true");
            } else {
                writer.write("\"" + this.objectName + "\"");
                writer.write(":true");
            }
        } else if (!bl2) {
            this.writeIndention(writer, n);
            writer.write("true");
        } else {
            writer.write("true");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeEmptyObject(Writer, int, boolean, boolean)");
        }
    }

    private void writeTextOnlyObject(Writer writer, int n, boolean bl, boolean bl2) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeTextOnlyObject(Writer, int, boolean, boolean)");
        }
        if (!bl) {
            this.writeAttribute(writer, this.objectName, this.tagText.trim(), n, bl2);
        } else if (!bl2) {
            this.writeIndention(writer, n);
            writer.write("\"" + this.escapeStringSpecialCharacters(this.tagText.trim()) + "\"");
        } else {
            writer.write("\"" + this.escapeStringSpecialCharacters(this.tagText.trim()) + "\"");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeTextOnlyObject(Writer, int, boolean, boolean)");
        }
    }

    private void writeComplexObject(Writer writer, int n, boolean bl, boolean bl2) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "writeComplexObject(Writer, int, boolean, boolean)");
        }
        boolean bl3 = false;
        if (!bl) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "writeComplexObject(Writer, int, boolean, boolean)", "Writing object: [" + this.objectName + "]");
            }
            if (!bl2) {
                this.writeIndention(writer, n);
            }
            writer.write("\"" + this.objectName + "\"");
            if (!bl2) {
                writer.write(" : {\n");
            } else {
                writer.write(":{");
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "writeObject(Writer, int, boolean, boolean)", "Writing object contents as an anonymous object (usually an array entry)");
            }
            if (!bl2) {
                this.writeIndention(writer, n);
                writer.write("{\n");
            } else {
                writer.write("{");
            }
        }
        if (this.tagText != null && !this.tagText.equals("") && !this.tagText.trim().equals("")) {
            this.writeAttribute(writer, "content", this.tagText.trim(), n + 1, bl2);
            bl3 = true;
        }
        if (this.attrs != null && !this.attrs.isEmpty() && bl3) {
            if (!bl2) {
                writer.write(",\n");
            } else {
                writer.write(",");
            }
        }
        this.writeAttributes(writer, this.attrs, n, bl2);
        if (!this.jsonObjects.isEmpty()) {
            if (this.attrs != null && (!this.attrs.isEmpty() || bl3)) {
                if (!bl2) {
                    writer.write(",\n");
                } else {
                    writer.write(",");
                }
            } else if (!bl2) {
                writer.write("\n");
            }
            this.writeChildren(writer, n, bl2);
        } else if (!bl2) {
            writer.write("\n");
        }
        if (!bl2) {
            this.writeIndention(writer, n);
            writer.write("}\n");
        } else {
            writer.write("}");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "writeComplexObject(Writer, int, boolean, boolean)");
        }
    }

    private boolean isEmptyObject() {
        boolean bl = false;
        if ((this.attrs == null || this.attrs != null && this.attrs.isEmpty()) && this.jsonObjects.isEmpty() && (this.tagText == null || this.tagText != null && this.tagText.trim().equals(""))) {
            bl = true;
        }
        return bl;
    }

    private boolean isTextOnlyObject() {
        boolean bl = false;
        if ((this.attrs == null || this.attrs != null && this.attrs.isEmpty()) && this.jsonObjects.isEmpty() && this.tagText != null && !this.tagText.trim().equals("")) {
            bl = true;
        }
        return bl;
    }
}

