/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.contrib.rss;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import javax.xml.namespace.QName;
import org.apache.abdera.contrib.rss.RssCategory;
import org.apache.abdera.contrib.rss.RssChannel;
import org.apache.abdera.contrib.rss.RssConstants;
import org.apache.abdera.contrib.rss.RssFeed;
import org.apache.abdera.contrib.rss.RssGuid;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Control;
import org.apache.abdera.model.DateTime;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.abdera.model.IRIElement;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Source;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.stax.util.FOMElementIterator;
import org.apache.abdera.parser.stax.util.FOMHelper;
import org.apache.abdera.parser.stax.util.FOMList;
import org.apache.abdera.util.Constants;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssItem
extends ExtensibleElementWrapper
implements Entry,
IRIElement {
    private static final /* synthetic */ Class class$org$apache$abdera$contrib$rss$RssCategory;

    public RssItem(Element internal) {
        super(internal);
    }

    public RssItem(Factory factory, QName qname) {
        super(factory, qname);
    }

    public Entry addAuthor(Person person) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Person addAuthor(String name) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Person addAuthor(String name, String email, String uri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry addCategory(Category category) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Category addCategory(String term) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Category addCategory(String scheme, String term, String label) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry addContributor(Person person) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Person addContributor(String name) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Person addContributor(String name, String email, String uri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry addLink(Link link) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link addLink(String href) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link addLink(String href, String rel) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link addLink(String href, String rel, String type, String title, String hreflang, long length) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link getAlternateLink() {
        IRIElement guid;
        Link link = (Link)this.getExtension(RssConstants.QNAME_LINK);
        if (link == null) {
            link = (Link)this.getExtension(RssConstants.QNAME_RDF_LINK);
        }
        if (link == null && (guid = this.getIdElement()) != null && guid instanceof RssGuid && ((RssGuid)guid).isPermalink()) {
            return (Link)guid;
        }
        return link;
    }

    public Link getAlternateLink(String type, String hreflang) {
        return this.getAlternateLink();
    }

    public IRI getAlternateLinkResolvedHref() {
        Link link = this.getAlternateLink();
        return link != null ? link.getResolvedHref() : null;
    }

    public IRI getAlternateLinkResolvedHref(String type, String hreflang) {
        return this.getAlternateLinkResolvedHref();
    }

    public Person getAuthor() {
        Person person = (Person)this.getExtension(RssConstants.QNAME_AUTHOR);
        if (person == null) {
            person = (Person)this.getExtension(RssConstants.QNAME_DC_CREATOR);
        }
        return person;
    }

    public List<Person> getAuthors() {
        List people = this.getExtensions(RssConstants.QNAME_AUTHOR);
        if (people == null || people.size() == 0) {
            people = this.getExtensions(RssConstants.QNAME_DC_CREATOR);
        }
        return people;
    }

    public List<Category> getCategories() {
        List cats = this.getExtensions(RssConstants.QNAME_CATEGORY);
        if (cats == null || cats.size() == 0) {
            cats = this.getExtensions(RssConstants.QNAME_DC_SUBJECT);
        }
        return cats;
    }

    public List<Category> getCategories(String scheme) {
        Object object;
        if (scheme != null) {
            Element element = this.getInternal();
            Class<?> clazz = class$org$apache$abdera$contrib$rss$RssCategory;
            if (clazz == null) {
                clazz = class$org$apache$abdera$contrib$rss$RssCategory = new RssCategory[0].getClass().getComponentType();
            }
            object = new FOMList((Iterator)new FOMElementIterator(element, clazz, new QName("domain"), scheme, null));
        } else {
            object = this.getCategories();
        }
        return object;
    }

    public String getContent() {
        Content content = this.getContentElement();
        if (content == null) {
            return this.getSummary();
        }
        return content.getValue();
    }

    public Content getContentElement() {
        Content content = (Content)this.getExtension(RssConstants.QNAME_CONTENT_ENCODED);
        if (content == null) {
            content = (Content)this.getExtension(Constants.CONTENT);
        }
        return content;
    }

    public MimeType getContentMimeType() {
        return null;
    }

    public IRI getContentSrc() {
        return null;
    }

    public InputStream getContentStream() throws IOException {
        return null;
    }

    public Content.Type getContentType() {
        Content content = this.getContentElement();
        if (content == null) {
            Text text = this.getSummaryElement();
            switch (text.getTextType()) {
                case TEXT: {
                    return Content.Type.TEXT;
                }
                case HTML: {
                    return Content.Type.HTML;
                }
                case XHTML: {
                    return Content.Type.XHTML;
                }
            }
            return Content.Type.HTML;
        }
        return content.getContentType();
    }

    public List<Person> getContributors() {
        List people = this.getExtensions(RssConstants.QNAME_DC_CONTRIBUTOR);
        return people;
    }

    public Control getControl(boolean create) {
        return null;
    }

    public Control getControl() {
        return null;
    }

    public Link getEditLink() {
        return null;
    }

    public IRI getEditLinkResolvedHref() {
        return null;
    }

    public Link getEditMediaLink() {
        return null;
    }

    public Link getEditMediaLink(String type, String hreflang) {
        return null;
    }

    public IRI getEditMediaLinkResolvedHref() {
        return null;
    }

    public IRI getEditMediaLinkResolvedHref(String type, String hreflang) {
        return null;
    }

    public Date getEdited() {
        return null;
    }

    public DateTime getEditedElement() {
        return null;
    }

    public Link getEnclosureLink() {
        return (Link)this.getExtension(RssConstants.QNAME_ENCLOSURE);
    }

    public IRI getEnclosureLinkResolvedHref() {
        Link link = this.getEnclosureLink();
        return link != null ? link.getHref() : null;
    }

    public IRI getId() {
        IRIElement iri = this.getIdElement();
        return iri != null ? iri.getValue() : null;
    }

    public IRIElement getIdElement() {
        IRIElement id = (IRIElement)this.getExtension(RssConstants.QNAME_GUID);
        if (id == null) {
            id = (IRIElement)this.getExtension(RssConstants.QNAME_DC_IDENTIFIER);
        }
        if (id == null && this.getQName().equals(RssConstants.QNAME_RDF_ITEM)) {
            return this;
        }
        return id;
    }

    public Link getLink(String rel) {
        if (rel.equals("alternate") || rel.equals("http://www.iana.org/assignments/relation/alternate")) {
            RssGuid guid = (RssGuid)this.getIdElement();
            if (guid != null && guid.isPermalink()) {
                return guid;
            }
            return this.getAlternateLink();
        }
        List links = FOMHelper.getLinks((Element)this.getInternal(), (String)rel);
        return links != null && links.size() > 0 ? (Link)links.get(0) : null;
    }

    public IRI getLinkResolvedHref(String rel) {
        Link link = this.getLink(rel);
        return link != null ? link.getResolvedHref() : null;
    }

    public List<Link> getLinks() {
        return this.getExtensions(Constants.LINK);
    }

    public List<Link> getLinks(String rel) {
        return FOMHelper.getLinks((Element)this.getInternal(), (String)rel);
    }

    public List<Link> getLinks(String ... rel) {
        return FOMHelper.getLinks((Element)this.getInternal(), (String[])rel);
    }

    public Date getPublished() {
        DateTime dt = this.getPublishedElement();
        return dt != null ? dt.getDate() : null;
    }

    public DateTime getPublishedElement() {
        DateTime dt = (DateTime)this.getExtension(RssConstants.QNAME_PUBDATE);
        if (dt == null) {
            dt = (DateTime)this.getExtension(RssConstants.QNAME_PUBDATE2);
        }
        if (dt == null) {
            dt = (DateTime)this.getExtension(RssConstants.QNAME_DC_DATE);
        }
        return dt;
    }

    public String getRights() {
        Text text = this.getRightsElement();
        return text != null ? text.getValue() : null;
    }

    public Text getRightsElement() {
        Element el = (Element)this.getParentElement();
        if (el instanceof RssChannel) {
            return ((RssChannel)el).getRightsElement();
        }
        if (el instanceof RssFeed) {
            return ((RssFeed)el).getRightsElement();
        }
        Text text = (Text)this.getExtension(RssConstants.QNAME_DC_RIGHTS);
        return text;
    }

    public Text.Type getRightsType() {
        Text text = this.getRightsElement();
        return text != null ? text.getTextType() : null;
    }

    public Link getSelfLink() {
        return this.getLink("self");
    }

    public IRI getSelfLinkResolvedHref() {
        Link link = this.getSelfLink();
        return link != null ? link.getResolvedHref() : null;
    }

    public Source getSource() {
        Source source = (Source)this.getExtension(RssConstants.QNAME_SOURCE);
        if (source == null) {
            this.getExtension(RssConstants.QNAME_DC_SOURCE);
        }
        return source;
    }

    public String getSummary() {
        Text text = this.getSummaryElement();
        return text != null ? text.getValue() : null;
    }

    public Text getSummaryElement() {
        Text text = (Text)this.getExtension(RssConstants.QNAME_DESCRIPTION);
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_RDF_DESCRIPTION);
        }
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_DC_DESCRIPTION);
        }
        return text;
    }

    public Text.Type getSummaryType() {
        Text text = this.getSummaryElement();
        return text != null ? text.getTextType() : null;
    }

    public String getTitle() {
        Text text = this.getTitleElement();
        return text != null ? text.getValue() : null;
    }

    public Text getTitleElement() {
        Text text = (Text)this.getExtension(RssConstants.QNAME_TITLE);
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_RDF_TITLE);
        }
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_DC_TITLE);
        }
        return text;
    }

    public Text.Type getTitleType() {
        Text text = this.getTitleElement();
        return text != null ? text.getTextType() : null;
    }

    public Date getUpdated() {
        return this.getPublished();
    }

    public DateTime getUpdatedElement() {
        return this.getPublishedElement();
    }

    public boolean isDraft() {
        return false;
    }

    public IRIElement newId() {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(String value, Content.Type type) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(Element value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(Element element, String mediaType) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(DataHandler dataHandler) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(DataHandler dataHandler, String mediatype) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(InputStream inputStream) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(InputStream inputStream, String mediatype) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(String value, String mediatype) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContent(IRI uri, String mediatype) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContentAsHtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Content setContentAsXhtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setContentElement(Content content) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setControl(Control control) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setDraft(boolean draft) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public DateTime setEdited(Date value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public DateTime setEdited(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setEditedElement(DateTime modified) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public IRIElement setId(String id) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public IRIElement setId(String id, boolean normalize) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setIdElement(IRIElement id) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public DateTime setPublished(Date value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public DateTime setPublished(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setPublishedElement(DateTime dateTime) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRights(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRights(String value, Text.Type type) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRights(Div value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRightsAsHtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRightsAsXhtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setRightsElement(Text text) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setSource(Source source) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSummary(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSummary(String value, Text.Type type) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSummary(Div value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSummaryAsHtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSummaryAsXhtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setSummaryElement(Text text) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitle(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitle(String value, Text.Type type) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitle(Div value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitleAsHtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitleAsXhtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setTitleElement(Text title) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public DateTime setUpdated(Date value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public DateTime setUpdated(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry setUpdatedElement(DateTime updated) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link getComments() {
        return (Link)this.getExtension(RssConstants.QNAME_COMMENTS);
    }

    public IRI getResolvedValue() {
        return this.getValue();
    }

    public IRI getValue() {
        String about = this.getAttributeValue(RssConstants.QNAME_RDF_ABOUT);
        return about != null ? new IRI(about) : null;
    }

    public IRIElement setNormalizedValue(String iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public IRIElement setValue(String iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Control addControl() {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }
}

