/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.contrib.rss;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.contrib.rss.RssChannel;
import org.apache.abdera.contrib.rss.RssConstants;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.DateTime;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Generator;
import org.apache.abdera.model.IRIElement;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Source;
import org.apache.abdera.model.Text;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssFeed
extends ExtensibleElementWrapper
implements Feed {
    public RssFeed(Element internal) {
        super(internal);
    }

    public RssFeed(Factory factory, QName qname) {
        super(factory, qname);
    }

    private RssChannel getChannel() {
        RssChannel c = (RssChannel)super.getExtension(RssConstants.QNAME_CHANNEL);
        if (c == null) {
            c = (RssChannel)super.getExtension(RssConstants.QNAME_RDF_CHANNEL);
        }
        return c;
    }

    public Feed addEntry(Entry entry) {
        this.getChannel().addEntry(entry);
        return this;
    }

    public Entry addEntry() {
        return this.getChannel().addEntry();
    }

    public Source getAsSource() {
        throw new UnsupportedOperationException("Converting to source is not supported");
    }

    public List<Entry> getEntries() {
        return this.getChannel().getEntries();
    }

    public Entry getEntry(String id) {
        return this.getChannel().getEntry(id);
    }

    public Feed insertEntry(Entry entry) {
        this.getChannel().insertEntry(entry);
        return this;
    }

    public Entry insertEntry() {
        return this.getChannel().insertEntry();
    }

    public Feed sortEntries(Comparator<Entry> comparator) {
        this.getChannel().sortEntries(comparator);
        return this;
    }

    public Feed sortEntriesByEdited(boolean new_first) {
        this.getChannel().sortEntriesByEdited(new_first);
        return this;
    }

    public Feed sortEntriesByUpdated(boolean new_first) {
        this.getChannel().sortEntriesByUpdated(new_first);
        return this;
    }

    public <T extends Source> T addAuthor(Person person) {
        this.getChannel().addAuthor(person);
        return (T)((Object)this);
    }

    public Person addAuthor(String name) {
        return this.getChannel().addAuthor(name);
    }

    public Person addAuthor(String name, String email, String iri) {
        return this.getChannel().addAuthor(name, email, iri);
    }

    public <T extends Source> T addCategory(Category category) {
        this.getChannel().addCategory(category);
        return (T)((Object)this);
    }

    public Category addCategory(String term) {
        return this.getChannel().addCategory(term);
    }

    public Category addCategory(String scheme, String term, String label) {
        return this.getChannel().addCategory(scheme, term, label);
    }

    public <T extends Source> T addContributor(Person person) {
        throw new UnsupportedOperationException("Contributor's are not supported");
    }

    public Person addContributor(String name) {
        throw new UnsupportedOperationException("Contributor's are not supported");
    }

    public Person addContributor(String name, String email, String iri) {
        throw new UnsupportedOperationException("Contributor's are not supported");
    }

    public <T extends Source> T addLink(Link link) {
        this.getChannel().addLink(link);
        return (T)((Object)this);
    }

    public Link addLink(String href) {
        return this.getChannel().addLink(href);
    }

    public Link addLink(String href, String rel) {
        return this.getChannel().addLink(href, rel);
    }

    public Link addLink(String href, String rel, String type, String title, String hreflang, long length) {
        return this.getChannel().addLink(href, rel, type, title, hreflang, length);
    }

    public Link getAlternateLink() {
        return this.getChannel().getAlternateLink();
    }

    public Link getAlternateLink(String type, String hreflang) {
        return this.getChannel().getAlternateLink(type, hreflang);
    }

    public IRI getAlternateLinkResolvedHref() {
        return this.getChannel().getAlternateLinkResolvedHref();
    }

    public IRI getAlternateLinkResolvedHref(String type, String hreflang) {
        return this.getChannel().getAlternateLinkResolvedHref(type, hreflang);
    }

    public Person getAuthor() {
        return this.getChannel().getAuthor();
    }

    public List<Person> getAuthors() {
        return this.getChannel().getAuthors();
    }

    public List<Category> getCategories() {
        return this.getChannel().getCategories();
    }

    public List<Category> getCategories(String scheme) {
        return this.getChannel().getCategories(scheme);
    }

    public Collection getCollection() {
        return null;
    }

    public List<Person> getContributors() {
        return this.getChannel().getContributors();
    }

    public Generator getGenerator() {
        return this.getChannel().getGenerator();
    }

    public IRI getIcon() {
        return this.getChannel().getIcon();
    }

    public IRIElement getIconElement() {
        return this.getChannel().getIconElement();
    }

    public IRI getId() {
        return this.getChannel().getId();
    }

    public IRIElement getIdElement() {
        return this.getChannel().getIdElement();
    }

    public Link getLink(String rel) {
        return this.getChannel().getLink(rel);
    }

    public IRI getLinkResolvedHref(String rel) {
        return this.getChannel().getLinkResolvedHref(rel);
    }

    public List<Link> getLinks() {
        return this.getChannel().getLinks();
    }

    public List<Link> getLinks(String rel) {
        return this.getChannel().getLinks(rel);
    }

    public List<Link> getLinks(String ... rel) {
        return this.getChannel().getLinks(rel);
    }

    public IRI getLogo() {
        return this.getChannel().getLogo();
    }

    public IRIElement getLogoElement() {
        return this.getChannel().getLogoElement();
    }

    public String getRights() {
        return this.getChannel().getRights();
    }

    public Text getRightsElement() {
        return this.getChannel().getRightsElement();
    }

    public Text.Type getRightsType() {
        return this.getChannel().getRightsType();
    }

    public Link getSelfLink() {
        return this.getChannel().getSelfLink();
    }

    public IRI getSelfLinkResolvedHref() {
        return this.getChannel().getSelfLinkResolvedHref();
    }

    public String getSubtitle() {
        return this.getChannel().getSubtitle();
    }

    public Text getSubtitleElement() {
        return this.getChannel().getSubtitleElement();
    }

    public Text.Type getSubtitleType() {
        return this.getChannel().getSubtitleType();
    }

    public String getTitle() {
        return this.getChannel().getTitle();
    }

    public Text getTitleElement() {
        return this.getChannel().getTitleElement();
    }

    public Text.Type getTitleType() {
        return this.getChannel().getTitleType();
    }

    public Date getUpdated() {
        return this.getChannel().getUpdated();
    }

    public DateTime getUpdatedElement() {
        return this.getChannel().getUpdatedElement();
    }

    public String getUpdatedString() {
        return this.getChannel().getUpdatedString();
    }

    public Date getPublished() {
        return this.getChannel().getPublished();
    }

    public DateTime getPublisheddElement() {
        return this.getChannel().getPublishedElement();
    }

    public String getPublishedString() {
        return this.getChannel().getPublishedString();
    }

    public IRIElement newId() {
        return this.getChannel().newId();
    }

    public <T extends Source> T setCollection(Collection collection) {
        throw new UnsupportedOperationException("Collection is not supported");
    }

    public <T extends Source> T setGenerator(Generator generator) {
        this.getChannel().setGenerator(generator);
        return (T)((Object)this);
    }

    public Generator setGenerator(String iri, String version, String value) {
        return this.getChannel().setGenerator(iri, version, value);
    }

    public IRIElement setIcon(String iri) {
        return this.getChannel().setIcon(iri);
    }

    public <T extends Source> T setIconElement(IRIElement iri) {
        this.getChannel().setIconElement(iri);
        return (T)((Object)this);
    }

    public IRIElement setId(String id) {
        return this.getChannel().setId(id);
    }

    public IRIElement setId(String id, boolean normalize) {
        return this.getChannel().setId(id, normalize);
    }

    public <T extends Source> T setIdElement(IRIElement id) {
        this.getChannel().setIdElement(id);
        return (T)((Object)this);
    }

    public IRIElement setLogo(String iri) {
        return this.getChannel().setLogo(iri);
    }

    public <T extends Source> T setLogoElement(IRIElement iri) {
        this.getChannel().setLogoElement(iri);
        return (T)((Object)this);
    }

    public Text setRights(String value) {
        return this.getChannel().setRights(value);
    }

    public Text setRights(String value, Text.Type type) {
        return this.getChannel().setRights(value, type);
    }

    public Text setRights(Div value) {
        return this.getChannel().setRights(value);
    }

    public Text setRightsAsHtml(String value) {
        return this.getChannel().setRightsAsHtml(value);
    }

    public Text setRightsAsXhtml(String value) {
        return this.getChannel().setRightsAsXhtml(value);
    }

    public <T extends Source> T setRightsElement(Text text) {
        this.getChannel().setRightsElement(text);
        return (T)((Object)this);
    }

    public Text setSubtitle(String value) {
        return this.getChannel().setSubtitle(value);
    }

    public Text setSubtitle(String value, Text.Type type) {
        return this.getChannel().setSubtitle(value, type);
    }

    public Text setSubtitle(Div value) {
        return this.getChannel().setSubtitle(value);
    }

    public Text setSubtitleAsHtml(String value) {
        return this.getChannel().setSubtitleAsHtml(value);
    }

    public Text setSubtitleAsXhtml(String value) {
        return this.getChannel().setSubtitleAsXhtml(value);
    }

    public <T extends Source> T setSubtitleElement(Text text) {
        this.getChannel().setSubtitleElement(text);
        return (T)((Object)this);
    }

    public Text setTitle(String value) {
        return this.getChannel().setTitle(value);
    }

    public Text setTitle(String value, Text.Type type) {
        return this.getChannel().setTitle(value, type);
    }

    public Text setTitle(Div value) {
        return this.getChannel().setTitle(value);
    }

    public Text setTitleAsHtml(String value) {
        return this.getChannel().setTitleAsHtml(value);
    }

    public Text setTitleAsXhtml(String value) {
        return this.getChannel().setTitleAsXhtml(value);
    }

    public <T extends Source> T setTitleElement(Text text) {
        this.getChannel().setTitleElement(text);
        return (T)((Object)this);
    }

    public DateTime setUpdated(Date value) {
        return this.getChannel().setUpdated(value);
    }

    public DateTime setUpdated(String value) {
        return this.getChannel().setUpdated(value);
    }

    public <T extends Source> T setUpdatedElement(DateTime dateTime) {
        this.getChannel().setUpdatedElement(dateTime);
        return (T)((Object)this);
    }

    public <T extends ExtensibleElement> T addExtension(Element extension) {
        this.getChannel().addExtension(extension);
        return (T)((Object)this);
    }

    public <T extends Element> T addExtension(QName qname) {
        return (T)this.getChannel().addExtension(qname);
    }

    public <T extends Element> T addExtension(String namespace, String localPart, String prefix) {
        return (T)this.getChannel().addExtension(namespace, localPart, prefix);
    }

    public Element addSimpleExtension(QName qname, String value) {
        return this.getChannel().addSimpleExtension(qname, value);
    }

    public Element addSimpleExtension(String namespace, String localPart, String prefix, String value) {
        return this.getChannel().addSimpleExtension(namespace, localPart, prefix, value);
    }

    public <T extends Element> T getExtension(QName qname) {
        return (T)this.getChannel().getExtension(qname);
    }

    public <T extends Element> T getExtension(Class<T> _class) {
        return (T)this.getChannel().getExtension(_class);
    }

    public List<Element> getExtensions() {
        return this.getChannel().getExtensions();
    }

    public List<Element> getExtensions(String uri) {
        return this.getChannel().getExtensions(uri);
    }

    public <T extends Element> List<T> getExtensions(QName qname) {
        return this.getChannel().getExtensions(qname);
    }

    public String getSimpleExtension(QName qname) {
        return this.getChannel().getSimpleExtension(qname);
    }

    public String getSimpleExtension(String namespace, String localPart, String prefix) {
        return this.getChannel().getSimpleExtension(namespace, localPart, prefix);
    }

    public String getAttributeValue(String name) {
        return this.getChannel().getAttributeValue(name);
    }

    public String getAttributeValue(QName qname) {
        return this.getChannel().getAttributeValue(qname);
    }

    public List<QName> getAttributes() {
        return this.getChannel().getAttributes();
    }

    public List<QName> getExtensionAttributes() {
        return this.getChannel().getExtensionAttributes();
    }

    public String getLanguage() {
        return this.getChannel().getLanguage();
    }

    public <T extends Element> T removeAttribute(QName qname) {
        this.getChannel().removeAttribute(qname);
        return (T)((Object)this);
    }

    public <T extends Element> T setAttributeValue(String name, String value) {
        this.getChannel().setAttributeValue(name, value);
        return (T)((Object)this);
    }

    public <T extends Element> T setAttributeValue(QName qname, String value) {
        this.getChannel().setAttributeValue(qname, value);
        return (T)((Object)this);
    }

    public <T extends Element> T setBaseUri(IRI base) {
        return (T)((Object)this);
    }

    public <T extends Element> T setBaseUri(String base) {
        return (T)((Object)this);
    }

    public <T extends Element> T setLanguage(String language) {
        this.getChannel().setLanguage(language);
        return (T)((Object)this);
    }

    public String getVersion() {
        return super.getAttributeValue("version");
    }

    public Feed getAsFeed() {
        throw new UnsupportedOperationException("Converting to feed is not supported");
    }
}

