/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.provider.managed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.provider.managed.CollectionAdapterManager;
import org.apache.abdera.protocol.server.provider.managed.FeedConfiguration;
import org.apache.abdera.protocol.server.provider.managed.ManagedProvider;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedWorkspace
implements WorkspaceInfo {
    private final ManagedProvider provider;
    private String title = "Abdera";

    public ManagedWorkspace(ManagedProvider provider) {
        this.provider = provider;
    }

    @Override
    public Collection<CollectionInfo> getCollections(RequestContext request) {
        CollectionAdapterManager cam = this.provider.getCollectionAdapterManager(request);
        ArrayList<CollectionInfo> collections = new ArrayList<CollectionInfo>();
        try {
            Map<String, FeedConfiguration> map = cam.listAdapters();
            for (FeedConfiguration config : map.values()) {
                collections.add(config);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return collections;
    }

    @Override
    public String getTitle(RequestContext request) {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Workspace asWorkspaceElement(RequestContext request) {
        Workspace workspace = request.getAbdera().getFactory().newWorkspace();
        workspace.setTitle(this.getTitle(null));
        for (CollectionInfo collection : this.getCollections(request)) {
            workspace.addCollection(collection.asCollectionElement(request));
        }
        return workspace;
    }
}

