/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.provider.managed;

import java.util.Map;
import java.util.Properties;
import org.apache.abdera.model.Collection;
import org.apache.abdera.protocol.server.CategoriesInfo;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.provider.managed.CollectionAdapterConfiguration;
import org.apache.abdera.protocol.server.provider.managed.Configuration;
import org.apache.abdera.protocol.server.provider.managed.ServerConfiguration;

public class FeedConfiguration
extends Configuration
implements CollectionInfo {
    public static final String PROP_NAME_ADAPTER_CLASS = "adapterClassName";
    public static final String PROP_SUB_URI_NAME = "subUri";
    public static final String PROP_AUTHOR_NAME = "author";
    public static final String PROP_TITLE_NAME = "title";
    public static final String PROP_ACCEPTS = "accepts";
    public static final String PROP_ENTRY_TITLE_NAME = "entryTitle";
    public static final String PROP_FEED_CONFIG_LOCATION_NAME = "configFile";
    public static final String ENTRY_ELEM_NAME_ID = "id";
    public static final String ENTRY_ELEM_NAME_TITLE = "title";
    public static final String ENTRY_ELEM_NAME_CONTENT = "content";
    public static final String ENTRY_ELEM_NAME_AUTHOR = "author";
    public static final String ENTRY_ELEM_NAME_UPDATED = "updated";
    public static final String ENTRY_ELEM_NAME_LINK = "link";
    private final String feedId;
    private final String subUri;
    private final String adapterClassName;
    private final String feedConfigLocation;
    private final ServerConfiguration serverConfiguration;
    private String feedTitle = "unknown";
    private String feedAuthor = "unknown";
    private Map<Object, Object> optionalProperties;
    private final CollectionAdapterConfiguration adapterConfiguration;

    public FeedConfiguration(String feedId, String subUri, String adapterClassName, String feedConfigLocation, ServerConfiguration serverConfiguration) {
        this.feedId = feedId;
        this.subUri = subUri;
        this.adapterClassName = adapterClassName;
        this.feedConfigLocation = feedConfigLocation;
        this.adapterConfiguration = new CollectionAdapterConfiguration(serverConfiguration, feedConfigLocation);
        this.serverConfiguration = serverConfiguration;
    }

    public static FeedConfiguration getFeedConfiguration(String feedId, Properties properties, ServerConfiguration serverConfiguration) {
        FeedConfiguration feedConfiguration = new FeedConfiguration(feedId, Configuration.getProperty(properties, PROP_SUB_URI_NAME), Configuration.getProperty(properties, PROP_NAME_ADAPTER_CLASS), Configuration.getProperty(properties, PROP_FEED_CONFIG_LOCATION_NAME), serverConfiguration);
        if (properties.containsKey("author")) {
            feedConfiguration.setFeedAuthor(Configuration.getProperty(properties, "author"));
        }
        if (properties.containsKey("title")) {
            feedConfiguration.setFeedTitle(Configuration.getProperty(properties, "title"));
        }
        feedConfiguration.optionalProperties = properties;
        return feedConfiguration;
    }

    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    public String getFeedAuthor() {
        return this.feedAuthor;
    }

    public String getFeedConfigLocation() {
        return this.feedConfigLocation;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getFeedTitle() {
        return this.feedTitle;
    }

    public String getSubUri() {
        return this.subUri;
    }

    public void setFeedAuthor(String feedAuthor) {
        this.feedAuthor = feedAuthor;
    }

    public void setFeedTitle(String feedTitle) {
        this.feedTitle = feedTitle;
    }

    public String getFeedUri() {
        return this.serverConfiguration.getServerUri() + "/" + this.getSubUri();
    }

    public boolean hasProperty(String key) {
        return this.optionalProperties.containsKey(key);
    }

    public Object getProperty(String key) {
        return this.optionalProperties.get(key);
    }

    public CollectionAdapterConfiguration getAdapterConfiguration() {
        return this.adapterConfiguration;
    }

    public Collection asCollectionElement(RequestContext request) {
        Collection collection = request.getAbdera().getFactory().newCollection();
        collection.setHref(this.getHref(request));
        collection.setTitle(this.getTitle(request));
        collection.setAccept(this.getAccepts(request));
        CategoriesInfo[] arr$ = this.getCategoriesInfo(request);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CategoriesInfo catsinfo = arr$[i$];
            collection.addCategories(catsinfo.asCategoriesElement(request));
        }
        return collection;
    }

    public String[] getAccepts(RequestContext request) {
        Object accepts = this.optionalProperties.get(PROP_ACCEPTS);
        if (accepts == null || !(accepts instanceof String)) {
            return new String[]{"application/atom+xml;type=entry"};
        }
        return ((String)accepts).split("\\s*,\\s*");
    }

    public CategoriesInfo[] getCategoriesInfo(RequestContext request) {
        return new CategoriesInfo[0];
    }

    public String getHref(RequestContext request) {
        return this.getFeedUri();
    }

    public String getTitle(RequestContext request) {
        return this.getFeedTitle();
    }

    public ServerConfiguration getServerConfiguration() {
        return this.adapterConfiguration.getServerConfiguration();
    }
}

