/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.provider.basic;

import java.util.Date;
import java.util.logging.Logger;
import javax.activation.MimeType;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.provider.managed.FeedConfiguration;
import org.apache.abdera.protocol.server.provider.managed.ManagedCollectionAdapter;
import org.apache.abdera.util.MimeTypeHelper;

public abstract class BasicAdapter
extends ManagedCollectionAdapter {
    public static Logger logger;
    private static final /* synthetic */ Class class$org$apache$abdera$protocol$server$provider$basic$BasicAdapter;

    protected BasicAdapter(Abdera abdera, FeedConfiguration config) {
        super(abdera, config);
    }

    public String getProperty(String key) throws Exception {
        Object val = this.config.getProperty(key);
        if (val == null) {
            logger.warning("Cannot find property " + key + "in Adapter properties file for feed " + this.config.getFeedId());
            throw new RuntimeException();
        }
        if (val instanceof String) {
            return (String)val;
        }
        throw new RuntimeException();
    }

    protected Feed createFeed() throws Exception {
        Feed feed = this.abdera.newFeed();
        feed.setId(this.config.getFeedUri());
        feed.setTitle(this.config.getFeedTitle());
        feed.setUpdated(new Date());
        feed.addAuthor(this.config.getFeedAuthor());
        return feed;
    }

    protected void addEditLinkToEntry(Entry entry) throws Exception {
        if (ProviderHelper.getEditUriFromEntry(entry) == null) {
            entry.addLink(entry.getId().toString(), "edit");
        }
    }

    protected void setEntryIdIfNull(Entry entry) throws Exception {
        if (entry.getId() != null) {
            return;
        }
        String uuidUri = this.abdera.getFactory().newUuidUri();
        String[] segments = uuidUri.split(":");
        String entryId = segments[segments.length - 1];
        entry.setId(this.createEntryIdUri(entryId));
    }

    protected String createEntryIdUri(String entryId) throws Exception {
        return this.config.getFeedUri() + "/" + entryId;
    }

    private ResponseContext createOrUpdateEntry(RequestContext request, boolean createFlag) {
        try {
            Entry newEntry;
            String contentType;
            MimeType mimeType = request.getContentType();
            String string = contentType = mimeType == null ? null : mimeType.toString();
            if (contentType != null && !MimeTypeHelper.isAtom((String)contentType) && !MimeTypeHelper.isXml((String)contentType)) {
                return ProviderHelper.notsupported(request);
            }
            Abdera abdera = request.getAbdera();
            Parser parser = abdera.getParser();
            Entry inputEntry = (Entry)request.getDocument(parser).getRoot();
            Target target = request.getTarget();
            String entryId = !createFlag ? target.getParameter("entry") : null;
            Entry entry = newEntry = createFlag ? this.createEntry(inputEntry) : this.updateEntry(entryId, inputEntry);
            if (newEntry != null) {
                Document newEntryDoc = newEntry.getDocument();
                String loc = newEntry.getEditLinkResolvedHref().toString();
                return ProviderHelper.returnBase((Base)newEntryDoc, createFlag ? 201 : 200, null).setLocation(loc);
            }
            return ProviderHelper.notfound(request);
        }
        catch (Exception e) {
            return ProviderHelper.servererror(request, e.getMessage(), e);
        }
    }

    public ResponseContext postEntry(RequestContext request) {
        return this.createOrUpdateEntry(request, true);
    }

    public ResponseContext deleteEntry(RequestContext request) {
        Target target = request.getTarget();
        String entryId = target.getParameter("entry");
        try {
            return this.deleteEntry(entryId) ? ProviderHelper.nocontent() : ProviderHelper.notfound(request);
        }
        catch (Exception e) {
            return ProviderHelper.servererror(request, e.getMessage(), e);
        }
    }

    public ResponseContext putEntry(RequestContext request) {
        return this.createOrUpdateEntry(request, false);
    }

    public ResponseContext getEntry(RequestContext request) {
        Target target = request.getTarget();
        String entryId = target.getParameter("entry");
        try {
            Entry entry = this.getEntry(entryId);
            return entry != null ? ProviderHelper.returnBase((Base)entry.getDocument(), 200, null) : ProviderHelper.notfound(request);
        }
        catch (Exception e) {
            return ProviderHelper.servererror(request, e.getMessage(), e);
        }
    }

    public ResponseContext getFeed(RequestContext request) {
        try {
            Feed feed = this.getFeed();
            return feed != null ? ProviderHelper.returnBase((Base)feed.getDocument(), 200, null) : ProviderHelper.notfound(request);
        }
        catch (Exception e) {
            return ProviderHelper.servererror(request, e.getMessage(), e);
        }
    }

    public ResponseContext extensionRequest(RequestContext request) {
        return ProviderHelper.notallowed(request, ProviderHelper.getDefaultMethods(request));
    }

    public ResponseContext getCategories(RequestContext request) {
        return ProviderHelper.notfound(request);
    }

    public abstract Feed getFeed() throws Exception;

    public abstract Entry getEntry(Object var1) throws Exception;

    public abstract Entry createEntry(Entry var1) throws Exception;

    public abstract Entry updateEntry(Object var1, Entry var2) throws Exception;

    public abstract boolean deleteEntry(Object var1) throws Exception;

    static {
        Class<?> clazz = class$org$apache$abdera$protocol$server$provider$basic$BasicAdapter;
        if (clazz == null) {
            clazz = class$org$apache$abdera$protocol$server$provider$basic$BasicAdapter = new BasicAdapter[0].getClass().getComponentType();
        }
        logger = Logger.getLogger(clazz.getName());
    }
}

