/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import org.apache.abdera.i18n.templates.Context;
import org.apache.abdera.i18n.templates.DelegatingContext;
import org.apache.abdera.i18n.templates.HashMapContext;
import org.apache.abdera.i18n.templates.ObjectContext;
import org.apache.abdera.i18n.templates.Template;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateTargetBuilder
implements TargetBuilder {
    protected final Map<Object, Template> templates = new HashMap<Object, Template>();

    public TemplateTargetBuilder() {
    }

    public TemplateTargetBuilder(Map<Object, Template> templates) {
        for (Map.Entry<Object, Template> entry : templates.entrySet()) {
            this.setTemplate(entry.getKey(), entry.getValue());
        }
    }

    public TemplateTargetBuilder setTemplate(Object key, String template) {
        return this.setTemplate(key, new Template(template));
    }

    public TemplateTargetBuilder setTemplate(Object key, Template template) {
        template = new Template(this.doReplacements(template.getPattern()));
        this.templates.put(key, template);
        return this;
    }

    private String doReplacements(String template) {
        for (Variable var : Variable.values()) {
            String rep = var.getReplacement();
            if (rep == null) continue;
            template = template.replaceAll(new StringBuffer().append("\\Q{").append(var.name().toLowerCase()).append("}\\E").toString(), rep);
        }
        return template;
    }

    public static Context getContext(RequestContext request, Object param) {
        Object context = null;
        if (param != null) {
            context = param instanceof Map ? new HashMapContext((Map)param, true) : (param instanceof Context ? (Context)param : new ObjectContext(param, true));
        }
        return new TemplateContext(request, (Context)context);
    }

    public static <T> List<T> asList(Iterator<T> i) {
        ArrayList<T> list = new ArrayList<T>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    @Override
    public String urlFor(RequestContext request, Object key, Object param) {
        Template template = this.templates.get(key);
        return template != null ? template.expand(TemplateTargetBuilder.getContext(request, param)) : null;
    }

    private static String toVar(Variable variable, String label) {
        return new StringBuffer().append(variable.name().toLowerCase()).append("_").append(label).toString();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Variable
    extends Enum<Variable> {
        public static final /* enum */ Variable REQUEST_CONTEXT_PATH = new Variable("REQUEST_CONTEXT_PATH", 0, "{-opt|/|request_context_path}{-listjoin|/|request_context_path}");
        public static final /* enum */ Variable REQUEST_CONTENT_TYPE = new Variable("REQUEST_CONTENT_TYPE", 1);
        public static final /* enum */ Variable REQUEST_URI = new Variable("REQUEST_URI", 2);
        public static final /* enum */ Variable REQUEST_RESOLVED_URI = new Variable("REQUEST_RESOLVED_URI", 3);
        public static final /* enum */ Variable REQUEST_PARAMETER = new Variable("REQUEST_PARAMETER", 4);
        public static final /* enum */ Variable REQUEST_LANGUAGE = new Variable("REQUEST_LANGUAGE", 5);
        public static final /* enum */ Variable REQUEST_CHARSET = new Variable("REQUEST_CHARSET", 6);
        public static final /* enum */ Variable REQUEST_USER = new Variable("REQUEST_USER", 7);
        public static final /* enum */ Variable SESSION_ATTRIBUTE = new Variable("SESSION_ATTRIBUTE", 8);
        public static final /* enum */ Variable REQUEST_ATTRIBUTE = new Variable("REQUEST_ATTRIBUTE", 9);
        public static final /* enum */ Variable REQUEST_HEADER = new Variable("REQUEST_HEADER", 10);
        public static final /* enum */ Variable TARGET_PARAMETER = new Variable("TARGET_PARAMETER", 11);
        public static final /* enum */ Variable TARGET_IDENTITY = new Variable("TARGET_IDENTITY", 12);
        public static final /* enum */ Variable TARGET_PATH = new Variable("TARGET_PATH", 13, "{-opt|/|target_path}{-listjoin|/|target_path}");
        public static final /* enum */ Variable TARGET_BASE = new Variable("TARGET_BASE", 14, "{-opt|/|target_base}{-listjoin|/|target_base}");
        private final Pattern p = Pattern.compile(new StringBuffer().append("\\Q").append(this.name()).append("_\\E.*").toString(), 2);
        private final String replacement;
        private static final /* synthetic */ Variable[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$protocol$server$impl$TemplateTargetBuilder$Variable;

        public static final Variable[] values() {
            return (Variable[])$VALUES.clone();
        }

        public static Variable valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$protocol$server$impl$TemplateTargetBuilder$Variable;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$server$impl$TemplateTargetBuilder$Variable = new Variable[0].getClass().getComponentType();
            }
            return (Variable)Enum.valueOf((Class)clazz, (String)name);
        }

        static Variable get(String var) {
            if (REQUEST_PARAMETER.match(var)) {
                return REQUEST_PARAMETER;
            }
            if (SESSION_ATTRIBUTE.match(var)) {
                return SESSION_ATTRIBUTE;
            }
            if (REQUEST_ATTRIBUTE.match(var)) {
                return REQUEST_ATTRIBUTE;
            }
            if (REQUEST_HEADER.match(var)) {
                return REQUEST_HEADER;
            }
            if (TARGET_PARAMETER.match(var)) {
                return TARGET_PARAMETER;
            }
            try {
                return Variable.valueOf(var.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Variable(String string, int n) {
            this(string, n, null);
        }

        private Variable(String string, int n, String replacement) {
            super(string, n);
            this.replacement = replacement;
        }

        String getReplacement() {
            return this.replacement;
        }

        boolean match(String var) {
            return this.p.matcher(var).matches();
        }

        String label(String var) {
            return var.substring(this.name().length() + 1);
        }

        static {
            $VALUES = new Variable[]{REQUEST_CONTEXT_PATH, REQUEST_CONTENT_TYPE, REQUEST_URI, REQUEST_RESOLVED_URI, REQUEST_PARAMETER, REQUEST_LANGUAGE, REQUEST_CHARSET, REQUEST_USER, SESSION_ATTRIBUTE, REQUEST_ATTRIBUTE, REQUEST_HEADER, TARGET_PARAMETER, TARGET_IDENTITY, TARGET_PATH, TARGET_BASE};
            Variable[] variableArray = Variable.values();
            Class<?> clazz = class$org$apache$abdera$protocol$server$impl$TemplateTargetBuilder$Variable;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$server$impl$TemplateTargetBuilder$Variable = new Variable[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])variableArray, (Class)clazz);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateContext
    extends DelegatingContext {
        private static final long serialVersionUID = 4332356546022014897L;
        private final RequestContext request;

        public TemplateContext(RequestContext request, Context subcontext) {
            super(subcontext);
            this.request = request;
        }

        private String[] split(String val) {
            if (val.equals("")) {
                return null;
            }
            String[] segments = val.split("/");
            return segments.length > 0 ? segments : null;
        }

        protected <T> T resolveActual(String var) {
            Variable variable = Variable.get(var);
            if (variable == null) {
                return (T)(this.subcontext != null ? this.subcontext.resolve(var) : null);
            }
            switch (variable) {
                case REQUEST_URI: {
                    return (T)this.request.getUri().toString();
                }
                case REQUEST_RESOLVED_URI: {
                    return (T)this.request.getResolvedUri().toString();
                }
                case REQUEST_CONTENT_TYPE: {
                    return (T)this.request.getContentType().toString();
                }
                case REQUEST_CONTEXT_PATH: {
                    return (T)this.split(this.request.getContextPath());
                }
                case REQUEST_PARAMETER: {
                    String name = Variable.REQUEST_PARAMETER.label(var);
                    return (T)this.request.getParameter(name);
                }
                case REQUEST_LANGUAGE: {
                    return (T)this.request.getAcceptLanguage();
                }
                case REQUEST_CHARSET: {
                    return (T)this.request.getAcceptCharset();
                }
                case REQUEST_USER: {
                    Principal p = this.request.getPrincipal();
                    return (T)(p != null ? p.getName() : null);
                }
                case SESSION_ATTRIBUTE: {
                    String name = Variable.SESSION_ATTRIBUTE.label(var);
                    return (T)this.request.getAttribute(RequestContext.Scope.SESSION, name);
                }
                case REQUEST_ATTRIBUTE: {
                    String name = Variable.REQUEST_ATTRIBUTE.label(var);
                    return (T)this.request.getAttribute(RequestContext.Scope.REQUEST, name);
                }
                case REQUEST_HEADER: {
                    String name = Variable.REQUEST_HEADER.label(var);
                    return (T)this.request.getHeader(name);
                }
                case TARGET_PARAMETER: {
                    String name = Variable.TARGET_PARAMETER.label(var);
                    return (T)this.request.getTarget().getParameter(name);
                }
                case TARGET_IDENTITY: {
                    return (T)this.request.getTarget().getIdentity();
                }
                case TARGET_PATH: {
                    return (T)this.split(this.request.getTargetPath());
                }
                case TARGET_BASE: {
                    return (T)this.split(this.request.getTargetBasePath());
                }
            }
            return (T)(this.subcontext != null ? this.subcontext.resolve(var) : null);
        }

        public Iterator<String> iterator() {
            ArrayList<String> vars = new ArrayList<String>();
            for (String var : this.subcontext) {
                vars.add(var);
            }
            for (String var : this.request.getParameterNames()) {
                vars.add(TemplateTargetBuilder.toVar(Variable.REQUEST_PARAMETER, var));
            }
            for (String var : this.request.getAttributeNames(RequestContext.Scope.SESSION)) {
                vars.add(TemplateTargetBuilder.toVar(Variable.SESSION_ATTRIBUTE, var));
            }
            for (String var : this.request.getAttributeNames(RequestContext.Scope.REQUEST)) {
                vars.add(TemplateTargetBuilder.toVar(Variable.REQUEST_ATTRIBUTE, var));
            }
            for (String var : this.request.getHeaderNames()) {
                vars.add(TemplateTargetBuilder.toVar(Variable.REQUEST_HEADER, var));
            }
            Target target = this.request.getTarget();
            for (String var : target.getParameterNames()) {
                vars.add(TemplateTargetBuilder.toVar(Variable.TARGET_PARAMETER, var));
            }
            vars.add(Variable.REQUEST_CONTEXT_PATH.name().toLowerCase());
            vars.add(Variable.REQUEST_CONTENT_TYPE.name().toLowerCase());
            vars.add(Variable.REQUEST_URI.name().toLowerCase());
            vars.add(Variable.REQUEST_RESOLVED_URI.name().toLowerCase());
            vars.add(Variable.REQUEST_LANGUAGE.name().toLowerCase());
            vars.add(Variable.REQUEST_CHARSET.name().toLowerCase());
            vars.add(Variable.REQUEST_USER.name().toLowerCase());
            vars.add(Variable.TARGET_IDENTITY.name().toLowerCase());
            vars.add(Variable.TARGET_PATH.name().toLowerCase());
            vars.add(Variable.TARGET_BASE.name().toLowerCase());
            return vars.iterator();
        }
    }
}

