/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.WorkspaceInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWorkspaceInfo
implements WorkspaceInfo,
Serializable {
    private static final long serialVersionUID = -8459688584319762878L;
    protected String title;
    protected Set<CollectionInfo> collections;

    public SimpleWorkspaceInfo() {
    }

    public SimpleWorkspaceInfo(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle(RequestContext request) {
        return this.title;
    }

    public void addCollection(CollectionInfo ci) {
        this.getCollections().add(ci);
    }

    @Override
    public Collection<CollectionInfo> getCollections(RequestContext request) {
        return this.collections;
    }

    public Set<CollectionInfo> getCollections() {
        if (this.collections == null) {
            this.collections = new HashSet<CollectionInfo>();
        }
        return this.collections;
    }

    public void setCollections(Set<CollectionInfo> collections) {
        this.collections = collections;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collections == null ? 0 : ((Object)this.collections).hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleWorkspaceInfo other = (SimpleWorkspaceInfo)obj;
        if (this.collections == null ? other.collections != null : !((Object)this.collections).equals(other.collections)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    @Override
    public Workspace asWorkspaceElement(RequestContext request) {
        Workspace workspace = request.getAbdera().getFactory().newWorkspace();
        workspace.setTitle(this.title);
        for (CollectionInfo collection : this.collections) {
            workspace.addCollection(collection.asCollectionElement(request));
        }
        return workspace;
    }
}

