/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.abdera.i18n.templates.CachingContext;
import org.apache.abdera.i18n.templates.Context;
import org.apache.abdera.i18n.templates.HashMapContext;
import org.apache.abdera.i18n.templates.ObjectContext;
import org.apache.abdera.i18n.templates.Route;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.impl.SimpleTarget;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RouteManager
implements Resolver<Target>,
TargetBuilder {
    protected Map<Route, TargetType> targets = new HashMap<Route, TargetType>();
    protected Map<String, Route> routes = new HashMap<String, Route>();
    protected Map<Route, CollectionAdapter> route2CA = new HashMap<Route, CollectionAdapter>();

    public RouteManager addRoute(Route route) {
        return this.addRoute(route, null);
    }

    public RouteManager addRoute(String name, String pattern) {
        return this.addRoute(name, pattern, null);
    }

    public RouteManager addRoute(Route route, TargetType type) {
        this.routes.put(route.getName(), route);
        if (type != null) {
            this.targets.put(route, type);
        }
        return this;
    }

    public RouteManager addRoute(String name, String pattern, TargetType type) {
        return this.addRoute(new Route(name, pattern), type);
    }

    public RouteManager addRoute(String name, String pattern, TargetType type, CollectionAdapter collectionAdapter) {
        Route route = new Route(name, pattern);
        this.route2CA.put(route, collectionAdapter);
        return this.addRoute(route, type);
    }

    public Target resolve(Request request) {
        RequestContext context = (RequestContext)request;
        String uri = context.getTargetPath();
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        for (Map.Entry<Route, TargetType> entry : this.targets.entrySet()) {
            if (!entry.getKey().match(uri)) continue;
            CollectionAdapter ca = this.route2CA.get(entry.getKey());
            if (ca != null) {
                context.setAttribute("collectionProvider", ca);
            }
            return this.getTarget(context, entry.getKey(), uri, entry.getValue());
        }
        return null;
    }

    private Target getTarget(RequestContext context, Route route, String uri, TargetType type) {
        return new RouteTarget(type, context, route, uri);
    }

    @Override
    public String urlFor(RequestContext context, Object key, Object param) {
        Route route = this.routes.get(key);
        if (route != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Context ctx = this.getContext(param);
            for (String var : ctx) {
                map.put(var, ctx.resolve(var));
            }
            for (String var : route.getVariables()) {
                String value = context.getTarget().getParameter(var);
                if (map.containsKey(var) || value == null) continue;
                map.put(var, value);
            }
            return new StringBuffer().append(context.getTargetBasePath()).append(route.expand(this.getContext(map))).toString();
        }
        return null;
    }

    private Context getContext(Object param) {
        Object context = null;
        context = param != null ? (param instanceof Map ? new HashMapContext((Map)param, true) : (param instanceof Context ? (Context)param : new ObjectContext(param, true))) : new EmptyContext();
        return context;
    }

    public Object resolve(Request x0) {
        return this.resolve(x0);
    }

    public static class RouteTarget
    extends SimpleTarget {
        private final Map<String, String> params;
        private final Route route;

        public RouteTarget(TargetType type, RequestContext context, Route route, String uri) {
            super(type, context);
            this.route = route;
            this.params = route.parse(uri);
        }

        public Route getRoute() {
            return this.route;
        }

        public String getParameter(String name) {
            return this.params.containsKey(name) ? this.params.get(name) : super.getParameter(name);
        }

        public String[] getParameterNames() {
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(super.getParameterNames()));
            Iterator<String> i$ = this.params.keySet().iterator();
            while (i$.hasNext()) {
                String name = i$.next();
                if (names.contains(name)) continue;
                names.add(name);
            }
            return names.toArray(new String[names.size()]);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyContext
    extends CachingContext {
        private static final long serialVersionUID = 4681906592987534451L;

        private EmptyContext() {
        }

        protected <T> T resolveActual(String var) {
            return null;
        }

        public Iterator<String> iterator() {
            List<String> list = Arrays.asList(new String[0]);
            return list.iterator();
        }
    }
}

