/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.protocol.server.CategoriesInfo;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.MediaCollectionAdapter;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Transactional;
import org.apache.abdera.protocol.server.context.BaseResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;
import org.apache.abdera.util.EntityTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCollectionAdapter
implements CollectionAdapter,
MediaCollectionAdapter,
Transactional,
CollectionInfo {
    private static final Log log;
    private String href;
    private Map<String, Object> hrefParams = new HashMap<String, Object>();
    private static final /* synthetic */ Class class$org$apache$abdera$protocol$server$impl$AbstractEntityCollectionAdapter;

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
        this.hrefParams.put("collection", href);
    }

    public String getHref(RequestContext request) {
        return request.urlFor("feed", this.hrefParams);
    }

    public void compensate(RequestContext request, Throwable t) {
    }

    public void end(RequestContext request, ResponseContext response) {
    }

    public void start(RequestContext request) throws ResponseContextException {
    }

    public String[] getAccepts(RequestContext request) {
        return new String[]{"application/atom+xml;type=entry"};
    }

    public CategoriesInfo[] getCategoriesInfo(RequestContext request) {
        return null;
    }

    public ResponseContext getCategories(RequestContext request) {
        return null;
    }

    public ResponseContext deleteMedia(RequestContext request) {
        return ProviderHelper.notsupported(request);
    }

    public ResponseContext getMedia(RequestContext request) {
        return ProviderHelper.notsupported(request);
    }

    public ResponseContext headMedia(RequestContext request) {
        return ProviderHelper.notsupported(request);
    }

    public ResponseContext optionsMedia(RequestContext request) {
        return ProviderHelper.notsupported(request);
    }

    public ResponseContext putMedia(RequestContext request) {
        return ProviderHelper.notsupported(request);
    }

    public ResponseContext postMedia(RequestContext request) {
        return ProviderHelper.notsupported(request);
    }

    public ResponseContext headEntry(RequestContext request) {
        return ProviderHelper.notsupported(request);
    }

    public ResponseContext optionsEntry(RequestContext request) {
        return ProviderHelper.notsupported(request);
    }

    public abstract String getAuthor(RequestContext var1) throws ResponseContextException;

    public abstract String getId(RequestContext var1);

    protected ResponseContext buildCreateEntryResponse(String link, Entry entry) {
        BaseResponseContext<Entry> rc = new BaseResponseContext<Entry>(entry);
        rc.setLocation(link);
        rc.setContentLocation(rc.getLocation().toString());
        rc.setEntityTag(ProviderHelper.calculateEntityTag((Base)entry));
        rc.setStatus(201);
        return rc;
    }

    protected ResponseContext buildPostMediaEntryResponse(String link, Entry entry) {
        return this.buildCreateEntryResponse(link, entry);
    }

    protected ResponseContext buildGetEntryResponse(RequestContext request, Entry entry) throws ResponseContextException {
        Feed feed = this.createFeedBase(request);
        entry.setSource(feed.getAsSource());
        Document entry_doc = entry.getDocument();
        BaseResponseContext<Document> rc = new BaseResponseContext<Document>(entry_doc);
        rc.setEntityTag(ProviderHelper.calculateEntityTag((Base)entry));
        return rc;
    }

    protected ResponseContext buildHeadEntryResponse(RequestContext request, String id, Date updated) throws ResponseContextException {
        EmptyResponseContext rc = new EmptyResponseContext(200);
        rc.setEntityTag(EntityTag.generate((String[])new String[]{id, AtomDate.format((Date)updated)}));
        return rc;
    }

    protected ResponseContext buildGetFeedResponse(Feed feed) {
        Document document = feed.getDocument();
        BaseResponseContext<Document> rc = new BaseResponseContext<Document>(document);
        rc.setEntityTag(ProviderHelper.calculateEntityTag((Base)document.getRoot()));
        return rc;
    }

    protected ResponseContext createErrorResponse(ResponseContextException e) {
        if (log.isInfoEnabled()) {
            log.info((Object)"A ResponseException was thrown.", (Throwable)e);
        } else if (e.getResponseContext() instanceof EmptyResponseContext && ((EmptyResponseContext)e.getResponseContext()).getStatus() >= 500) {
            log.warn((Object)"A ResponseException was thrown.", (Throwable)e);
        }
        return e.getResponseContext();
    }

    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addLink("");
        feed.addLink("", "self");
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(new Date());
        return feed;
    }

    protected Entry getEntryFromRequest(RequestContext request) throws ResponseContextException {
        Document entry_doc;
        Abdera abdera = request.getAbdera();
        Parser parser = abdera.getParser();
        try {
            entry_doc = (Document)request.getDocument(parser).clone();
        }
        catch (ParseException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        catch (IOException e) {
            throw new ResponseContextException(500, (Throwable)e);
        }
        if (entry_doc == null) {
            return null;
        }
        return (Entry)entry_doc.getRoot();
    }

    protected String getResourceName(RequestContext request) {
        String path = request.getTargetPath();
        int q = path.indexOf("?");
        if (q != -1) {
            path = path.substring(0, q);
        }
        String[] segments = path.split("/");
        String id = segments[segments.length - 1];
        return UrlEncoding.decode((String)id);
    }

    public ResponseContext extensionRequest(RequestContext request) {
        return ProviderHelper.notallowed(request, this.getMethods(request));
    }

    private String[] getMethods(RequestContext request) {
        return ProviderHelper.getDefaultMethods(request);
    }

    public Collection asCollectionElement(RequestContext request) {
        Collection collection = request.getAbdera().getFactory().newCollection();
        collection.setHref(this.getHref(request));
        collection.setTitle(this.getTitle(request));
        collection.setAccept(this.getAccepts(request));
        CategoriesInfo[] arr$ = this.getCategoriesInfo(request);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CategoriesInfo catsinfo = arr$[i$];
            collection.addCategories(catsinfo.asCategoriesElement(request));
        }
        return collection;
    }

    static {
        Class<?> clazz = class$org$apache$abdera$protocol$server$impl$AbstractEntityCollectionAdapter;
        if (clazz == null) {
            clazz = class$org$apache$abdera$protocol$server$impl$AbstractEntityCollectionAdapter = new AbstractEntityCollectionAdapter[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
    }
}

