/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.context;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.MimeType;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.protocol.server.context.AbstractResponseContext;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.abdera.util.MimeTypeParseException;
import org.apache.abdera.writer.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseResponseContext<T extends Base>
extends AbstractResponseContext {
    private final T base;
    private final boolean chunked;

    public BaseResponseContext(T base) {
        this(base, true);
    }

    public BaseResponseContext(T base, boolean chunked) {
        this.base = base;
        this.setStatus(200);
        this.setStatusText("OK");
        this.chunked = chunked;
        try {
            MimeType type = this.getContentType();
            String charset = type.getParameter("charset");
            if (charset == null) {
                charset = this.getCharsetFromBase((Base)base);
            }
            if (charset == null) {
                charset = "UTF-8";
            }
            type.setParameter("charset", charset);
            this.setContentType(type.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getCharsetFromBase(Base base) {
        if (base == null) {
            return null;
        }
        if (base instanceof Document) {
            return ((Document)base).getCharset();
        }
        if (base instanceof Element) {
            return this.getCharsetFromBase((Base)((Element)base).getDocument());
        }
        return null;
    }

    public T getBase() {
        return this.base;
    }

    @Override
    public boolean hasEntity() {
        return this.base != null;
    }

    @Override
    public void writeTo(java.io.Writer javaWriter) throws IOException {
        if (this.hasEntity()) {
            if (this.writer == null) {
                this.base.writeTo(javaWriter);
            } else {
                this.writeTo(javaWriter, this.writer);
            }
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.hasEntity()) {
            if (this.writer == null) {
                this.base.writeTo(out);
            } else {
                this.writeTo(out, this.writer);
            }
        }
    }

    public MimeType getContentType() {
        try {
            String type;
            MimeType t = super.getContentType();
            if (t == null && (type = MimeTypeHelper.getMimeType(this.base)) != null) {
                t = new MimeType(type);
            }
            return t;
        }
        catch (javax.activation.MimeTypeParseException e) {
            throw new MimeTypeParseException(e);
        }
    }

    public long getContentLength() {
        long len = super.getContentLength();
        if (this.hasEntity() && len == -1L && !this.chunked) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.base.writeTo((OutputStream)out);
                len = out.size();
                super.setContentLength(len);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return len;
    }

    @Override
    public void writeTo(OutputStream out, Writer writer) throws IOException {
        writer.writeTo(this.base, out);
    }

    @Override
    public void writeTo(java.io.Writer javaWriter, Writer abderaWriter) throws IOException {
        abderaWriter.writeTo(this.base, javaWriter);
    }
}

