/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.context;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.impl.SimpleTarget;
import org.apache.abdera.protocol.util.AbstractRequest;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestContext
extends AbstractRequest
implements RequestContext {
    private static final Log log;
    protected final Provider provider;
    protected Subject subject;
    protected Principal principal;
    protected Target target;
    protected final String method;
    protected final IRI requestUri;
    protected final IRI baseUri;
    protected Document<?> document;
    private static final /* synthetic */ Class class$org$apache$abdera$protocol$server$context$AbstractRequestContext;

    protected AbstractRequestContext(Provider provider, String method, IRI requestUri, IRI baseUri) {
        this.provider = provider;
        this.method = method;
        this.baseUri = baseUri;
        this.requestUri = requestUri;
    }

    protected Target initTarget() {
        try {
            Target target = this.provider.resolveTarget(this);
            return target != null ? target : new SimpleTarget(TargetType.TYPE_NOT_FOUND, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Abdera getAbdera() {
        return this.provider.getAbdera();
    }

    @Override
    public synchronized <T extends Element> Document<T> getDocument() throws ParseException, IOException {
        log.debug((Object)Localizer.get((String)"PARSING.REQUEST.DOCUMENT"));
        if (this.document == null) {
            this.document = this.getDocument(this.getAbdera().getParser());
        }
        return this.document;
    }

    @Override
    public synchronized <T extends Element> Document<T> getDocument(Parser parser) throws ParseException, IOException {
        log.debug((Object)Localizer.get((String)"PARSING.REQUEST.DOCUMENT"));
        if (parser == null) {
            parser = this.getAbdera().getParser();
        }
        if (parser == null) {
            throw new IllegalArgumentException("No Parser implementation was provided");
        }
        if (this.document == null) {
            this.document = this.getDocument(parser, parser.getDefaultParserOptions());
        }
        return this.document;
    }

    @Override
    public synchronized <T extends Element> Document<T> getDocument(ParserOptions options) throws ParseException, IOException {
        log.debug((Object)Localizer.get((String)"PARSING.REQUEST.DOCUMENT"));
        if (this.document == null) {
            this.document = this.getDocument(this.getAbdera().getParser(), options);
        }
        return this.document;
    }

    @Override
    public synchronized <T extends Element> Document<T> getDocument(Parser parser, ParserOptions options) throws ParseException, IOException {
        log.debug((Object)Localizer.get((String)"PARSING.REQUEST.DOCUMENT"));
        if (parser == null) {
            parser = this.getAbdera().getParser();
        }
        if (parser == null) {
            throw new IllegalArgumentException("No Parser implementation was provided");
        }
        if (this.document == null) {
            this.document = parser.parse(this.getInputStream(), this.getResolvedUri().toString(), options);
        }
        return this.document;
    }

    @Override
    public IRI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public IRI getResolvedUri() {
        return this.baseUri.resolve(this.getUri());
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public IRI getUri() {
        return this.requestUri;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Target getTarget() {
        return this.target;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public String getTargetPath() {
        String uri = this.getUri().toString();
        String cpath = this.getContextPath();
        return cpath == null ? uri : uri.substring(cpath.length());
    }

    @Override
    public RequestContext setAttribute(String name, Object value) {
        return this.setAttribute(RequestContext.Scope.REQUEST, name, value);
    }

    @Override
    public String urlFor(Object key, Object param) {
        return this.provider.urlFor(this, key, param);
    }

    @Override
    public String absoluteUrlFor(Object key, Object param) {
        return this.getResolvedUri().resolve(this.urlFor(key, param)).toString();
    }

    @Override
    public boolean isAtom() {
        try {
            return MimeTypeHelper.isAtom((String)this.getContentType().toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        Class<?> clazz = class$org$apache$abdera$protocol$server$context$AbstractRequestContext;
        if (clazz == null) {
            clazz = class$org$apache$abdera$protocol$server$context$AbstractRequestContext = new AbstractRequestContext[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
    }
}

