/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rpcadapter;

import com.ibm.websphere.rpcadapter.ConfigurationException;
import com.ibm.websphere.rpcadapter.ConvertorInfo;
import com.ibm.websphere.rpcadapter.DefaultValidator;
import com.ibm.websphere.rpcadapter.Ejb;
import com.ibm.websphere.rpcadapter.Messages;
import com.ibm.websphere.rpcadapter.MethodInfo;
import com.ibm.websphere.rpcadapter.ParameterInfo;
import com.ibm.websphere.rpcadapter.Pojo;
import com.ibm.websphere.rpcadapter.Validator;
import com.ibm.websphere.rpcadapter.serializers.ReturnTypesList;
import com.ibm.websphere.rpcadapter.util.RPCAdapterConstants;
import java.beans.MethodDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RPCContainer
extends RPCAdapterConstants {
    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public static Map getValidators() {
        return validators;
    }

    public static Map getServices() {
        return services;
    }

    public static Map getConverters() {
        return converters;
    }

    public static Map getParameters() {
        return parameters;
    }

    public void configure(ServletContext servletContext) throws ConfigurationException {
        this.isDebugEnabled = logger.isTraceEnabled();
        Document document = (Document)servletContext.getAttribute("inMemoryDD");
        if (document != null) {
            NodeList nodeList;
            Document document2 = document;
            NodeList nodeList2 = document2.getElementsByTagNameNS(SCHEMA_NAMESPACE, "validators");
            if (nodeList2.getLength() > 0) {
                this.initializeValidators((Element)nodeList2.item(0));
            }
            if ((nodeList = document2.getElementsByTagNameNS(SCHEMA_NAMESPACE, "serialized-params")).getLength() > 0) {
                this.initializeParameters((Element)nodeList.item(0));
            }
            NodeList nodeList3 = document2.getElementsByTagNameNS(SCHEMA_NAMESPACE, "services");
            this.initializeServices((Element)nodeList3.item(0));
            NodeList nodeList4 = document2.getElementsByTagNameNS(SCHEMA_NAMESPACE, "converters");
            if (nodeList4.getLength() > 0) {
                this.initializeConverters((Element)nodeList4.item(0));
            }
            this.initializeSubclassConverters();
            this.intitializeOtherParameters(document2);
        }
    }

    private void initializeSubclassConverters() {
        Object object;
        Object object2;
        HashSet hashSet = new HashSet();
        Map map = RPCContainer.getServices();
        MethodDescriptor[] methodDescriptorArray = null;
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            try {
                Pojo pojo = (Pojo)map.get(object2);
                methodDescriptorArray = pojo.getBeanInfo().getMethodDescriptors();
            }
            catch (ClassCastException classCastException) {
                object = (Ejb)map.get(object2);
                methodDescriptorArray = ((Ejb)object).getBeanInfo().getMethodDescriptors();
            }
            for (int i = 0; i < methodDescriptorArray.length; ++i) {
                try {
                    if (methodDescriptorArray[i].getMethod().getReturnType().getClass().isPrimitive()) continue;
                    ReturnTypesList.getList(hashSet, methodDescriptorArray[i].getMethod().getReturnType().newInstance(), false, false);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        iterator = hashSet.iterator();
        object2 = new Hashtable();
        while (iterator.hasNext()) {
            Object object3 = iterator.next();
            object = subclassconverters.keySet().iterator();
            while (object.hasNext()) {
                Object e = object.next();
                try {
                    if (!Class.forName(e.toString()).isAssignableFrom(Class.forName(object3.toString()))) continue;
                    object2.put(object3.toString(), subclassconverters.get(e));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        Iterator iterator2 = object2.keySet().iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            converters.put(object, object2.get(object));
        }
    }

    private void intitializeOtherParameters(Document document) {
        NodeList nodeList = document.getElementsByTagNameNS(SCHEMA_NAMESPACE, "default-format");
        if (nodeList.getLength() > 0 && nodeList.item(0).getChildNodes().item(0) != null) {
            this.defaultFormat = nodeList.item(0).getChildNodes().item(0).getNodeValue().trim();
        }
        if ((nodeList = document.getElementsByTagNameNS(SCHEMA_NAMESPACE, "filtered")).getLength() > 0 && nodeList.item(0).getChildNodes().item(0) != null) {
            this.filtered = nodeList.item(0).getChildNodes().item(0).getNodeValue().trim();
        }
        if ((nodeList = document.getElementsByTagNameNS(SCHEMA_NAMESPACE, "recursive-object-support")).getLength() > 0 && nodeList.item(0).getChildNodes().item(0) != null) {
            this.recursionSupport = nodeList.item(0).getChildNodes().item(0).getNodeValue().trim();
        }
    }

    private void initializeParameters(Element element) throws ConfigurationException {
        logger.debug((Object)"Starting method initializeParameters of RPCContainer");
        NodeList nodeList = element.getElementsByTagNameNS(SCHEMA_NAMESPACE, "serialized-param");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getChildNodes();
            int n2 = nodeList2.getLength();
            ArrayList<String> arrayList = new ArrayList<String>();
            ConvertorInfo convertorInfo = new ConvertorInfo();
            convertorInfo.setHiddenParams(arrayList);
            for (int j = 0; j < n2; ++j) {
                boolean bl;
                Object object;
                Node node = nodeList2.item(j);
                if (node.getLocalName() == null) continue;
                if (node.getLocalName().equals("serialized-param-type")) {
                    if (node.getChildNodes().item(0) == null) continue;
                    convertorInfo.setConvertorType(node.getChildNodes().item(0).getNodeValue().trim());
                    continue;
                }
                if (node.getLocalName().equals("suppressed-fields")) {
                    object = node.getChildNodes();
                    bl = object.getLength();
                    for (boolean bl2 = false; bl2 < bl; bl2 += 1) {
                        Node node2 = object.item(bl2 ? 1 : 0);
                        if (node2.getLocalName() == null || !node2.getLocalName().equals("suppressed-field") || node2.getChildNodes().item(0) == null) continue;
                        arrayList.add(node2.getChildNodes().item(0).getNodeValue().trim());
                    }
                    continue;
                }
                if (node.getLocalName().equals("suppress")) {
                    if (node.getChildNodes().item(0) == null) continue;
                    object = node.getChildNodes().item(0).getNodeValue().trim();
                    bl = Boolean.valueOf((String)object);
                    convertorInfo.setSuppressed(bl);
                    continue;
                }
                if (!node.getLocalName().equals("alias") || node.getChildNodes().item(0) == null) continue;
                object = node.getChildNodes().item(0).getNodeValue().trim();
                convertorInfo.setAlias((String)object);
            }
            parameters.put(convertorInfo.getConvertorType(), convertorInfo);
        }
        logger.debug((Object)"Ending method initializeParameters of RPCContainer");
    }

    private void initializeValidators(Element element) throws ConfigurationException {
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting method initializeValidators of RPCContainer");
        }
        NodeList nodeList = element.getElementsByTagNameNS(SCHEMA_NAMESPACE, "validator");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Element element3 = (Element)nodeList.item(i);
            String string = element3.getAttributes().getNamedItem("id").getNodeValue().trim();
            String string2 = null;
            String string3 = null;
            Element element4 = (Element)element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "validation-class").item(0);
            if (element4 != null && element4.getChildNodes().item(0) != null) {
                string2 = element4.getChildNodes().item(0).getNodeValue().trim();
            }
            if ((element2 = (Element)element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "validation-regex").item(0)) != null && element2.getChildNodes().item(0) != null) {
                string3 = element2.getChildNodes().item(0).getNodeValue().trim();
            }
            if (string3 == null && string2 == null) continue;
            try {
                Validator validator = null;
                if (string2 != null) {
                    Class<?> clazz = Class.forName(string2);
                    validator = (Validator)clazz.newInstance();
                } else {
                    validator = new DefaultValidator();
                }
                validator.setRegex(string3);
                validators.put(string, validator);
                continue;
            }
            catch (Exception exception) {
                throw new ConfigurationException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.validator_error"), string2.getClass().getName()), exception);
            }
        }
        if (this.isDebugEnabled) {
            logger.trace((Object)"Ending method initializeValidators of RPCContainer");
        }
    }

    private void initializeConverters(Element element) {
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting method initializeConverters of RPCContainer");
        }
        NodeList nodeList = element.getElementsByTagNameNS(SCHEMA_NAMESPACE, "converter");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Element element3 = (Element)nodeList.item(i);
            String string = null;
            String string2 = null;
            String string3 = "false";
            Element element4 = (Element)element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "bean-class").item(0);
            if (element4 != null && element4.getChildNodes().item(0) != null) {
                string2 = element4.getChildNodes().item(0).getNodeValue().trim();
            }
            if ((element2 = (Element)element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "converter-class").item(0)) == null || element2.getChildNodes().item(0) == null) continue;
            string = element2.getChildNodes().item(0).getNodeValue().trim();
            Element element5 = (Element)element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "subclass-support").item(0);
            if (element5 != null) {
                string3 = element5.getChildNodes().item(0).getNodeValue().trim();
            }
            if (element5 == null || !string3.equalsIgnoreCase("true")) {
                converters.put(string2, string);
                continue;
            }
            subclassconverters.put(string2, string);
        }
        if (this.isDebugEnabled) {
            logger.trace((Object)"Ending method initializeConverters of RPCContainer");
        }
    }

    private void initializeServices(Element element) throws ConfigurationException {
        NodeList nodeList = element.getElementsByTagNameNS(SCHEMA_NAMESPACE, "pojo");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            this.handlePojoService(element2);
        }
        NodeList nodeList2 = element.getElementsByTagNameNS(SCHEMA_NAMESPACE, "ejb");
        int n2 = nodeList2.getLength();
        for (int i = 0; i < n2; ++i) {
            Element element3 = (Element)nodeList2.item(i);
            this.handleEjbService(element3);
        }
    }

    private void handleEjbService(Element element) throws ConfigurationException {
        Object object;
        Node node;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Properties properties = null;
        Object var12_12 = null;
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        MethodInfo methodInfo = null;
        ArrayList<String> arrayList2 = null;
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting ejb handling service");
        }
        if ((node = element.getAttributes().getNamedItem("remote")) != null) {
            object = node.getNodeValue().trim();
            bl = ((String)object).equalsIgnoreCase("true");
        }
        object = element.getChildNodes();
        int n = object.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n2;
            Object object6;
            Node node2 = object.item(i);
            if (node2.getLocalName() == null) continue;
            if (node2.getLocalName().equals("ejb-name")) {
                if (node2.getChildNodes().item(0) == null) continue;
                string = node2.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (node2.getLocalName().equals("home")) {
                if (node2.getChildNodes().item(0) == null) continue;
                string2 = node2.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (node2.getLocalName().equals("remote")) {
                if (node2.getChildNodes().item(0) == null) continue;
                string3 = node2.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (node2.getLocalName().equals("business-interface")) {
                if (node2.getChildNodes().item(0) == null) continue;
                string4 = node2.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (node2.getLocalName().equals("session-type")) {
                if (node2.getChildNodes().item(0) == null) continue;
                string6 = node2.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (node2.getLocalName().equals("jndi-name")) {
                if (node2.getChildNodes().item(0) == null) continue;
                string5 = node2.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (node2.getLocalName().equals("configuration")) {
                properties = new Properties();
                object6 = node2.getChildNodes();
                int n3 = object6.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    String string7;
                    Node node3 = object6.item(n2);
                    if (node3.getLocalName() == null) continue;
                    if (node3.getLocalName().equals("initial-factory")) {
                        if (((Element)node3).getChildNodes().item(0) == null) continue;
                        string7 = ((Element)node3).getChildNodes().item(0).getNodeValue().trim();
                        properties.setProperty("java.naming.factory.initial", string7);
                        continue;
                    }
                    if (node3.getLocalName().equals("security-principal")) {
                        if (((Element)node3).getChildNodes().item(0) == null) continue;
                        string7 = ((Element)node3).getChildNodes().item(0).getNodeValue().trim();
                        properties.setProperty("java.naming.security.principal", string7);
                        continue;
                    }
                    if (node3.getLocalName().equals("security-credentials")) {
                        if (((Element)node3).getChildNodes().item(0) == null) continue;
                        string7 = ((Element)node3).getChildNodes().item(0).getNodeValue().trim();
                        properties.setProperty("java.naming.security.credentials", string7);
                        continue;
                    }
                    if (!node3.getLocalName().equals("provider-url") || ((Element)node3).getChildNodes().item(0) == null) continue;
                    string7 = ((Element)node3).getChildNodes().item(0).getNodeValue().trim();
                    properties.setProperty("java.naming.provider.url", string7);
                }
                continue;
            }
            if (node2.getLocalName().equals("validator-ref")) {
                if (node2.getChildNodes().getLength() == 0) continue;
                object6 = node2.getChildNodes().item(0).getNodeValue().trim();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object6, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                    }
                    arrayList2.add(stringTokenizer.nextToken());
                }
                continue;
            }
            if (node2.getLocalName().equals("create")) {
                methodInfo = new MethodInfo();
                methodInfo.setName("create");
                methodInfo.setAlias("create");
                object6 = (Element)node2;
                NodeList nodeList2 = object6.getElementsByTagName("parameters");
                n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node4 = nodeList2.item(j);
                    if (!node4.getLocalName().equals("parameters")) continue;
                    object5 = ((Element)node2).getElementsByTagNameNS(SCHEMA_NAMESPACE, "parameter");
                    int n4 = object5.getLength();
                    ParameterInfo[] parameterInfoArray = new ParameterInfo[n4];
                    if (object5 == null) continue;
                    ParameterInfo parameterInfo = null;
                    for (int k = 0; k < n4; ++k) {
                        parameterInfo = new ParameterInfo();
                        object4 = (Element)object5.item(k);
                        NodeList nodeList3 = object4.getChildNodes();
                        int n5 = nodeList3.getLength();
                        parameterInfo.setParameterIndex(k);
                        for (int i2 = 0; i2 < n5; ++i2) {
                            Node node5 = nodeList3.item(i2);
                            if (node5.getLocalName() == null) continue;
                            if (node5.getLocalName().equals("name")) {
                                if (node5.getChildNodes().item(0) != null) {
                                    object3 = node5.getChildNodes().item(0).getNodeValue().trim();
                                    parameterInfo.setName((String)object3);
                                }
                            } else if (node5.getLocalName().equals("type")) {
                                if (node5.getChildNodes().item(0) != null) {
                                    object3 = node5.getChildNodes().item(0).getNodeValue().trim();
                                    parameterInfo.setType((String)object3);
                                }
                            } else if (((Element)node5).getElementsByTagNameNS(SCHEMA_NAMESPACE, "description").getLength() > 0 && (object3 = ((Element)node5).getElementsByTagNameNS(SCHEMA_NAMESPACE, "description").item(0)).getChildNodes().item(0) != null) {
                                parameterInfo.setDescription(object3.getChildNodes().item(0).getNodeValue().trim());
                            }
                            if ((object3 = ((Element)node5).getElementsByTagNameNS(SCHEMA_NAMESPACE, "validator-ref").item(0)) == null) continue;
                            object2 = object3.getChildNodes().item(0).getNodeValue().trim();
                            parameterInfo.setValidators(this.toList((String)object2));
                        }
                        parameterInfoArray[k] = parameterInfo;
                    }
                    methodInfo.setParameters(parameterInfoArray);
                }
                arrayList.add(methodInfo);
                continue;
            }
            if (!node2.getLocalName().equals("methods")) continue;
            object6 = node2.getAttributes().getNamedItem("filter");
            if (object6 != null) {
                String string8 = object6.getNodeValue().trim();
                if (string8.equalsIgnoreCase("whitelisting")) {
                    bl2 = true;
                } else if (string8.equalsIgnoreCase("blacklisting")) {
                    bl3 = true;
                }
            }
            if ((nodeList = ((Element)node2).getElementsByTagNameNS(SCHEMA_NAMESPACE, "method")) == null) continue;
            n2 = nodeList.getLength();
            MethodInfo methodInfo2 = null;
            for (int j = 0; j < n2; ++j) {
                methodInfo2 = new MethodInfo();
                object5 = (Element)nodeList.item(j);
                NodeList nodeList4 = object5.getChildNodes();
                int n6 = nodeList4.getLength();
                for (int k = 0; k < n6; ++k) {
                    Node node6 = nodeList4.item(k);
                    if (node6.getLocalName() == null) continue;
                    if (node6.getLocalName().equals("name")) {
                        if (node6.getChildNodes().item(0) == null) continue;
                        object4 = node6.getChildNodes().item(0).getNodeValue().trim();
                        methodInfo2.setName((String)object4);
                        methodInfo2.setAlias((String)object4);
                        continue;
                    }
                    if (node6.getLocalName().equals("http-method")) {
                        if (node6.getChildNodes().item(0) == null) continue;
                        object4 = node6.getChildNodes().item(0).getNodeValue().trim();
                        methodInfo2.setHttpMethod((String)object4);
                        continue;
                    }
                    if (node6.getLocalName().equals("parameters")) {
                        object4 = ((Element)node6).getElementsByTagNameNS(SCHEMA_NAMESPACE, "parameter");
                        int n7 = object4.getLength();
                        ParameterInfo[] parameterInfoArray = new ParameterInfo[n7];
                        if (object4 != null) {
                            ParameterInfo parameterInfo = null;
                            for (int i3 = 0; i3 < n7; ++i3) {
                                parameterInfo = new ParameterInfo();
                                object3 = (Element)object4.item(i3);
                                object2 = object3.getChildNodes();
                                int n8 = object2.getLength();
                                parameterInfo.setParameterIndex(i3);
                                for (int i4 = 0; i4 < n8; ++i4) {
                                    Object object7;
                                    Node node7 = object2.item(i4);
                                    if (node7.getLocalName() == null) continue;
                                    if (node7.getLocalName().equals("name")) {
                                        object7 = node7.getChildNodes().item(0).getNodeValue().trim();
                                        parameterInfo.setName((String)object7);
                                        continue;
                                    }
                                    if (((Element)node7).getElementsByTagNameNS(SCHEMA_NAMESPACE, "description").getLength() > 0) {
                                        object7 = ((Element)node7).getElementsByTagNameNS(SCHEMA_NAMESPACE, "description").item(0);
                                        if (object7.getChildNodes().item(0) == null) continue;
                                        parameterInfo.setDescription(object7.getChildNodes().item(0).getNodeValue().trim());
                                        continue;
                                    }
                                    if (!node7.getLocalName().equals("validator-ref")) continue;
                                    object7 = node7.getChildNodes().item(0).getNodeValue().trim();
                                    parameterInfo.setValidators(this.toList((String)object7));
                                }
                                parameterInfoArray[i3] = parameterInfo;
                            }
                        } else {
                            logger.trace((Object)"no parameters found");
                        }
                        methodInfo2.setParameters(parameterInfoArray);
                        continue;
                    }
                    if (!node6.getLocalName().equals("add-to-session")) continue;
                    object4 = node6.getChildNodes().item(0);
                    String string9 = object4 == null ? null : object4.getNodeValue().trim();
                    methodInfo2.setSessionKey(string9);
                }
                arrayList.add(methodInfo2);
            }
        }
        try {
            if (string4 != null) {
                Ejb ejb = new Ejb(string, string4, string5, string6, arrayList, arrayList2, bl2, bl3);
                services.put(string, ejb);
            } else if (string6.equalsIgnoreCase("Stateless")) {
                Ejb ejb = new Ejb(string, string3, string2, bl, properties, string5, arrayList, arrayList2, bl2, bl3);
                services.put(string, ejb);
            } else if (string6.equalsIgnoreCase("Stateful")) {
                Ejb ejb = new Ejb(string, string3, string2, bl, properties, methodInfo, string5, arrayList, arrayList2, bl2, bl3);
                services.put(string, ejb);
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.ejb_error"), string));
            logger.trace((Object)exception);
            throw new ConfigurationException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.ejb_error"), string), exception);
        }
        if (this.isDebugEnabled) {
            logger.trace((Object)"Ending method handlePojoService of RPCContainer");
        }
    }

    private void handlePojoService(Element element) throws ConfigurationException {
        String string = null;
        String string2 = null;
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = null;
        ArrayList<MethodInfo> arrayList2 = null;
        if (this.isDebugEnabled) {
            logger.trace((Object)"Starting method handlePojoService of RPCContainer");
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Node node = nodeList.item(i);
            if (node.getLocalName() == null) continue;
            if (node.getLocalName().equals("name")) {
                string = node.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (node.getLocalName().equals("implementation")) {
                string2 = node.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (node.getLocalName().equals("validator-ref")) {
                if (node.getChildNodes().getLength() == 0) continue;
                object2 = node.getChildNodes().item(0).getNodeValue().trim();
                object = new StringTokenizer((String)object2, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(((StringTokenizer)object).nextToken());
                }
                continue;
            }
            if (node.getLocalName().equals("scope")) {
                if (node.getChildNodes().getLength() == 0) continue;
                string3 = node.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (!node.getLocalName().equals("methods")) continue;
            object2 = node.getAttributes().getNamedItem("filter");
            if (object2 != null) {
                object = object2.getNodeValue().trim();
                if (((String)object).equalsIgnoreCase("whitelisting")) {
                    bl = true;
                } else if (((String)object).equalsIgnoreCase("blacklisting")) {
                    bl2 = true;
                }
            }
            arrayList2 = new ArrayList<MethodInfo>();
            object = ((Element)node).getElementsByTagNameNS(SCHEMA_NAMESPACE, "method");
            if (object == null) continue;
            int n2 = object.getLength();
            MethodInfo methodInfo = null;
            for (int j = 0; j < n2; ++j) {
                methodInfo = new MethodInfo();
                Element element2 = (Element)object.item(j);
                NodeList nodeList2 = element2.getChildNodes();
                int n3 = nodeList2.getLength();
                for (int k = 0; k < n3; ++k) {
                    Object object3;
                    Node node2 = nodeList2.item(k);
                    if (node2.getLocalName() == null) continue;
                    if (node2.getLocalName().equals("name")) {
                        if (node2.getChildNodes().item(0) == null) continue;
                        object3 = node2.getChildNodes().item(0).getNodeValue().trim();
                        methodInfo.setName((String)object3);
                        methodInfo.setAlias((String)object3);
                        continue;
                    }
                    if (node2.getLocalName().equals("alias")) {
                        if (node2.getChildNodes().item(0) == null) continue;
                        object3 = node2.getChildNodes().item(0).getNodeValue().trim();
                        methodInfo.setName((String)object3);
                        continue;
                    }
                    if (node2.getLocalName().equals("parameters")) {
                        object3 = ((Element)node2).getElementsByTagNameNS(SCHEMA_NAMESPACE, "parameter");
                        int n4 = object3.getLength();
                        ParameterInfo parameterInfo = null;
                        Element element3 = null;
                        Node node3 = null;
                        Node node4 = null;
                        Node node5 = null;
                        ParameterInfo[] parameterInfoArray = new ParameterInfo[n4];
                        for (int i2 = 0; i2 < n4; ++i2) {
                            parameterInfo = new ParameterInfo();
                            element3 = (Element)object3.item(i2);
                            node3 = element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "name").item(0);
                            if (node3.getChildNodes().item(0) != null) {
                                parameterInfo.setName(node3.getChildNodes().item(0).getNodeValue().trim());
                            }
                            parameterInfo.setParameterIndex(i2);
                            if (element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "type").getLength() > 0 && (node4 = element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "type").item(0)).getChildNodes().item(0) != null) {
                                parameterInfo.setType(node4.getChildNodes().item(0).getNodeValue().trim());
                            }
                            if (element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "description").getLength() > 0 && (node4 = element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "description").item(0)).getChildNodes().item(0) != null) {
                                parameterInfo.setDescription(node4.getChildNodes().item(0).getNodeValue().trim());
                            }
                            node5 = element3.getElementsByTagNameNS(SCHEMA_NAMESPACE, "validator-ref").item(0);
                            String string4 = null;
                            if (node5 != null) {
                                string4 = node5.getChildNodes().item(0).getNodeValue().trim();
                                parameterInfo.setValidators(this.toList(string4));
                            }
                            parameterInfoArray[i2] = parameterInfo;
                        }
                        methodInfo.setParameters(parameterInfoArray);
                        continue;
                    }
                    if (node2.getLocalName().equals("http-method")) {
                        if (node2.getChildNodes().item(0) == null) continue;
                        methodInfo.setHttpMethod(node2.getChildNodes().item(0).getNodeValue().trim());
                        continue;
                    }
                    if (!node2.getLocalName().equals("add-to-session") || (object3 = node2.getChildNodes().item(0)) == null) continue;
                    String string5 = object3 == null ? null : object3.getNodeValue().trim();
                    methodInfo.setSessionKey(string5);
                }
                arrayList2.add(methodInfo);
            }
        }
        try {
            Pojo pojo = new Pojo(Class.forName(string2), arrayList2, arrayList, bl, bl2, string3);
            services.put(string, pojo);
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.pojo_error"), string));
            logger.trace((Object)exception);
            throw new ConfigurationException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.pojo_error"), string), exception);
        }
        if (this.isDebugEnabled) {
            logger.trace((Object)"Ending method handlePojoService of RPCContainer");
        }
    }

    private List toList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public String getFiltered() {
        return this.filtered;
    }

    public boolean isRecursionSupport() {
        return Boolean.valueOf(this.recursionSupport);
    }
}

