/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rpcadapter;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.rpcadapter.ConfigurationException;
import com.ibm.websphere.rpcadapter.Ejb;
import com.ibm.websphere.rpcadapter.Error;
import com.ibm.websphere.rpcadapter.Messages;
import com.ibm.websphere.rpcadapter.MethodInfo;
import com.ibm.websphere.rpcadapter.Pages;
import com.ibm.websphere.rpcadapter.ParameterInfo;
import com.ibm.websphere.rpcadapter.Pojo;
import com.ibm.websphere.rpcadapter.RPCContainer;
import com.ibm.websphere.rpcadapter.Validator;
import com.ibm.websphere.rpcadapter.XmlConfigErrorHandler;
import com.ibm.websphere.rpcadapter.annotations.AnnotationParser;
import com.ibm.websphere.rpcadapter.serializers.JsonToObject;
import com.ibm.websphere.rpcadapter.serializers.ObjectToJson;
import com.ibm.websphere.rpcadapter.serializers.ToXML;
import com.ibm.websphere.rpcadapter.util.RPCAdapterConstants;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.retroweaver.runtime.java.lang.Boolean_;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import net.sourceforge.retroweaver.runtime.java.lang.String_;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RPCAdapter
extends HttpServlet
implements Servlet {
    private static final String VALIDATION_ERROR_01 = "CWRPC0008E";
    private static final String VALIDATION_ERROR_02 = "CWRPC0009E";
    private static final String JSONRPCError = "JSONRPCError";
    private static final String XMLRPCError = "XMLRPCError";
    private static final String ERROR_04 = "CWRPC0001E";
    private static final String COMMENT_START = "/*";
    private static final String COMMENT_END = "*/";
    private static final String CLASS_NAME;
    private static final Log logger;
    private boolean isTraceEnabled = logger.isTraceEnabled();
    private static RPCContainer rpcContainer;
    private Boolean AnnotationPresent = Boolean_.valueOf((boolean)false);
    public static String SESSION_APP_PREFIX;
    private static final /* synthetic */ Class class$com$ibm$websphere$rpcadapter$RPCAdapter;
    private static final /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    private static final /* synthetic */ Class class$java$lang$String;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.isTraceEnabled = logger.isTraceEnabled();
        Document document = null;
        String string = servletConfig.getServletContext().getRealPath("/WEB-INF/RpcAdapterConfig.xml");
        Document document2 = null;
        try {
            try {
                document2 = this.getDocumentRoot(string);
            }
            catch (IOException iOException) {
                logger.error((Object)Messages.getMessage("rpcadapter.msg.config_file"), (Throwable)iOException);
                throw new ConfigurationException(Messages.getMessage("rpcadapter.msg.config_file"), iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                logger.error((Object)Messages.getMessage("rpcadapter.msg.config_file"), (Throwable)parserConfigurationException);
                throw new ConfigurationException(Messages.getMessage("rpcadapter.msg.config_file"), parserConfigurationException);
            }
            NodeList nodeList = document2.getElementsByTagName("rpcAdapter");
            RPCAdapterConstants.SCHEMA_NAMESPACE = nodeList.item(0).getNamespaceURI();
            Enumeration enumeration = servletConfig.getInitParameterNames();
            if (enumeration.hasMoreElements()) {
                Object object;
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (!((String)object).toLowerCase().startsWith("class")) continue;
                    this.AnnotationPresent = Boolean_.valueOf((boolean)true);
                }
                if (this.AnnotationPresent.booleanValue()) {
                    try {
                        object = Class.forName("com.ibm.websphere.rpcadapter.annotations.AnnotationParser");
                        AnnotationParser annotationParser = (AnnotationParser)((Class)object).newInstance();
                        document = annotationParser.annotationParser(servletConfig);
                        if (null == document) {
                            document = this.getInMemoryDD(servletConfig);
                        }
                        servletConfig.getServletContext().setAttribute("inMemoryDD", (Object)document);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.error((Object)Messages.getMessage("rpcadapter.msg.annotation_jar_not_found"), (Throwable)classNotFoundException);
                        throw new ConfigurationException(Messages.getMessage("rpcadapter.msg.annotation_jar_not_found"), classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {}
                } else {
                    document = this.getInMemoryDD(servletConfig);
                }
            } else {
                document = this.getInMemoryDD(servletConfig);
            }
            if (rpcContainer == null) {
                rpcContainer = new RPCContainer();
                rpcContainer.configure(servletConfig.getServletContext());
            }
        }
        catch (ConfigurationException configurationException) {
            logger.error((Object)"In init method of RPCAdapter", (Throwable)configurationException);
            throw new ServletException((Throwable)configurationException);
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isTraceEnabled) {
            logger.trace((Object)"Start doGet method of RPCAdapter");
        }
        String string = httpServletRequest.getPathInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.invocation_url"), string));
        if (string.startsWith("/httprpc")) {
            switch (stringTokenizer.countTokens()) {
                case 1: {
                    httpServletResponse.setContentType("text/html; charset=UTF-8");
                    Pages.renderServiceIndex(httpServletResponse.getWriter(), rpcContainer.getServices(), httpServletRequest.getRequestURL().toString());
                    break;
                }
                case 2: {
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken();
                    Object v = rpcContainer.getServices().get(string2);
                    if (v instanceof Pojo) {
                        Pojo pojo = (Pojo)v;
                        httpServletResponse.setContentType("text/html; charset=UTF-8");
                        Pages.renderPojoInfo(httpServletResponse.getWriter(), pojo, httpServletRequest.getRequestURL().toString());
                    } else if (v instanceof Ejb) {
                        Ejb ejb = (Ejb)v;
                        httpServletResponse.setContentType("text/html; charset=UTF-8");
                        Pages.renderEjbInfo(httpServletResponse.getWriter(), ejb, httpServletRequest.getRequestURL().toString());
                    }
                    if (v != null) break;
                    logger.info((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string2));
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string2));
                }
                case 3: {
                    try {
                        this.processService(httpServletRequest, httpServletResponse);
                        break;
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception);
                        throw new ServletException((Throwable)exception);
                    }
                }
            }
        } else if (string.startsWith("/jsonrpc")) {
            boolean bl;
            String string3;
            Object object;
            stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            Object v = rpcContainer.getServices().get(string4);
            if (v instanceof Ejb) {
                object = (Ejb)v;
                if (object == null) {
                    logger.info((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string4));
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string4));
                }
                string3 = ((Ejb)object).getSMD(string4, httpServletRequest.getRequestURI()).serialize();
                bl = Boolean.valueOf(rpcContainer.getFiltered());
                if (bl) {
                    httpServletResponse.setContentType("text/json-comment-filtered");
                    httpServletResponse.getWriter().print(COMMENT_START + string3 + COMMENT_END);
                } else {
                    httpServletResponse.setContentType("application/json");
                    httpServletResponse.getWriter().print(string3);
                }
                logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.smd_service"), string4, string3));
            }
            if (v instanceof Pojo) {
                object = (Pojo)v;
                if (object == null) {
                    logger.info((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string4));
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string4));
                }
                string3 = ((Pojo)object).getSMD(string4, httpServletRequest.getRequestURI()).serialize();
                bl = Boolean.valueOf(rpcContainer.getFiltered());
                if (bl) {
                    httpServletResponse.setContentType("text/json-comment-filtered");
                    httpServletResponse.getWriter().print(COMMENT_START + string3 + COMMENT_END);
                } else {
                    httpServletResponse.setContentType("application/json");
                    httpServletResponse.getWriter().print(string3);
                }
                logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.smd_service"), string4, string3));
            }
        } else if (string.startsWith("/jsonbatch")) {
            boolean bl = Boolean.valueOf(rpcContainer.getFiltered());
            if (bl) {
                httpServletResponse.setContentType("text/json-comment-filtered");
                httpServletResponse.getWriter().print("/*{\"batch\":\"true\"}*/");
            } else {
                httpServletResponse.setContentType("application/json");
                httpServletResponse.getWriter().print("{\"batch\":\"true\"}");
            }
        }
        if (this.isTraceEnabled) {
            logger.trace((Object)"End doGet method of RPCAdapter");
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            String string = (String)httpServletRequest.getAttribute("path");
            if (string == null) {
                string = httpServletRequest.getPathInfo();
            }
            if (string.equalsIgnoreCase("AccessCheck")) {
                return;
            }
            if (this.isTraceEnabled) {
                logger.trace((Object)"Starting doPost method of RPCAdapter");
            }
            logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.invocation_url"), string));
            if (string.startsWith("/httprpc")) {
                this.processService(httpServletRequest, httpServletResponse);
            } else if (string.startsWith("/jsonrpc")) {
                this.processJsonrpc(httpServletRequest, httpServletResponse);
            } else if (string.startsWith("/jsonbatch")) {
                this.processJsonBatch(httpServletRequest, httpServletResponse);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            throw new ServletException((Throwable)exception);
        }
        if (this.isTraceEnabled) {
            logger.trace((Object)"Ending doPost method of RPCAdapter");
        }
    }

    private void processSmds(String string, HttpServletResponse httpServletResponse, JSONArray jSONArray) throws IOException {
        int n;
        Pojo pojo = null;
        String string2 = null;
        Error error = null;
        int n2 = jSONArray.size();
        Object var8_8 = null;
        String string3 = null;
        Object var10_10 = null;
        StringBuffer stringBuffer = new StringBuffer("[");
        for (n = 0; n < n2; ++n) {
            string3 = (String)jSONArray.get(n);
            pojo = (Pojo)rpcContainer.getServices().get(string3);
            if (pojo != null) {
                string2 = pojo.getSMD(string3, String_.replace((String)string, (CharSequence)"jsonbatch", (CharSequence)("jsonrpc/" + string3))).serialize();
                stringBuffer.append(string2);
                stringBuffer.append(",");
                continue;
            }
            error = new Error(ERROR_04, MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string3), null, null, string3, null, null);
            try {
                JSONObject jSONObject = (JSONObject)ObjectToJson.toJson(error, null, false);
                stringBuffer.append(jSONObject.serialize());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)"", (Throwable)illegalArgumentException);
            }
            catch (IntrospectionException introspectionException) {
                logger.error((Object)"", (Throwable)introspectionException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.error((Object)"", (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.error((Object)"", (Throwable)invocationTargetException);
            }
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(","));
        stringBuffer.append("]");
        n = Boolean.valueOf(rpcContainer.getFiltered()).booleanValue() ? 1 : 0;
        if (n != 0) {
            httpServletResponse.setContentType("text/json-comment-filtered");
            httpServletResponse.getWriter().print(COMMENT_START + stringBuffer.toString() + COMMENT_END);
        } else {
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().print(stringBuffer.toString());
        }
        logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.response_json"), stringBuffer.toString()));
        if (this.isTraceEnabled) {
            logger.trace((Object)"Ending processJsonBatch method of RPCAdapter Time");
        }
    }

    private void processService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, SecurityException, NoSuchMethodException, InstantiationException, IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException, TransformerConfigurationException, IOException, TransformerException, ParserConfigurationException, FactoryConfigurationError, ClassNotFoundException, ConfigurationException {
        int n;
        Object object;
        Class<?> clazz;
        List list;
        Object object2;
        Class<?> clazz2;
        int n2;
        Object object3;
        int n3;
        Object object4;
        Object object5;
        Object object6;
        Method method;
        Object object7;
        if (this.isTraceEnabled) {
            logger.trace((Object)"Starting processService method of RPCAdapter");
        }
        String string = httpServletRequest.getPathInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = httpServletRequest.getParameter("format");
        if (string4 == null) {
            string4 = rpcContainer.getDefaultFormat() != null ? rpcContainer.getDefaultFormat() : "xml";
        }
        string4 = string4.toLowerCase();
        logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.service_and_method_name"), string2, string3));
        Object v = rpcContainer.getServices().get(string2);
        Object[] objectArray = null;
        boolean bl = false;
        if (v instanceof Ejb) {
            Object object8;
            MethodDescriptor[] methodDescriptorArray;
            object7 = (Ejb)v;
            method = null;
            object6 = null;
            object5 = null;
            if (string3.equalsIgnoreCase("create")) {
                Object object9;
                object4 = null;
                methodDescriptorArray = ((Ejb)object7).getConfiguredMethods();
                object8 = methodDescriptorArray.iterator();
                int n4 = 0;
                while (object8.hasNext()) {
                    object9 = (MethodInfo)object8.next();
                    if (!((MethodInfo)object9).getName().equalsIgnoreCase("create")) continue;
                    object4 = object9;
                }
                object9 = ((MethodInfo)object4).getParameters();
                objectArray = new Object[((ParameterInfo[])object9).length];
                n3 = httpServletRequest.getParameterMap().entrySet().size();
                if (httpServletRequest.getParameter("format") != null) {
                    --n3;
                }
                if (n3 == ((Object)object9).length) {
                    int n5 = 0;
                    while (n5 + n4 < ((Object)object9).length) {
                        Object object10;
                        object3 = ((ParameterInfo)object9[n5 + n4]).getType().getClass();
                        if (object3.isArray()) {
                            object10 = httpServletRequest.getParameterValues(((ParameterInfo)object9[n5 + n4]).getName());
                            Class<?> clazz3 = object3.getComponentType();
                            Object object11 = Array.newInstance(clazz3, ((String[])object10).length);
                            for (n2 = 0; n2 < ((String[])object10).length; ++n2) {
                                Array.set(object11, n2, this.getInstance(clazz3, object10[n2]));
                            }
                            objectArray[n5 + n4] = object11;
                        } else {
                            object10 = httpServletRequest.getParameter(((ParameterInfo)object9[n5 + n4]).getName());
                            objectArray[n5 + n4] = this.getInstance((Class)object3, (String)object10);
                        }
                        ++n5;
                    }
                    ((Ejb)object7).statefulLookUp(objectArray);
                    bl = true;
                }
                this.putinSession(httpServletRequest, string2, (Ejb)object7);
            } else {
                if (object7 == null) {
                    logger.trace((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string2));
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string2));
                }
                object4 = ((Ejb)object7).getBeanInfo();
                methodDescriptorArray = object4.getMethodDescriptors();
                boolean bl2 = false;
                List list2 = ((Ejb)object7).getConfiguredMethods();
                object6 = this.getMethodInfo(string3, list2);
                for (int i = 0; i < methodDescriptorArray.length && !bl2; ++i) {
                    if (!methodDescriptorArray[i].getName().equals(string3) || !((Ejb)object7).isAllowed(string3)) continue;
                    if (!((Ejb)object7).getHttpMethod(methodDescriptorArray[i]).equalsIgnoreCase(httpServletRequest.getMethod())) {
                        throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.unsupported_http_method"), ((Ejb)object7).getHttpMethod(methodDescriptorArray[i])));
                    }
                    method = methodDescriptorArray[i].getMethod();
                    ParameterInfo[] parameterInfoArray = null;
                    if (object6 != null) {
                        parameterInfoArray = ((MethodInfo)object6).getParameters();
                    }
                    if (parameterInfoArray == null) {
                        parameterInfoArray = new ParameterInfo[]{};
                    }
                    ParameterDescriptor[] parameterDescriptorArray = methodDescriptorArray[i].getParameterDescriptors();
                    object3 = method.getParameterTypes();
                    objectArray = new Object[((Class<?>[])object3).length];
                    if (parameterInfoArray.length != 0 && parameterDescriptorArray != null && parameterDescriptorArray.length != parameterInfoArray.length) {
                        throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.invalid_configuration"), string3));
                    }
                    int n6 = 0;
                    int n7 = parameterDescriptorArray != null ? parameterDescriptorArray.length : 0;
                    int n8 = httpServletRequest.getParameterMap().entrySet().size();
                    if (httpServletRequest.getParameter("format") != null) {
                        --n8;
                    }
                    if (n8 + 1 == ((Class<?>[])object3).length) {
                        Class<?> clazz4 = object3[0];
                        Class<?> clazz5 = class$javax$servlet$http$HttpServletRequest;
                        if (clazz5 == null) {
                            clazz5 = new HttpServletRequest[0].getClass().getComponentType();
                        }
                        if (clazz4 == clazz5) {
                            objectArray[0] = httpServletRequest;
                            n6 = 1;
                        } else {
                            object5 = new Error(this.getErrorName(string4), VALIDATION_ERROR_01, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr01"), string3), string3, string2, null, null);
                        }
                    } else if (n8 != ((Class<?>[])object3).length) {
                        object5 = new Error(this.getErrorName(string4), VALIDATION_ERROR_01, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr01"), string3), string3, string2, null, null);
                    }
                    if (object5 == null) {
                        n2 = 0;
                        while (n2 + n6 < ((Class<?>[])object3).length) {
                            clazz2 = object3[n2 + n6];
                            if (clazz2.isArray()) {
                                object2 = httpServletRequest.getParameterValues(parameterDescriptorArray[n2 + n6].getName());
                                list = null;
                                if (parameterInfoArray.length != 0) {
                                    list = parameterInfoArray[n2 + n6].getValidators();
                                }
                                if (list == null || list.size() == 0) {
                                    list = ((Ejb)object7).getValidators();
                                }
                                if (list != null && list.size() != 0) {
                                    object5 = this.isValidationSuccess(objectArray[n2 + n6], clazz2, n2, string2, string3, list, string4);
                                }
                                if (object5 == null) {
                                    clazz = clazz2.getComponentType();
                                    object = Array.newInstance(clazz, ((String[])object2).length);
                                    for (n = 0; n < ((String[])object2).length; ++n) {
                                        Array.set(object, n, this.getInstance(clazz, object2[n]));
                                    }
                                    objectArray[n2 + n6] = object;
                                }
                            } else {
                                object2 = httpServletRequest.getParameter(parameterDescriptorArray[n2 + n6].getName());
                                if (parameterInfoArray.length != 0) {
                                    list = parameterInfoArray[n2 + n6].getValidators();
                                    if (list != null && list.size() == 0) {
                                        list.addAll(((Ejb)object7).getValidators());
                                    }
                                    object5 = this.isValidationSuccess(object2, clazz2, n2, string2, string3, list, string4);
                                }
                                if (object5 == null) {
                                    objectArray[n2 + n6] = this.getInstance(clazz2, (String)object2);
                                }
                            }
                            ++n2;
                        }
                    }
                    bl2 = true;
                }
                if (!bl2) {
                    logger.info((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.method_not_found"), string3));
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.method_not_found"), string3));
                }
            }
            if (!bl) {
                object4 = null;
                boolean bl3 = Boolean.valueOf(rpcContainer.getFiltered());
                if (string2 != null) {
                    if (object5 == null) {
                        try {
                            object4 = method.invoke(this.getServiceInstance(string2, httpServletRequest), objectArray);
                            if (object6 != null && ((MethodInfo)object6).getSessionKey() != null) {
                                httpServletRequest.getSession(true).setAttribute(((MethodInfo)object6).getSessionKey(), object4);
                            }
                        }
                        catch (Exception exception) {
                            logger.error((Object)Messages.getMessage("rpcadapter.msg.app_error"), (Throwable)exception);
                            object5 = new Error(null, "CWRPC0012E", Messages.getMessage("rpcadapter.msg.app_error"), string3, string2, null, null);
                            ((Error)object5).setStackTrace(this.processException(exception, (Error)object5));
                        }
                    }
                    if (object5 == null) {
                        if ("json".equals(string4)) {
                            object8 = new JSONObject();
                            object8.put((Object)"result", ObjectToJson.toJson(object4, rpcContainer.getParameters(), rpcContainer.isRecursionSupport()));
                            String string5 = object8.serialize();
                            if (bl3) {
                                httpServletResponse.setContentType("text/json-comment-filtered");
                                httpServletResponse.getWriter().print(COMMENT_START + string5 + COMMENT_END);
                            } else {
                                httpServletResponse.setContentType("application/json");
                                httpServletResponse.getWriter().print(string5);
                            }
                            logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.response_json"), string5));
                        } else {
                            httpServletResponse.setContentType("application/xml");
                            if (object4 instanceof Error) {
                                ((Error)object4).setName(XMLRPCError);
                            }
                            ToXML.serializeBean(object4, rpcContainer.getParameters(), (OutputStream)httpServletResponse.getOutputStream(), false, rpcContainer.isRecursionSupport());
                            if (this.isTraceEnabled) {
                                logger.trace((Object)("Service Name:" + string2 + ":methodName is:" + string3));
                                object8 = new ByteArrayOutputStream();
                                ToXML.serializeBean(object4, rpcContainer.getParameters(), (OutputStream)object8, false, rpcContainer.isRecursionSupport());
                                logger.trace((Object)"The xml output is:\n");
                                logger.trace((Object)((ByteArrayOutputStream)object8).toString());
                                logger.trace((Object)"\n");
                                logger.trace((Object)("End of service:" + string2 + ":methodName is:" + string3));
                            }
                        }
                    } else if ("json".equals(string4)) {
                        object8 = new JSONObject();
                        ((Error)object5).setName(JSONRPCError);
                        object8.put((Object)"error", ObjectToJson.toJson(object5, null, false));
                        String string6 = object8.serialize();
                        if (bl3) {
                            httpServletResponse.setContentType("text/json-comment-filtered");
                            httpServletResponse.getWriter().print(COMMENT_START + string6 + COMMENT_END);
                        } else {
                            httpServletResponse.setContentType("application/json");
                            httpServletResponse.getWriter().print(string6);
                        }
                        logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.response_json"), string6));
                    } else {
                        httpServletResponse.setContentType("application/xml");
                        ((Error)object5).setName(XMLRPCError);
                        ToXML.serializeBean(object5, null, (OutputStream)httpServletResponse.getOutputStream(), true, false);
                    }
                    if (this.isTraceEnabled) {
                        logger.trace((Object)"Ending processService method of RPCAdapter");
                    }
                }
            }
        }
        if (v instanceof Pojo) {
            object7 = (Pojo)v;
            method = null;
            if (object7 == null) {
                logger.info((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string2));
                throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string2));
            }
            object6 = ((Pojo)object7).getBeanInfo();
            object5 = object6.getMethodDescriptors();
            object4 = null;
            Error error = null;
            boolean bl4 = false;
            List list3 = ((Pojo)object7).getConfiguredMethods();
            object4 = this.getMethodInfo(string3, list3);
            for (int i = 0; i < ((MethodDescriptor[])object5).length && !bl4; ++i) {
                if (!object5[i].getDisplayName().equals(string3) || !((Pojo)object7).isAllowed(object5[i])) continue;
                if (!((Pojo)object7).getHttpMethod(object5[i]).equalsIgnoreCase(httpServletRequest.getMethod())) {
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.unsupported_http_method"), ((Pojo)object7).getHttpMethod(object5[i])));
                }
                method = object5[i].getMethod();
                ParameterInfo[] parameterInfoArray = null;
                if (object4 != null) {
                    parameterInfoArray = ((MethodInfo)object4).getParameters();
                }
                if (parameterInfoArray == null) {
                    parameterInfoArray = new ParameterInfo[]{};
                }
                ParameterDescriptor[] parameterDescriptorArray = object5[i].getParameterDescriptors();
                object3 = method.getParameterTypes();
                objectArray = new Object[((Class<?>[])object3).length];
                if (parameterInfoArray.length != 0 && parameterDescriptorArray != null && parameterDescriptorArray.length != parameterInfoArray.length) {
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.invalid_configuration"), string3));
                }
                int n9 = 0;
                int n10 = parameterDescriptorArray != null ? parameterDescriptorArray.length : 0;
                int n11 = httpServletRequest.getParameterMap().entrySet().size();
                if (httpServletRequest.getParameter("format") != null) {
                    --n11;
                }
                if (n11 + 1 == ((Class<?>[])object3).length) {
                    Class<?> clazz6 = object3[0];
                    Class<?> clazz7 = class$javax$servlet$http$HttpServletRequest;
                    if (clazz7 == null) {
                        clazz7 = new HttpServletRequest[0].getClass().getComponentType();
                    }
                    if (clazz6 == clazz7) {
                        objectArray[0] = httpServletRequest;
                        n9 = 1;
                    } else {
                        error = new Error(this.getErrorName(string4), VALIDATION_ERROR_01, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr01"), string3), string3, string2, null, null);
                    }
                } else if (n11 != ((Class<?>[])object3).length) {
                    error = new Error(this.getErrorName(string4), VALIDATION_ERROR_01, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr01"), string3), string3, string2, null, null);
                }
                if (error == null) {
                    n2 = 0;
                    while (n2 + n9 < ((Class<?>[])object3).length) {
                        clazz2 = object3[n2 + n9];
                        if (clazz2.isArray()) {
                            object2 = httpServletRequest.getParameterValues(parameterDescriptorArray[n2 + n9].getName());
                            list = null;
                            if (parameterInfoArray.length != 0) {
                                list = parameterInfoArray[n2 + n9].getValidators();
                            }
                            if (list == null || list.size() == 0) {
                                list = ((Pojo)object7).getValidators();
                            }
                            if (list != null && list.size() != 0) {
                                error = this.isValidationSuccess(objectArray[n2 + n9], clazz2, n2, string2, string3, list, string4);
                            }
                            if (error == null) {
                                clazz = clazz2.getComponentType();
                                object = Array.newInstance(clazz, ((String[])object2).length);
                                for (n = 0; n < ((String[])object2).length; ++n) {
                                    Array.set(object, n, this.getInstance(clazz, object2[n]));
                                }
                                objectArray[n2 + n9] = object;
                            }
                        } else {
                            object2 = httpServletRequest.getParameter(parameterDescriptorArray[n2 + n9].getName());
                            if (parameterInfoArray.length != 0) {
                                list = parameterInfoArray[n2 + n9].getValidators();
                                if (list != null && list.size() == 0) {
                                    list.addAll(((Pojo)object7).getValidators());
                                }
                                error = this.isValidationSuccess(object2, clazz2, n2, string2, string3, list, string4);
                            }
                            if (error == null) {
                                objectArray[n2 + n9] = this.getInstance(clazz2, (String)object2);
                            }
                        }
                        ++n2;
                    }
                }
                bl4 = true;
            }
            if (!bl4) {
                logger.info((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.method_not_found"), string3));
                throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.method_not_found"), string3));
            }
            Object object12 = null;
            n3 = Boolean.valueOf(rpcContainer.getFiltered()).booleanValue() ? 1 : 0;
            if (string2 != null) {
                if (error == null) {
                    try {
                        object12 = method.invoke(this.getServiceInstance(string2, httpServletRequest), objectArray);
                        if (object4 != null && ((MethodInfo)object4).getSessionKey() != null) {
                            httpServletRequest.getSession(true).setAttribute(((MethodInfo)object4).getSessionKey(), object12);
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)Messages.getMessage("rpcadapter.msg.app_error"), (Throwable)exception);
                        error = new Error(null, "CWRPC0012E", Messages.getMessage("rpcadapter.msg.app_error"), string3, string2, null, null);
                        error.setStackTrace(this.processException(exception, error));
                    }
                }
                if (error == null) {
                    if ("json".equals(string4)) {
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put((Object)"result", ObjectToJson.toJson(object12, rpcContainer.getParameters(), rpcContainer.isRecursionSupport()));
                        object3 = jSONObject.serialize();
                        if (n3 != 0) {
                            httpServletResponse.setContentType("text/json-comment-filtered");
                            httpServletResponse.getWriter().print(COMMENT_START + object3 + COMMENT_END);
                        } else {
                            httpServletResponse.setContentType("application/json");
                            httpServletResponse.getWriter().print((String)object3);
                        }
                        logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.response_json"), object3));
                    } else {
                        httpServletResponse.setContentType("application/xml");
                        if (object12 instanceof Error) {
                            ((Error)object12).setName(XMLRPCError);
                        }
                        ToXML.serializeBean(object12, rpcContainer.getParameters(), (OutputStream)httpServletResponse.getOutputStream(), false, rpcContainer.isRecursionSupport());
                        if (this.isTraceEnabled) {
                            logger.trace((Object)("Service Name:" + string2 + ":methodName is:" + string3));
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            ToXML.serializeBean(object12, rpcContainer.getParameters(), byteArrayOutputStream, false, rpcContainer.isRecursionSupport());
                            logger.trace((Object)"The xml output is:\n");
                            logger.trace((Object)byteArrayOutputStream.toString());
                            logger.trace((Object)"\n");
                            logger.trace((Object)("End of service:" + string2 + ":methodName is:" + string3));
                        }
                    }
                } else if ("json".equals(string4)) {
                    JSONObject jSONObject = new JSONObject();
                    error.setName(JSONRPCError);
                    jSONObject.put((Object)"error", ObjectToJson.toJson(error, null, false));
                    object3 = jSONObject.serialize();
                    if (n3 != 0) {
                        httpServletResponse.setContentType("text/json-comment-filtered");
                        httpServletResponse.getWriter().print(COMMENT_START + object3 + COMMENT_END);
                    } else {
                        httpServletResponse.setContentType("application/json");
                        httpServletResponse.getWriter().print((String)object3);
                    }
                    logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.response_json"), object3));
                } else {
                    httpServletResponse.setContentType("application/xml");
                    error.setName(XMLRPCError);
                    ToXML.serializeBean(error, null, (OutputStream)httpServletResponse.getOutputStream(), true, false);
                }
                if (this.isTraceEnabled) {
                    logger.trace((Object)"Ending processService method of RPCAdapter");
                }
            }
        }
    }

    private void processJsonBatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.isTraceEnabled) {
            logger.trace((Object)"Starting processJsonBatch method of RPCAdapter");
        }
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        JSONArray jSONArray = JSONArray.parse((InputStream)servletInputStream);
        servletInputStream.close();
        String string = null;
        if (jSONArray.get(0) instanceof JSONObject) {
            String string2;
            for (int i = 0; i < jSONArray.size(); i += 2) {
                string = (String)jSONArray.get(i + 1);
                String string3 = "/RPCAdapter/jsonrpc/";
                string3 = string3 + string;
                httpServletRequest.setAttribute("path", (Object)"AccessCheck");
                string2 = this.getServletContext().getRequestDispatcher(string3);
                string2.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            JSONArray jSONArray2 = new JSONArray();
            int n = 0;
            string = (String)jSONArray.get(n + 1);
            string2 = "/RPCAdapter/jsonrpc/";
            string2 = string2 + string;
            RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher(string2);
            string2 = "/jsonrpc/" + string;
            httpServletRequest.setAttribute("path", (Object)string2);
            httpServletRequest.setAttribute("reqArr", (Object)jSONArray);
            httpServletRequest.setAttribute("id", (Object)Integer_.valueOf((int)0));
            httpServletRequest.setAttribute("retArr", (Object)jSONArray2);
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            this.processSmds(httpServletRequest.getRequestURI(), httpServletResponse, jSONArray);
        }
    }

    private void processJsonrpc(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl;
        JSONObject jSONObject;
        Object object;
        if (this.isTraceEnabled) {
            logger.trace((Object)"Starting processJsonrpc method of RPCAdapter");
        }
        String string = null;
        String string2 = (String)httpServletRequest.getAttribute("path");
        if (string2 == null) {
            string2 = httpServletRequest.getPathInfo();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (httpServletRequest.getAttribute("reqArr") == null) {
            object = JSONObject.parse((InputStream)httpServletRequest.getInputStream());
            if (this.isTraceEnabled) {
                logger.trace((Object)("Request is " + object.serialize()));
            }
            jSONObject = this.executeMethod((JSONObject)object, string3, httpServletRequest);
        } else {
            JSONArray jSONArray = (JSONArray)httpServletRequest.getAttribute("reqArr");
            if (this.isTraceEnabled) {
                logger.trace((Object)("Request is " + jSONArray.serialize()));
            }
            object = (Integer)httpServletRequest.getAttribute("id");
            JSONObject jSONObject2 = (JSONObject)jSONArray.get(((Integer)object).intValue());
            string3 = (String)jSONArray.get((Integer)object + 1);
            object = Integer_.valueOf((int)((Integer)object + 2));
            jSONObject = this.executeMethod(jSONObject2, string3, httpServletRequest);
            JSONArray jSONArray2 = (JSONArray)httpServletRequest.getAttribute("retArr");
            jSONArray2.add((Object)jSONObject);
            httpServletRequest.setAttribute("retArr", (Object)jSONArray2);
            if ((Integer)object < jSONArray.size()) {
                jSONObject2 = (JSONObject)jSONArray.get(((Integer)object).intValue());
                string3 = (String)jSONArray.get((Integer)object + 1);
                String string4 = "/RPCAdapter/jsonrpc/" + string3;
                RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher(string4);
                string4 = "/jsonrpc/" + string3;
                httpServletRequest.setAttribute("path", (Object)string4);
                httpServletRequest.setAttribute("id", object);
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                if ((Integer)object >= 0) {
                    return;
                }
            }
            string = jSONArray2.serialize();
        }
        if (string == null) {
            string = jSONObject.serialize();
        }
        if (bl = Boolean.valueOf(rpcContainer.getFiltered()).booleanValue()) {
            httpServletResponse.setContentType("text/json-comment-filtered");
            httpServletResponse.getWriter().print(COMMENT_START + string + COMMENT_END);
        } else {
            httpServletResponse.setContentType("application/json");
            httpServletResponse.getWriter().print(string);
        }
        logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.response_json"), string));
        if (this.isTraceEnabled) {
            logger.trace((Object)"Ending processJsonrpc method of RPCAdapter Time");
        }
    }

    private JSONObject executeMethod(JSONObject jSONObject, String string, HttpServletRequest httpServletRequest) throws Exception {
        Object object;
        List list;
        Class<?> clazz;
        int n;
        Class<?>[] classArray;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        if (this.isTraceEnabled) {
            logger.trace((Object)"Starting processJson method of RPCAdapter");
            logger.trace((Object)("JSON Object is " + jSONObject.serialize()));
        }
        String string2 = (String)jSONObject.get((Object)"method");
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"params");
        jSONArray = jSONArray == null ? new JSONArray() : jSONArray;
        long l = (Long)jSONObject.get((Object)"id");
        Object[] objectArray = null;
        boolean bl = false;
        JSONObject jSONObject2 = new JSONObject();
        Object v = rpcContainer.getServices().get(string);
        if (v instanceof Ejb) {
            Object object8;
            object7 = (Ejb)v;
            object6 = null;
            object5 = null;
            object4 = null;
            if (string2.equalsIgnoreCase("create")) {
                Object object9;
                object8 = null;
                object3 = ((Ejb)object7).getConfiguredMethods();
                object2 = object3.iterator();
                int n2 = 0;
                while (object2.hasNext()) {
                    object9 = (MethodInfo)object2.next();
                    if (!((MethodInfo)object9).getName().equalsIgnoreCase("create")) continue;
                    object8 = object9;
                }
                object9 = ((MethodInfo)object8).getParameters();
                objectArray = new Object[((ParameterInfo[])object9).length];
                int n3 = jSONArray.size();
                if (httpServletRequest.getParameter("format") != null) {
                    --n3;
                }
                if (n3 == ((Object)object9).length) {
                    int n4 = 0;
                    while (n4 + n2 < ((Object)object9).length) {
                        classArray = ((ParameterInfo)object9[n4 + n2]).getType().getClass();
                        Object object10 = jSONArray.get(n4);
                        Class<?> clazz2 = classArray.getComponentType();
                        objectArray[n4 + n2] = this.getInstance((Class)classArray, object10);
                        ++n4;
                    }
                    ((Ejb)object7).statefulLookUp(objectArray);
                    bl = true;
                }
                this.putinSession(httpServletRequest, string, (Ejb)object7);
            } else {
                if (object7 == null) {
                    logger.info((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string));
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string));
                }
                object8 = ((Ejb)object7).getBeanInfo();
                object3 = object8.getMethodDescriptors();
                logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.service_and_method_name"), string, string2));
                boolean bl2 = false;
                List list2 = ((Ejb)object7).getConfiguredMethods();
                object6 = this.getMethodInfo(string2, list2);
                for (int i = 0; i < ((MethodDescriptor[])object3).length && !bl2; ++i) {
                    int n5;
                    if (!object3[i].getName().equals(string2) || !((Ejb)object7).isAllowed(string2)) continue;
                    object4 = object3[i].getMethod();
                    ParameterInfo[] parameterInfoArray = null;
                    if (object6 != null) {
                        parameterInfoArray = ((MethodInfo)object6).getParameters();
                    }
                    if (parameterInfoArray == null) {
                        parameterInfoArray = new ParameterInfo[]{};
                    }
                    ParameterDescriptor[] parameterDescriptorArray = ((MethodDescriptor)object3[i]).getParameterDescriptors();
                    classArray = ((Method)object4).getParameterTypes();
                    objectArray = new Object[classArray.length];
                    if (parameterInfoArray.length != 0 && parameterDescriptorArray != null && parameterDescriptorArray.length != parameterInfoArray.length) {
                        throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.invalid_configuration"), string2));
                    }
                    int n6 = 0;
                    int n7 = n5 = parameterDescriptorArray != null ? parameterDescriptorArray.length : 0;
                    if (jSONArray.size() + 1 == classArray.length) {
                        Class<?> clazz3 = classArray[0];
                        Class<?> clazz4 = class$javax$servlet$http$HttpServletRequest;
                        if (clazz4 == null) {
                            clazz4 = new HttpServletRequest[0].getClass().getComponentType();
                        }
                        if (clazz3 == clazz4) {
                            objectArray[0] = httpServletRequest;
                            n6 = 1;
                        } else {
                            object5 = new Error(JSONRPCError, VALIDATION_ERROR_01, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr01"), string2), string2, string, null, null);
                        }
                    } else if (jSONArray.size() != classArray.length) {
                        object5 = new Error(JSONRPCError, VALIDATION_ERROR_01, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr01"), string2), string2, string, null, null);
                    }
                    if (object5 == null) {
                        n = 0;
                        while (n + n6 < classArray.length) {
                            clazz = classArray[n + n6];
                            list = null;
                            if (parameterInfoArray.length != 0) {
                                list = parameterInfoArray[n + n6].getValidators();
                            }
                            if (list == null || list.size() == 0) {
                                list = ((Ejb)object7).getValidators();
                            }
                            if (list != null && list.size() != 0) {
                                object5 = this.isValidationSuccess(jSONArray.get(n), clazz, n, string, string2, list, "json");
                            }
                            if (object5 == null) {
                                object = jSONArray.get(n);
                                objectArray[n + n6] = this.getInstance(clazz, object);
                            }
                            ++n;
                        }
                    }
                    bl2 = true;
                }
                if (!bl2) {
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.method_not_in_service"), string2, string));
                }
            }
            object8 = null;
            if (!bl) {
                if (object5 == null) {
                    try {
                        object8 = ((Method)object4).invoke(this.getServiceInstance(string, httpServletRequest), objectArray);
                        if (object6 != null && ((MethodInfo)object6).getSessionKey() != null) {
                            httpServletRequest.getSession(true).setAttribute(((MethodInfo)object6).getSessionKey(), object8);
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)Messages.getMessage("rpcadapter.msg.app_error"), (Throwable)exception);
                        exception.printStackTrace();
                        object5 = new Error(JSONRPCError, "CWRPC0012E", Messages.getMessage("rpcadapter.msg.app_error"), string2, string, null, null);
                        this.processException(exception, (Error)object5);
                    }
                }
                if (object5 == null) {
                    jSONObject2.put((Object)"result", ObjectToJson.toJson(object8, rpcContainer.getParameters(), rpcContainer.isRecursionSupport()));
                    jSONObject2.put((Object)"error", null);
                    jSONObject2.put((Object)"id", (Object)new Long(l));
                } else {
                    jSONObject2.put((Object)"result", null);
                    jSONObject2.put((Object)"error", ObjectToJson.toJson(object5, null, false));
                    jSONObject2.put((Object)"id", (Object)new Long(l));
                }
                object3 = jSONObject2.serialize();
                logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.response_json"), object3));
                if (this.isTraceEnabled) {
                    logger.trace((Object)"Ending processJson method of RPCAdapter Time");
                }
            }
        }
        if (v instanceof Pojo) {
            object7 = (Pojo)v;
            object6 = null;
            if (object7 == null) {
                logger.info((Object)MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string));
                throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.service_not_found"), string));
            }
            object5 = ((Pojo)object7).getBeanInfo();
            object4 = object5.getMethodDescriptors();
            logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.service_and_method_name"), string, string2));
            boolean bl3 = false;
            object3 = null;
            object2 = null;
            List list3 = ((Pojo)object7).getConfiguredMethods();
            object3 = this.getMethodInfo(string2, list3);
            for (int i = 0; i < ((MethodDescriptor[])object4).length && !bl3; ++i) {
                int n8;
                if (!object4[i].getDisplayName().equals(string2) || !((Pojo)object7).isAllowed(object4[i])) continue;
                object6 = object4[i].getMethod();
                ParameterInfo[] parameterInfoArray = null;
                if (object3 != null) {
                    parameterInfoArray = ((MethodInfo)object3).getParameters();
                }
                if (parameterInfoArray == null) {
                    parameterInfoArray = new ParameterInfo[]{};
                }
                ParameterDescriptor[] parameterDescriptorArray = object4[i].getParameterDescriptors();
                classArray = ((Method)object6).getParameterTypes();
                objectArray = new Object[classArray.length];
                if (parameterInfoArray.length != 0 && parameterDescriptorArray != null && parameterDescriptorArray.length != parameterInfoArray.length) {
                    throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.invalid_configuration"), string2));
                }
                int n9 = 0;
                int n10 = n8 = parameterDescriptorArray != null ? parameterDescriptorArray.length : 0;
                if (jSONArray.size() + 1 == classArray.length) {
                    Class<?> clazz5 = classArray[0];
                    Class<?> clazz6 = class$javax$servlet$http$HttpServletRequest;
                    if (clazz6 == null) {
                        clazz6 = new HttpServletRequest[0].getClass().getComponentType();
                    }
                    if (clazz5 == clazz6) {
                        objectArray[0] = httpServletRequest;
                        n9 = 1;
                    } else {
                        object2 = new Error(JSONRPCError, VALIDATION_ERROR_01, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr01"), string2), string2, string, null, null);
                    }
                } else if (jSONArray.size() != classArray.length) {
                    object2 = new Error(JSONRPCError, VALIDATION_ERROR_01, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr01"), string2), string2, string, null, null);
                }
                if (object2 == null) {
                    n = 0;
                    while (n + n9 < classArray.length) {
                        clazz = classArray[n + n9];
                        list = null;
                        if (parameterInfoArray.length != 0) {
                            list = parameterInfoArray[n + n9].getValidators();
                        }
                        if (list == null || list.size() == 0) {
                            list = ((Pojo)object7).getValidators();
                        }
                        if (list != null && list.size() != 0) {
                            object2 = this.isValidationSuccess(jSONArray.get(n), clazz, n, string, string2, list, "json");
                        }
                        if (object2 == null) {
                            object = jSONArray.get(n);
                            objectArray[n + n9] = this.getInstance(clazz, object);
                        }
                        ++n;
                    }
                }
                bl3 = true;
            }
            if (!bl3) {
                throw new ServletException(MessageFormat.format(Messages.getMessage("rpcadapter.msg.method_not_in_service"), string2, string));
            }
            Object object11 = null;
            if (object2 == null) {
                try {
                    object11 = ((Method)object6).invoke(this.getServiceInstance(string, httpServletRequest), objectArray);
                    if (object3 != null && ((MethodInfo)object3).getSessionKey() != null) {
                        httpServletRequest.getSession(true).setAttribute(((MethodInfo)object3).getSessionKey(), object11);
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)Messages.getMessage("rpcadapter.msg.app_error"), (Throwable)exception);
                    exception.printStackTrace();
                    object2 = new Error(JSONRPCError, "CWRPC0012E", Messages.getMessage("rpcadapter.msg.app_error"), string2, string, null, null);
                    this.processException(exception, (Error)object2);
                }
            }
            if (object2 == null) {
                jSONObject2.put((Object)"result", ObjectToJson.toJson(object11, rpcContainer.getParameters(), rpcContainer.isRecursionSupport()));
                jSONObject2.put((Object)"error", null);
                jSONObject2.put((Object)"id", (Object)new Long(l));
            } else {
                jSONObject2.put((Object)"result", null);
                jSONObject2.put((Object)"error", ObjectToJson.toJson(object2, null, false));
                jSONObject2.put((Object)"id", (Object)new Long(l));
            }
            String string3 = jSONObject2.serialize();
            logger.trace((Object)MessageFormat.format(Messages.getText("rpcadapter.msg.response_json"), string3));
            if (this.isTraceEnabled) {
                logger.trace((Object)"Ending processJson method of RPCAdapter Time");
            }
        }
        return jSONObject2;
    }

    Object getInstance(Class clazz, String string) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isTraceEnabled) {
            logger.trace((Object)"In getInstance(Class,String) method of RPCAdapter");
        }
        if (!clazz.isPrimitive()) {
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            classArray[0] = clazz2;
            Constructor constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(string);
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(string);
        }
        if (clazz == Byte.TYPE) {
            return new Byte(string);
        }
        if (clazz == Character.TYPE) {
            return new String(string);
        }
        if (clazz == Double.TYPE) {
            return new Double(string);
        }
        if (clazz == Float.TYPE) {
            return new Float(string);
        }
        if (clazz == Integer.TYPE) {
            return new Integer(string);
        }
        if (clazz == Long.TYPE) {
            return new Long(string);
        }
        if (clazz == Short.TYPE) {
            return new Short(string);
        }
        throw new IllegalArgumentException("Unhandled parm type = " + clazz);
    }

    Object getInstance(Class clazz, Object object) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isTraceEnabled) {
            logger.trace((Object)"In getInstance(Class,Object) method of RPCAdapter");
        }
        return JsonToObject.toObject(object, clazz, rpcContainer.isRecursionSupport());
    }

    Object getServiceInstance(String string, HttpServletRequest httpServletRequest) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.isTraceEnabled) {
            logger.trace((Object)"Start getServiceInstance method of RPCAdapter");
        }
        Object v = rpcContainer.getServices().get(string);
        if (v instanceof Ejb) {
            Ejb ejb = (Ejb)v;
            Object object = null;
            BeanInfo beanInfo = ejb.getBeanInfo();
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            if (object == null) {
                object = ejb.getSessionkey() ? this.getSession(httpServletRequest, string, ejb) : ejb.getBaseClass();
            }
            if (this.isTraceEnabled) {
                logger.trace((Object)"End getServiceInstance method of RPCAdapter");
            }
            return object;
        }
        if (v instanceof Pojo) {
            String string2;
            Pojo pojo = (Pojo)v;
            Object object = null;
            BeanInfo beanInfo = pojo.getBeanInfo();
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            if (beanDescriptor != null && (string2 = (String)beanInfo.getBeanDescriptor().getValue("oneInstancePerUser")) != null && Boolean.valueOf(string2).booleanValue()) {
                object = this.putinSession(httpServletRequest, string, pojo);
            }
            if ("Session".equalsIgnoreCase(pojo.getScope())) {
                object = this.putinSession(httpServletRequest, string, pojo);
            } else if ("Request".equalsIgnoreCase(pojo.getScope())) {
                object = httpServletRequest.getAttribute(SESSION_APP_PREFIX + string);
                if (object == null) {
                    object = pojo.getBaseClass().newInstance();
                    httpServletRequest.setAttribute(SESSION_APP_PREFIX + string, object);
                }
            } else if ("Application".equalsIgnoreCase(pojo.getScope()) && (object = this.getServletContext().getAttribute(SESSION_APP_PREFIX + string)) == null) {
                object = pojo.getBaseClass().newInstance();
                this.getServletContext().setAttribute(SESSION_APP_PREFIX + string, object);
            }
            if (object == null) {
                object = pojo.getBaseClass().newInstance();
            }
            if (this.isTraceEnabled) {
                logger.trace((Object)"End getServiceInstance method of RPCAdapter");
            }
            return object;
        }
        return null;
    }

    private Error isValidationSuccess(Object object, Class clazz, int n, String string, String string2, List list, String string3) {
        if (this.isTraceEnabled) {
            logger.trace((Object)"In isValidationSuccess method of RPCAdapter");
        }
        if (list != null) {
            if (clazz.isArray() || object instanceof JSONArray) {
                Error error = null;
                Object[] objectArray = null;
                objectArray = object instanceof JSONArray ? ((JSONArray)object).toArray() : (Object[])object;
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    error = this.isValidationSuccess(objectArray[i], clazz, n, string, string2, list, string3);
                    if (error == null) continue;
                    return error;
                }
            } else if (object instanceof JSONObject) {
                JSONObject jSONObject = null;
                Error error = null;
                jSONObject = (JSONObject)object;
                Set set = jSONObject.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    error = this.validate(entry.getValue(), string, string2, n, list, string3);
                    if (error == null) continue;
                    return error;
                }
            } else {
                return this.validate(object, string, string2, n, list, string3);
            }
        }
        return null;
    }

    private Error validate(Object object, String string, String string2, int n, List list, String string3) {
        for (int i = 0; i < list.size(); ++i) {
            String string4 = (String)list.get(i);
            Validator validator = (Validator)rpcContainer.getValidators().get(string4);
            Pattern pattern = null;
            Matcher matcher = null;
            if (validator.getRegex() != null) {
                pattern = Pattern.compile(validator.getRegex());
                matcher = pattern.matcher(String.valueOf(object));
            }
            if (!(object instanceof String ? (matcher == null ? !validator.validate((String)object, string, string2) : !validator.validate((String)object, string, string2) || !matcher.matches()) : (matcher == null ? !validator.validate(object, string, string2) : !validator.validate(object, string, string2) || !matcher.matches()))) continue;
            return new Error(this.getErrorName(string3), VALIDATION_ERROR_02, MessageFormat.format(Messages.getMessage("rpcadapter.err.valerr02"), String.valueOf(n), string2), string2, string, String.valueOf(n), object);
        }
        return null;
    }

    public MethodInfo getMethodInfo(String string, List list) {
        if (list != null) {
            int n = list.size();
            MethodInfo methodInfo = null;
            for (int i = 0; i < n; ++i) {
                methodInfo = (MethodInfo)list.get(i);
                if (!methodInfo.getName().equals(string)) continue;
                return methodInfo;
            }
        }
        return null;
    }

    private Object putinSession(HttpServletRequest httpServletRequest, String string, Pojo pojo) throws InstantiationException, IllegalAccessException {
        Object object = httpServletRequest.getSession(true).getAttribute(SESSION_APP_PREFIX + string);
        if (object == null) {
            object = pojo.getBaseClass().newInstance();
            httpServletRequest.getSession().setAttribute(SESSION_APP_PREFIX + string, object);
        }
        return object;
    }

    private Object getSession(HttpServletRequest httpServletRequest, String string, Ejb ejb) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Object object = httpServletRequest.getSession(true).getAttribute(SESSION_APP_PREFIX + string);
        if (object == null) {
            object = ejb.getBaseClass();
            httpServletRequest.getSession().setAttribute(SESSION_APP_PREFIX + string, object);
        }
        return object;
    }

    protected void putinSession(HttpServletRequest httpServletRequest, String string, Ejb ejb) throws ClassNotFoundException {
        Object object = ejb.getBaseClass();
        httpServletRequest.getSession().setAttribute(SESSION_APP_PREFIX + string, object);
    }

    private String getErrorName(String string) {
        String string2 = null;
        string2 = string.equals("json") ? JSONRPCError : XMLRPCError;
        return string2;
    }

    private String processException(Exception exception, Error error) {
        StringWriter stringWriter = new StringWriter();
        if (exception.getCause() != null) {
            exception.getCause().printStackTrace(new PrintWriter(stringWriter));
        } else {
            exception.printStackTrace(new PrintWriter(stringWriter));
        }
        error.setStackTrace(stringWriter.toString());
        String string = null;
        try {
            JSONObject jSONObject = (JSONObject)ObjectToJson.toJson(error, new HashMap(), false);
            string = jSONObject.serialize();
        }
        catch (Exception exception2) {
            logger.error((Object)"Exception in serializing Error object", (Throwable)exception2);
        }
        return string;
    }

    private Document getDocumentRoot(String string) throws IOException, ParserConfigurationException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("RpcAdapterConfig.xsd");
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", inputStream);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new XmlConfigErrorHandler());
            document = documentBuilder.parse(string);
        }
        catch (SAXException sAXException) {
            try {
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", inputStream);
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(new XmlConfigErrorHandler());
                document = documentBuilder.parse(string);
                NodeList nodeList = document.getElementsByTagName("rpcAdapter");
                Element element = (Element)nodeList.item(0);
                element.setAttribute("xmlns", "http://www.ibm.com/xmlns/prod/websphere/featurepack/v6.1/RpcAdapterConfig/1.1");
                DOMSource dOMSource = new DOMSource(document);
                InputStream inputStream2 = Thread.currentThread().getContextClassLoader().getResourceAsStream("RpcAdapterConfig.xsd");
                documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", inputStream2);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.transform(dOMSource, streamResult);
                documentBuilderFactory.setValidating(true);
                DocumentBuilder documentBuilder2 = null;
                documentBuilder2 = documentBuilderFactory.newDocumentBuilder();
                documentBuilder2.setErrorHandler(new XmlConfigErrorHandler());
                documentBuilder2.parse(new InputSource(new StringReader(stringWriter.getBuffer().toString())));
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                logger.error((Object)Messages.getMessage("rpcadapter.msg.config_file"));
            }
            catch (TransformerException transformerException) {
                logger.error((Object)Messages.getMessage("rpcadapter.msg.config_file"));
            }
            catch (SAXException sAXException2) {
                // empty catch block
            }
        }
        return document;
    }

    private Document getNonValidatedDocumentRoot(String string) throws SAXException, IOException, ParserConfigurationException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("RpcAdapterConfig.xsd");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", inputStream);
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new XmlConfigErrorHandler());
        Document document = documentBuilder.parse(string);
        return document;
    }

    private Document getInMemoryDD(ServletConfig servletConfig) throws ServletException {
        String string = servletConfig.getServletContext().getRealPath("/WEB-INF/RpcAdapterConfig.xml");
        Document document = null;
        try {
            try {
                document = this.getNonValidatedDocumentRoot(string);
            }
            catch (SAXException sAXException) {
                logger.error((Object)Messages.getMessage("rpcadapter.msg.config_file"), (Throwable)sAXException);
                throw new ConfigurationException(Messages.getMessage("rpcadapter.msg.config_file"), sAXException);
            }
            catch (IOException iOException) {
                logger.error((Object)Messages.getMessage("rpcadapter.msg.config_file"), (Throwable)iOException);
                throw new ConfigurationException(Messages.getMessage("rpcadapter.msg.config_file"), iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                logger.error((Object)Messages.getMessage("rpcadapter.msg.config_file"), (Throwable)parserConfigurationException);
                throw new ConfigurationException(Messages.getMessage("rpcadapter.msg.config_file"), parserConfigurationException);
            }
        }
        catch (ConfigurationException configurationException) {
            logger.error((Object)"Error in fetching in-memory descriptor", (Throwable)configurationException);
            throw new ServletException((Throwable)configurationException);
        }
        servletConfig.getServletContext().setAttribute("inMemoryDD", (Object)document);
        return document;
    }

    static {
        Class<?> clazz = class$com$ibm$websphere$rpcadapter$RPCAdapter;
        if (clazz == null) {
            clazz = class$com$ibm$websphere$rpcadapter$RPCAdapter = new RPCAdapter[0].getClass().getComponentType();
        }
        CLASS_NAME = clazz.getName();
        logger = LogFactory.getLog((String)CLASS_NAME);
        rpcContainer = null;
        SESSION_APP_PREFIX = "com.ibm.websphere.rpcadapter:";
    }
}

