/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.webmsg.servlet;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Version {
    private static String DEFAULT = "UNKNOWN";
    private String buildDate = DEFAULT;
    private String specTitle = DEFAULT;
    private String specVersion = DEFAULT;
    private String specVendor = DEFAULT;
    private String implTitle = DEFAULT;
    private String implVersion = DEFAULT;
    private String implVendor = DEFAULT;
    private String file = DEFAULT;

    public static void main(String[] stringArray) {
        try {
            Version version = new Version();
            System.out.println("");
            System.out.println("MANIFEST information for jar: [" + version.getFile() + "]");
            System.out.println("");
            System.out.println("Specification:");
            System.out.println("\tTitle: [" + version.getSpecificationTitle() + "]");
            System.out.println("\tVersion: [" + version.getSpecificationVersion() + "]");
            System.out.println("\tVendor: [" + version.getSpecificationVendor() + "]");
            System.out.println("");
            System.out.println("Implementation:");
            System.out.println("\tTitle: [" + version.getImplementationTitle() + "]");
            System.out.println("\tVersion: [" + version.getImplementationVersion() + "]");
            System.out.println("\tVendor: [" + version.getImplementationVendor() + "]");
            System.out.println("");
            System.out.println("Build date: [" + version.getBuildDate() + "]");
        }
        catch (Exception exception) {
            System.out.println("Fatal error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public Version() {
        try {
            Class<?> clazz = this.getClass();
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL uRL = codeSource.getLocation();
            String string = uRL.getFile();
            if (string != null) {
                File file = new File(string);
                this.file = file.getAbsolutePath();
                JarFile jarFile = new JarFile(string);
                Manifest manifest = jarFile.getManifest();
                jarFile.close();
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes.getValue("Build-Date") != null) {
                        this.buildDate = attributes.getValue("Build-Date");
                    }
                    if (attributes.getValue(Attributes.Name.SPECIFICATION_TITLE) != null) {
                        this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    }
                    if (attributes.getValue(Attributes.Name.SPECIFICATION_VERSION) != null) {
                        this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    }
                    if (attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR) != null) {
                        this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    }
                    if (attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE) != null) {
                        this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    }
                    if (attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION) != null) {
                        this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    }
                    if (attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR) != null) {
                        this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Fatal error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public String getFile() {
        return this.file;
    }
}

