/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.webmsg.publisher.jndijms;

import com.ibm.websphere.webmsg.publisher.Publisher;
import com.ibm.websphere.webmsg.publisher.PublisherContext;
import com.ibm.websphere.webmsg.publisher.PublisherException;
import com.ibm.websphere.webmsg.publisher.WebMessage;
import com.ibm.websphere.webmsg.publisher.jndijms.JmsWebMsg;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;

public class JmsPublisher
implements Publisher {
    public static final String PROPERTY_KEY_CONNECTION_FACTORY_JNDI_NAME = "CONNECTION_FACTORY_JNDI_NAME";
    public static final String PROPERTY_KEY_INITIAL_CONTEXT_FACTORY = "INITIAL_CONTEXT_FACTORY";
    public static final String PROPERTY_KEY_PROVIDER_URL = "PROVIDER_URL";
    public static final String PROPERTY_KEY_JMS_CLIENT_ID = "JMS_CLIENT_ID";
    public static final String PROPERTY_KEY_DEFAULT_DESTINATION = "DEFAULT_TOPIC_SPACE";
    public static final String EVENT_HEADER_ATTRIBUTE_NAME_JMS_DELIVERY_MODE = "JMS_DELIVERY_MODE";
    public static final String EVENT_HEADER_ATTRIBUTE_NAME_JMS_PRIORITY = "JMS_PRIORITY";
    public static final String EVENT_HEADER_ATTRIBUTE_NAME_JMS_TIME_TO_LIVE = "JMS_TIME_TO_LIVE";
    public static final String PROPERTY_MAX_CONNECT_TIME = "MAX_CONNECT_TIME";
    public static final String PROPERTY_CONN_DELAYINTERVAL = "CONNECT_DELAY_INTERVAL";
    public static final String PROPERTY_CONN_DELAY_MULTIPLIER = "CONNECT_DELAY_MULTIPLIER";
    private static int PUBLISH_STATE_COMPLETE = 0;
    private static int PUBLISH_STATE_PUBLISH = 1;
    private static int PUBLISH_STATE_RETRY = 2;
    private static int PUBLISH_STATE_ERROR = 3;
    private int _defJmsDeliveryMode = 1;
    private int _defJmsPriority = 4;
    private long _defJmsTimeToLive = 0L;
    private long _defMaxConnectTime = 0L;
    private long _defConnectInterval = 1000L;
    private int _defDelayMultiplier = 2;
    private String _defaultTopicSpace = "Default.Topic.Space";
    private TopicConnectionFactory _connectionFactory = null;
    private PublisherContext _publisherContext = null;

    public void initialize(PublisherContext publisherContext) throws PublisherException {
        String string;
        Integer n;
        Long l;
        Long l2;
        String string2;
        Long l3;
        Integer n2;
        this._publisherContext = publisherContext;
        String string3 = (String)publisherContext.getAttribute(PROPERTY_KEY_CONNECTION_FACTORY_JNDI_NAME);
        if (string3 == null) {
            throw new PublisherException("Missing context property: CONNECTION_FACTORY_JNDI_NAME");
        }
        Integer n3 = (Integer)publisherContext.getAttribute(EVENT_HEADER_ATTRIBUTE_NAME_JMS_DELIVERY_MODE);
        if (n3 != null) {
            this._defJmsDeliveryMode = n3;
        }
        if ((n2 = (Integer)publisherContext.getAttribute(EVENT_HEADER_ATTRIBUTE_NAME_JMS_PRIORITY)) != null) {
            this._defJmsPriority = n2;
        }
        if ((l3 = (Long)publisherContext.getAttribute(EVENT_HEADER_ATTRIBUTE_NAME_JMS_TIME_TO_LIVE)) != null) {
            this._defJmsTimeToLive = n2.longValue();
        }
        if ((string2 = (String)publisherContext.getAttribute(PROPERTY_KEY_DEFAULT_DESTINATION)) != null) {
            this._defaultTopicSpace = string2;
        }
        if ((l2 = (Long)publisherContext.getAttribute(PROPERTY_MAX_CONNECT_TIME)) != null) {
            this._defMaxConnectTime = l2;
        }
        if ((l = (Long)publisherContext.getAttribute(PROPERTY_CONN_DELAYINTERVAL)) != null) {
            this._defConnectInterval = l;
        }
        if ((n = (Integer)publisherContext.getAttribute(PROPERTY_CONN_DELAY_MULTIPLIER)) != null) {
            this._defDelayMultiplier = n;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string4 = (String)this._publisherContext.getAttribute(PROPERTY_KEY_INITIAL_CONTEXT_FACTORY);
        if (string4 != null) {
            hashtable.put("java.naming.factory.initial", string4);
        }
        if ((string = (String)this._publisherContext.getAttribute(PROPERTY_KEY_PROVIDER_URL)) != null) {
            hashtable.put("java.naming.provider.url", string);
        }
        try {
            InitialContext initialContext = new InitialContext(hashtable);
            this._connectionFactory = (TopicConnectionFactory)initialContext.lookup(string3);
        }
        catch (Exception exception) {
            throw new PublisherException("Error initializing: " + exception.getMessage(), exception);
        }
    }

    public synchronized void close() throws PublisherException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(WebMessage webMessage) throws PublisherException {
        long l;
        int n;
        if (!(webMessage instanceof JmsWebMsg)) {
            throw new UnsupportedOperationException("Must publish a message of JmsWebMsg type through this publisher");
        }
        JmsWebMsg jmsWebMsg = (JmsWebMsg)webMessage;
        String string = jmsWebMsg.getDestination();
        if ("".equals(string)) {
            string = this._defaultTopicSpace;
        }
        if ((n = jmsWebMsg.getJmsDeliveryMode()) < 0) {
            n = this._defJmsDeliveryMode;
        }
        String string2 = "NonPersistent";
        if (n == 2) {
            string2 = "Persistent";
        }
        String string3 = "topic://" + jmsWebMsg.getTarget() + "?topicSpace=" + string + "&deliveryMode=" + string2;
        int n2 = jmsWebMsg.getJmsPriority();
        if (n2 < 0) {
            n2 = this._defJmsPriority;
        }
        if ((l = jmsWebMsg.getJmsTimeToLive()) < 0L) {
            l = this._defJmsTimeToLive;
        }
        TopicConnection topicConnection = null;
        TopicSession topicSession = null;
        TopicPublisher topicPublisher = null;
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        long l4 = this._defConnectInterval;
        int n3 = PUBLISH_STATE_PUBLISH;
        JMSException jMSException = null;
        while (n3 != PUBLISH_STATE_COMPLETE) {
            if (n3 == PUBLISH_STATE_PUBLISH) {
                try {
                    topicConnection = this._connectionFactory.createTopicConnection();
                    String string4 = (String)this._publisherContext.getAttribute(PROPERTY_KEY_JMS_CLIENT_ID);
                    if (string4 != null) {
                        topicConnection.setClientID(string4);
                    }
                    topicSession = topicConnection.createTopicSession(false, 1);
                    topicPublisher = topicSession.createPublisher(topicSession.createTopic(string3));
                    Message message = jmsWebMsg.getJmsMessage((Session)topicSession);
                    message.setJMSDeliveryMode(n);
                    message.setJMSPriority(n2);
                    message.setJMSExpiration(l);
                    topicPublisher.publish(message);
                    n3 = PUBLISH_STATE_COMPLETE;
                    continue;
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    n3 = PUBLISH_STATE_RETRY;
                    continue;
                }
                finally {
                    try {
                        if (topicPublisher != null) {
                            topicPublisher.close();
                        }
                        if (topicSession != null) {
                            topicSession.close();
                        }
                        if (topicConnection == null) continue;
                        topicConnection.close();
                    }
                    catch (JMSException jMSException3) {}
                    continue;
                }
            }
            if (n3 == PUBLISH_STATE_RETRY) {
                if (this._defMaxConnectTime != 0L) {
                    long l5 = System.currentTimeMillis();
                    l3 = l5 - l2;
                    if (l3 > this._defMaxConnectTime) {
                        n3 = PUBLISH_STATE_ERROR;
                        continue;
                    }
                    try {
                        Thread.sleep(l4);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l4 *= (long)this._defDelayMultiplier;
                    n3 = PUBLISH_STATE_PUBLISH;
                    continue;
                }
                n3 = PUBLISH_STATE_ERROR;
                continue;
            }
            if (n3 != PUBLISH_STATE_ERROR) continue;
            throw new PublisherException("Error publishing message: ", jMSException);
        }
    }
}

