/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.util.filter;

import javax.xml.namespace.QName;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import org.apache.abdera.filter.ParseFilter;
import org.apache.abdera.util.filter.AbstractParseFilter;

public class CompoundParseFilter
extends AbstractParseFilter
implements ParseFilter {
    private static final long serialVersionUID = -7871289035422204698L;
    protected final Condition condition;
    protected final ParseFilter[] filters;

    public CompoundParseFilter(Condition condition, ParseFilter ... filters) {
        this.filters = filters;
        this.condition = condition;
    }

    public CompoundParseFilter(ParseFilter ... filters) {
        this(Condition.ACCEPTABLE_TO_ANY, filters);
    }

    private ParseFilter[] getFilters() {
        return this.filters;
    }

    public boolean acceptable(QName qname) {
        ParseFilter[] arr$ = this.getFilters();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ParseFilter filter = arr$[i$];
            switch (this.condition.evaluate(filter.acceptable(qname))) {
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean acceptable(QName qname, QName attribute) {
        ParseFilter[] arr$ = this.getFilters();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ParseFilter filter = arr$[i$];
            switch (this.condition.evaluate(filter.acceptable(qname, attribute))) {
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Condition
    extends Enum<Condition> {
        public static final /* enum */ Condition ACCEPTABLE_TO_ALL = new Condition("ACCEPTABLE_TO_ALL", 0);
        public static final /* enum */ Condition ACCEPTABLE_TO_ANY = new Condition("ACCEPTABLE_TO_ANY", 1);
        public static final /* enum */ Condition UNACCEPTABLE_TO_ALL = new Condition("UNACCEPTABLE_TO_ALL", 2);
        public static final /* enum */ Condition UNACCEPTABLE_TO_ANY = new Condition("UNACCEPTABLE_TO_ANY", 3);
        private static final /* synthetic */ Condition[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$util$filter$CompoundParseFilter$Condition;

        public static final Condition[] values() {
            return (Condition[])$VALUES.clone();
        }

        public static Condition valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$util$filter$CompoundParseFilter$Condition;
            if (clazz == null) {
                clazz = class$org$apache$abdera$util$filter$CompoundParseFilter$Condition = new Condition[0].getClass().getComponentType();
            }
            return (Condition)Enum.valueOf((Class)clazz, (String)name);
        }

        private Condition(String string, int n) {
            super(string, n);
        }

        byte evaluate(boolean b) {
            if (b) {
                switch (this) {
                    case ACCEPTABLE_TO_ANY: {
                        return 1;
                    }
                    case UNACCEPTABLE_TO_ALL: {
                        return -1;
                    }
                }
            } else {
                switch (this) {
                    case ACCEPTABLE_TO_ALL: {
                        return -1;
                    }
                    case UNACCEPTABLE_TO_ANY: {
                        return 1;
                    }
                }
            }
            return 0;
        }

        static {
            $VALUES = new Condition[]{ACCEPTABLE_TO_ALL, ACCEPTABLE_TO_ANY, UNACCEPTABLE_TO_ALL, UNACCEPTABLE_TO_ANY};
            Condition[] conditionArray = Condition.values();
            Class<?> clazz = class$org$apache$abdera$util$filter$CompoundParseFilter$Condition;
            if (clazz == null) {
                clazz = class$org$apache$abdera$util$filter$CompoundParseFilter$Condition = new Condition[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])conditionArray, (Class)clazz);
        }
    }
}

