/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.util;

import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import org.apache.abdera.i18n.text.CharUtils;
import org.apache.abdera.i18n.text.Filter;

public class XmlUtil {
    private static int[] RESTRICTED_SET_v1 = new int[]{0, 9, 11, 13, 14, 32, 55296, 57344, 65534, 65536};
    private static int[] RESTRICTED_SET_v11 = new int[]{11, 13, 14, 32, 127, 160, 55296, 57344, 65534, 65536};

    public static boolean restricted(XMLVersion version, char c) {
        return XmlUtil.restricted(version, (int)c);
    }

    public static boolean restricted(XMLVersion version, int c) {
        return CharUtils.invset_contains((int[])(version == XMLVersion.XML10 ? RESTRICTED_SET_v1 : RESTRICTED_SET_v11), (int)c);
    }

    public static XMLVersion getVersion(String version) {
        return version == null ? XMLVersion.XML10 : (version.equals("1.0") ? XMLVersion.XML10 : (version.equals("1.1") ? XMLVersion.XML11 : XMLVersion.XML10));
    }

    private static class XmlFilter
    implements Filter {
        private final XMLVersion version;

        XmlFilter(XMLVersion version) {
            this.version = version;
        }

        public boolean accept(int c) {
            return !XmlUtil.restricted(this.version, c);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class XMLVersion
    extends Enum<XMLVersion> {
        public static final /* enum */ XMLVersion XML10 = new XMLVersion("XML10", 0);
        public static final /* enum */ XMLVersion XML11 = new XMLVersion("XML11", 1);
        private final Filter filter = new XmlFilter(this);
        private static final /* synthetic */ XMLVersion[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$util$XmlUtil$XMLVersion;

        public static final XMLVersion[] values() {
            return (XMLVersion[])$VALUES.clone();
        }

        public static XMLVersion valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$util$XmlUtil$XMLVersion;
            if (clazz == null) {
                clazz = class$org$apache$abdera$util$XmlUtil$XMLVersion = new XMLVersion[0].getClass().getComponentType();
            }
            return (XMLVersion)Enum.valueOf((Class)clazz, (String)name);
        }

        private XMLVersion(String string, int n) {
            super(string, n);
        }

        public Filter filter() {
            return this.filter;
        }

        static {
            $VALUES = new XMLVersion[]{XML10, XML11};
            XMLVersion[] xMLVersionArray = XMLVersion.values();
            Class<?> clazz = class$org$apache$abdera$util$XmlUtil$XMLVersion;
            if (clazz == null) {
                clazz = class$org$apache$abdera$util$XmlUtil$XMLVersion = new XMLVersion[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])xMLVersionArray, (Class)clazz);
        }
    }
}

