/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.util;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import org.apache.abdera.i18n.text.Normalizer;
import org.apache.abdera.i18n.text.Sanitizer;
import org.apache.abdera.protocol.util.CacheControlUtil;
import org.apache.abdera.util.CompressionUtil;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.codec.net.QCodec;

public class EncodingUtil {
    public static final String SANITIZE_PATTERN = "[^A-Za-z0-9\\%!$&\\\\'()*+,;=]+";

    public static String sanitize(String slug) {
        return Sanitizer.sanitize((String)slug, null, (boolean)false, null, (String)SANITIZE_PATTERN);
    }

    public static String sanitize(String slug, String filler) {
        return Sanitizer.sanitize((String)slug, (String)filler, (boolean)false, null, (String)SANITIZE_PATTERN);
    }

    public static String sanitize(String slug, String filler, boolean lower) {
        return Sanitizer.sanitize((String)slug, (String)filler, (boolean)lower, null, (String)SANITIZE_PATTERN);
    }

    public static String sanitize(String slug, String filler, String pattern) {
        return Sanitizer.sanitize((String)slug, (String)filler, (boolean)false, null, (String)pattern);
    }

    public static String sanitize(String slug, String filler, boolean lower, String pattern) {
        return Sanitizer.sanitize((String)slug, (String)filler, (boolean)lower, null, (String)pattern);
    }

    public static String sanitize(String slug, String filler, boolean lower, Normalizer.Form form) {
        return Sanitizer.sanitize((String)slug, (String)filler, (boolean)lower, (Normalizer.Form)form, (String)SANITIZE_PATTERN);
    }

    public static String sanitize(String slug, String filler, boolean lower, Normalizer.Form form, String pattern) {
        return Sanitizer.sanitize((String)slug, (String)filler, (boolean)lower, (Normalizer.Form)form, (String)pattern);
    }

    public static String encode(String value) {
        return EncodingUtil.encode(value, "UTF-8", Codec.B);
    }

    public static String encode(String value, String charset) {
        return EncodingUtil.encode(value, charset, Codec.B);
    }

    public static String encode(String value, String charset, Codec codec) {
        if (value == null) {
            return null;
        }
        try {
            switch (1.$SwitchMap$org$apache$abdera$protocol$util$EncodingUtil$Codec[codec.ordinal()]) {
                case 1: {
                    return new QCodec(charset).encode(value);
                }
            }
            return new BCodec(charset).encode(value);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String decode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new BCodec().decode(value);
        }
        catch (DecoderException de) {
            try {
                return new QCodec().decode(value);
            }
            catch (Exception ex) {
                return value;
            }
        }
        catch (Exception e) {
            return value;
        }
    }

    public static InputStream getDecodingInputStream(InputStream in, String ce) throws IOException {
        String[] encodings = CacheControlUtil.CacheControlParser.splitAndTrim(ce, ",", false);
        for (int n = encodings.length - 1; n >= 0; --n) {
            CompressionUtil.CompressionCodec encoding = CompressionUtil.CompressionCodec.valueOf(encodings[n].toUpperCase().replaceAll("-", ""));
            in = CompressionUtil.getDecodingInputStream(in, encoding);
        }
        return in;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$abdera$protocol$util$EncodingUtil$Codec;

        static {
            $SwitchMap$org$apache$abdera$protocol$util$EncodingUtil$Codec = new int[Codec.values().length];
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$EncodingUtil$Codec[Codec.Q.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$EncodingUtil$Codec[Codec.B.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Codec
    extends Enum<Codec> {
        public static final /* enum */ Codec B = new Codec("B", 0);
        public static final /* enum */ Codec Q = new Codec("Q", 1);
        private static final /* synthetic */ Codec[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$protocol$util$EncodingUtil$Codec;

        public static final Codec[] values() {
            return (Codec[])$VALUES.clone();
        }

        public static Codec valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$protocol$util$EncodingUtil$Codec;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$util$EncodingUtil$Codec = new Codec[0].getClass().getComponentType();
            }
            return (Codec)Enum.valueOf((Class)clazz, (String)name);
        }

        private Codec(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new Codec[]{B, Q};
            Codec[] codecArray = Codec.values();
            Class<?> clazz = class$org$apache$abdera$protocol$util$EncodingUtil$Codec;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$util$EncodingUtil$Codec = new Codec[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])codecArray, (Class)clazz);
        }
    }
}

