/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import net.sourceforge.retroweaver.runtime.java.lang.Iterable;
import org.apache.abdera.protocol.util.AbstractRequest;
import org.apache.abdera.protocol.util.AbstractResponse;

public class CacheControlUtil {
    public static boolean isIdempotent(String method) {
        try {
            Idempotent.valueOf(method.toUpperCase());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static long value(String val) {
        return val != null ? Long.parseLong(val) : -1L;
    }

    private static void append(StringBuffer buf, String value) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(value);
    }

    public static String buildCacheControl(AbstractRequest request) {
        StringBuffer buf = new StringBuffer();
        if (request.isNoCache()) {
            CacheControlUtil.append(buf, "no-cache");
        }
        if (request.isNoStore()) {
            CacheControlUtil.append(buf, "no-store");
        }
        if (request.isNoTransform()) {
            CacheControlUtil.append(buf, "no-transform");
        }
        if (request.isOnlyIfCached()) {
            CacheControlUtil.append(buf, "only-if-cached");
        }
        if (request.getMaxAge() != -1L) {
            CacheControlUtil.append(buf, "max-age=" + request.getMaxAge());
        }
        if (request.getMaxStale() != -1L) {
            CacheControlUtil.append(buf, "max-stale=" + request.getMaxStale());
        }
        if (request.getMinFresh() != -1L) {
            CacheControlUtil.append(buf, "min-fresh=" + request.getMinFresh());
        }
        return buf.toString();
    }

    public static void parseCacheControl(String cc, AbstractRequest request) {
        if (cc == null || cc.length() == 0) {
            return;
        }
        CacheControlParser parser = new CacheControlParser(cc);
        request.setNoCache(false);
        request.setNoStore(false);
        request.setNoTransform(false);
        request.setOnlyIfCached(false);
        request.setMaxAge(-1L);
        request.setMaxStale(-1L);
        request.setMinFresh(-1L);
        Iterator<Directive> i$ = parser.iterator();
        while (i$.hasNext()) {
            Directive directive = i$.next();
            switch (1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[directive.ordinal()]) {
                case 1: {
                    request.setNoCache(true);
                    break;
                }
                case 2: {
                    request.setNoStore(true);
                    break;
                }
                case 3: {
                    request.setNoTransform(true);
                    break;
                }
                case 4: {
                    request.setOnlyIfCached(true);
                    break;
                }
                case 5: {
                    request.setMaxAge(CacheControlUtil.value(parser.getValue(directive)));
                    break;
                }
                case 6: {
                    request.setMaxStale(CacheControlUtil.value(parser.getValue(directive)));
                    break;
                }
                case 7: {
                    request.setMinFresh(CacheControlUtil.value(parser.getValue(directive)));
                }
            }
        }
    }

    public static void parseCacheControl(String cc, AbstractResponse response) {
        if (cc == null) {
            return;
        }
        CacheControlParser parser = new CacheControlParser(cc);
        response.setNoCache(false);
        response.setNoStore(false);
        response.setNoTransform(false);
        response.setMustRevalidate(false);
        response.setPrivate(false);
        response.setPublic(false);
        response.setMaxAge(-1L);
        Iterator<Directive> i$ = parser.iterator();
        while (i$.hasNext()) {
            Directive directive = i$.next();
            switch (1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[directive.ordinal()]) {
                case 1: {
                    response.setNoCache(true);
                    response.setNoCacheHeaders(parser.getValues(directive));
                    break;
                }
                case 2: {
                    response.setNoStore(true);
                    break;
                }
                case 3: {
                    response.setNoTransform(true);
                    break;
                }
                case 8: {
                    response.setMustRevalidate(true);
                    break;
                }
                case 9: {
                    response.setPublic(true);
                    break;
                }
                case 10: {
                    response.setPrivate(true);
                    response.setPrivateHeaders(parser.getValues(directive));
                    break;
                }
                case 5: {
                    response.setMaxAge(CacheControlUtil.value(parser.getValue(directive)));
                }
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive;

        static {
            $SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive = new int[Directive.values().length];
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.NOCACHE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.NOSTORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.NOTRANSFORM.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.ONLYIFCACHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.MAXAGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.MAXSTALE.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.MINFRESH.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.MUSTREVALIDATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.PUBLIC.ordinal()] = 9;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$abdera$protocol$util$CacheControlUtil$Directive[Directive.PRIVATE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheControlParser
    implements Iterable<Directive> {
        private static final String REGEX = "\\s*([\\w\\-]+)\\s*(=)?\\s*(\\d+|\\\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)+\\\")?\\s*";
        private static final Pattern pattern = Pattern.compile("\\s*([\\w\\-]+)\\s*(=)?\\s*(\\d+|\\\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)+\\\")?\\s*");
        private HashMap<Directive, String> values = new HashMap();

        public CacheControlParser(String value) {
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String d = matcher.group(1);
                Directive directive = Directive.select(d);
                if (directive == Directive.UNKNOWN) continue;
                this.values.put(directive, matcher.group(3));
            }
        }

        public Map<Directive, String> getValues() {
            return this.values;
        }

        public String getValue(Directive directive) {
            return this.values.get((Object)directive);
        }

        public Iterator<Directive> iterator() {
            return this.values.keySet().iterator();
        }

        public String[] getValues(Directive directive) {
            String value = this.getValue(directive);
            if (value != null) {
                return CacheControlParser.splitAndTrim(value, ",", true);
            }
            return null;
        }

        private static String unquote(String s) {
            if (s == null || s.length() == 0) {
                return s;
            }
            if (s.startsWith("\"")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"")) {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }

        public static String[] splitAndTrim(String value, String delim, boolean unquote) {
            String[] headers = unquote ? CacheControlParser.unquote(value).split(delim) : value.split(delim);
            for (int n = 0; n < headers.length; ++n) {
                headers[n] = headers[n].trim();
            }
            return headers;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Directive
    extends Enum<Directive> {
        public static final /* enum */ Directive MAXAGE = new Directive("MAXAGE", 0);
        public static final /* enum */ Directive MAXSTALE = new Directive("MAXSTALE", 1);
        public static final /* enum */ Directive MINFRESH = new Directive("MINFRESH", 2);
        public static final /* enum */ Directive NOCACHE = new Directive("NOCACHE", 3);
        public static final /* enum */ Directive NOSTORE = new Directive("NOSTORE", 4);
        public static final /* enum */ Directive NOTRANSFORM = new Directive("NOTRANSFORM", 5);
        public static final /* enum */ Directive ONLYIFCACHED = new Directive("ONLYIFCACHED", 6);
        public static final /* enum */ Directive MUSTREVALIDATE = new Directive("MUSTREVALIDATE", 7);
        public static final /* enum */ Directive PRIVATE = new Directive("PRIVATE", 8);
        public static final /* enum */ Directive PROXYREVALIDATE = new Directive("PROXYREVALIDATE", 9);
        public static final /* enum */ Directive PUBLIC = new Directive("PUBLIC", 10);
        public static final /* enum */ Directive SMAXAGE = new Directive("SMAXAGE", 11);
        public static final /* enum */ Directive UNKNOWN = new Directive("UNKNOWN", 12);
        private static final /* synthetic */ Directive[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$protocol$util$CacheControlUtil$Directive;

        public static final Directive[] values() {
            return (Directive[])$VALUES.clone();
        }

        public static Directive valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$protocol$util$CacheControlUtil$Directive;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$util$CacheControlUtil$Directive = new Directive[0].getClass().getComponentType();
            }
            return (Directive)Enum.valueOf((Class)clazz, (String)name);
        }

        private Directive(String string, int n) {
            super(string, n);
        }

        public static Directive select(String d) {
            try {
                d = d.toUpperCase().replaceAll("-", "");
                return Directive.valueOf(d);
            }
            catch (Exception exception) {
                return UNKNOWN;
            }
        }

        static {
            $VALUES = new Directive[]{MAXAGE, MAXSTALE, MINFRESH, NOCACHE, NOSTORE, NOTRANSFORM, ONLYIFCACHED, MUSTREVALIDATE, PRIVATE, PROXYREVALIDATE, PUBLIC, SMAXAGE, UNKNOWN};
            Directive[] directiveArray = Directive.values();
            Class<?> clazz = class$org$apache$abdera$protocol$util$CacheControlUtil$Directive;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$util$CacheControlUtil$Directive = new Directive[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])directiveArray, (Class)clazz);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Idempotent
    extends Enum<Idempotent> {
        public static final /* enum */ Idempotent GET = new Idempotent("GET", 0);
        public static final /* enum */ Idempotent HEAD = new Idempotent("HEAD", 1);
        public static final /* enum */ Idempotent OPTIONS = new Idempotent("OPTIONS", 2);
        private static final /* synthetic */ Idempotent[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$protocol$util$CacheControlUtil$Idempotent;

        public static final Idempotent[] values() {
            return (Idempotent[])$VALUES.clone();
        }

        public static Idempotent valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$protocol$util$CacheControlUtil$Idempotent;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$util$CacheControlUtil$Idempotent = new Idempotent[0].getClass().getComponentType();
            }
            return (Idempotent)Enum.valueOf((Class)clazz, (String)name);
        }

        private Idempotent(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new Idempotent[]{GET, HEAD, OPTIONS};
            Idempotent[] idempotentArray = Idempotent.values();
            Class<?> clazz = class$org$apache$abdera$protocol$util$CacheControlUtil$Idempotent;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$util$CacheControlUtil$Idempotent = new Idempotent[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])idempotentArray, (Class)clazz);
        }
    }
}

