/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol;

import java.util.Date;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.protocol.Message;
import org.apache.abdera.util.EntityTag;

public interface Response
extends Message {
    public EntityTag getEntityTag();

    public ResponseType getType();

    public int getStatus();

    public String getStatusText();

    public Date getLastModified();

    public long getContentLength();

    public String getAllow();

    public IRI getLocation();

    public boolean isPrivate();

    public boolean isPublic();

    public boolean isMustRevalidate();

    public boolean isProxyRevalidate();

    public long getSMaxAge();

    public long getAge();

    public Date getExpires();

    public String[] getNoCacheHeaders();

    public String[] getPrivateHeaders();

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ResponseType
    extends Enum<ResponseType> {
        public static final /* enum */ ResponseType SUCCESS = new ResponseType("SUCCESS", 0);
        public static final /* enum */ ResponseType REDIRECTION = new ResponseType("REDIRECTION", 1);
        public static final /* enum */ ResponseType CLIENT_ERROR = new ResponseType("CLIENT_ERROR", 2);
        public static final /* enum */ ResponseType SERVER_ERROR = new ResponseType("SERVER_ERROR", 3);
        public static final /* enum */ ResponseType UNKNOWN = new ResponseType("UNKNOWN", 4);
        private static final /* synthetic */ ResponseType[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$protocol$Response$ResponseType;

        public static final ResponseType[] values() {
            return (ResponseType[])$VALUES.clone();
        }

        public static ResponseType valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$protocol$Response$ResponseType;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$Response$ResponseType = new ResponseType[0].getClass().getComponentType();
            }
            return (ResponseType)Enum.valueOf((Class)clazz, (String)name);
        }

        private ResponseType(String string, int n) {
            super(string, n);
        }

        public static ResponseType select(int status) {
            if (status >= 200 && status < 300) {
                return SUCCESS;
            }
            if (status >= 300 && status < 400) {
                return REDIRECTION;
            }
            if (status >= 400 && status < 500) {
                return CLIENT_ERROR;
            }
            if (status >= 500 && status < 600) {
                return SERVER_ERROR;
            }
            return UNKNOWN;
        }

        static {
            $VALUES = new ResponseType[]{SUCCESS, REDIRECTION, CLIENT_ERROR, SERVER_ERROR, UNKNOWN};
            ResponseType[] responseTypeArray = ResponseType.values();
            Class<?> clazz = class$org$apache$abdera$protocol$Response$ResponseType;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$Response$ResponseType = new ResponseType[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])responseTypeArray, (Class)clazz);
        }
    }
}

