/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.factory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.rfc4646.Lang;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Text;
import org.apache.abdera.util.AbstractStreamWriter;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class StreamBuilder
extends AbstractStreamWriter {
    private final Abdera abdera;
    private Base root = null;
    private Base current = null;

    public StreamBuilder() {
        this(Abdera.getInstance());
    }

    public StreamBuilder(Abdera abdera) {
        super("fom");
        this.abdera = abdera;
    }

    public <T extends Base> T getBase() {
        return (T)this.root;
    }

    @Override
    public StreamBuilder startDocument(String xmlversion, String charset) {
        if (this.root != null) {
            throw new IllegalStateException("Document already started");
        }
        this.root = this.abdera.getFactory().newDocument();
        ((Document)this.root).setCharset(charset);
        this.current = this.root;
        return this;
    }

    @Override
    public StreamBuilder startDocument(String xmlversion) {
        return this.startDocument(xmlversion, "UTF-8");
    }

    private static QName getQName(String name, String namespace, String prefix) {
        if (prefix != null) {
            return new QName(namespace, name, prefix);
        }
        if (namespace != null) {
            return new QName(namespace, name);
        }
        return new QName(name);
    }

    @Override
    public StreamBuilder startElement(String name, String namespace, String prefix) {
        this.current = this.abdera.getFactory().newElement(StreamBuilder.getQName(name, namespace, prefix), this.current);
        if (this.root == null) {
            this.root = this.current;
        }
        return this;
    }

    @Override
    public StreamBuilder endElement() {
        this.current = this.current instanceof Element ? ((Element)this.current).getParentElement() : null;
        return this;
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, String prefix, String value) {
        if (!(this.current instanceof Element)) {
            throw new IllegalStateException("Not currently an element");
        }
        ((Element)this.current).setAttributeValue(StreamBuilder.getQName(name, namespace, prefix), value);
        return this;
    }

    @Override
    public StreamBuilder writeComment(String value) {
        this.current.addComment(value);
        return this;
    }

    @Override
    public StreamBuilder writeElementText(String value) {
        if (!(this.current instanceof Element)) {
            throw new IllegalStateException("Not currently an element");
        }
        Element element = (Element)this.current;
        String text = element.getText();
        element.setText(new StringBuffer().append(text).append(value).toString());
        return this;
    }

    @Override
    public StreamBuilder writeId() {
        return this.writeId(this.abdera.getFactory().newUuidUri());
    }

    @Override
    public StreamBuilder writePI(String value) {
        return this.writePI(value, null);
    }

    @Override
    public StreamBuilder writePI(String value, String target) {
        if (!(this.current instanceof Document)) {
            throw new IllegalStateException("Not currently a document");
        }
        ((Document)this.current).addProcessingInstruction(target != null ? target : "", value);
        return this;
    }

    public void close() throws IOException {
    }

    @Override
    public StreamBuilder flush() {
        return this;
    }

    @Override
    public StreamBuilder indent() {
        return this;
    }

    @Override
    public StreamBuilder setOutputStream(OutputStream out) {
        return this;
    }

    @Override
    public StreamBuilder setOutputStream(OutputStream out, String charset) {
        return this;
    }

    @Override
    public StreamBuilder setWriter(Writer writer) {
        return this;
    }

    @Override
    public StreamBuilder endAuthor() {
        return (StreamBuilder)super.endAuthor();
    }

    @Override
    public StreamBuilder endCategories() {
        return (StreamBuilder)super.endCategories();
    }

    @Override
    public StreamBuilder endCategory() {
        return (StreamBuilder)super.endCategory();
    }

    @Override
    public StreamBuilder endCollection() {
        return (StreamBuilder)super.endCollection();
    }

    @Override
    public StreamBuilder endContent() {
        return (StreamBuilder)super.endContent();
    }

    @Override
    public StreamBuilder endContributor() {
        return (StreamBuilder)super.endContributor();
    }

    @Override
    public StreamBuilder endControl() {
        return (StreamBuilder)super.endControl();
    }

    @Override
    public StreamBuilder endDocument() {
        return (StreamBuilder)super.endDocument();
    }

    @Override
    public StreamBuilder endEntry() {
        return (StreamBuilder)super.endEntry();
    }

    @Override
    public StreamBuilder endFeed() {
        return (StreamBuilder)super.endFeed();
    }

    @Override
    public StreamBuilder endGenerator() {
        return (StreamBuilder)super.endGenerator();
    }

    @Override
    public StreamBuilder endLink() {
        return (StreamBuilder)super.endLink();
    }

    @Override
    public StreamBuilder endPerson() {
        return (StreamBuilder)super.endPerson();
    }

    @Override
    public StreamBuilder endService() {
        return (StreamBuilder)super.endService();
    }

    @Override
    public StreamBuilder endSource() {
        return (StreamBuilder)super.endSource();
    }

    @Override
    public StreamBuilder endText() {
        return (StreamBuilder)super.endText();
    }

    @Override
    public StreamBuilder endWorkspace() {
        return (StreamBuilder)super.endWorkspace();
    }

    @Override
    public StreamBuilder setAutoclose(boolean auto) {
        return (StreamBuilder)super.setAutoclose(auto);
    }

    @Override
    public StreamBuilder setAutoflush(boolean auto) {
        return (StreamBuilder)super.setAutoflush(auto);
    }

    @Override
    public StreamBuilder setAutoIndent(boolean indent) {
        return (StreamBuilder)super.setAutoIndent(indent);
    }

    @Override
    public StreamBuilder setChannel(WritableByteChannel channel, String charset) {
        return (StreamBuilder)super.setChannel(channel, charset);
    }

    @Override
    public StreamBuilder setChannel(WritableByteChannel channel) {
        return (StreamBuilder)super.setChannel(channel);
    }

    @Override
    public StreamBuilder startAuthor() {
        return (StreamBuilder)super.startAuthor();
    }

    @Override
    public StreamBuilder startCategories() {
        return (StreamBuilder)super.startCategories();
    }

    @Override
    public StreamBuilder startCategories(boolean fixed, String scheme) {
        return (StreamBuilder)super.startCategories(fixed, scheme);
    }

    @Override
    public StreamBuilder startCategories(boolean fixed) {
        return (StreamBuilder)super.startCategories(fixed);
    }

    @Override
    public StreamBuilder startCategory(String term, String scheme, String label) {
        return (StreamBuilder)super.startCategory(term, scheme, label);
    }

    @Override
    public StreamBuilder startCategory(String term, String scheme) {
        return (StreamBuilder)super.startCategory(term, scheme);
    }

    @Override
    public StreamBuilder startCategory(String term) {
        return (StreamBuilder)super.startCategory(term);
    }

    @Override
    public StreamBuilder startCollection(String href) {
        return (StreamBuilder)super.startCollection(href);
    }

    @Override
    public StreamBuilder startContent(String type, String src) {
        return (StreamBuilder)super.startContent(type, src);
    }

    @Override
    public StreamBuilder startContent(String type) {
        return (StreamBuilder)super.startContent(type);
    }

    @Override
    public StreamBuilder startContent(Content.Type type, String src) {
        return (StreamBuilder)super.startContent(type, src);
    }

    @Override
    public StreamBuilder startContent(Content.Type type) {
        return (StreamBuilder)super.startContent(type);
    }

    @Override
    public StreamBuilder startContributor() {
        return (StreamBuilder)super.startContributor();
    }

    @Override
    public StreamBuilder startControl() {
        return (StreamBuilder)super.startControl();
    }

    @Override
    public StreamBuilder startDocument() {
        return (StreamBuilder)super.startDocument();
    }

    @Override
    public StreamBuilder startElement(QName qname) {
        return (StreamBuilder)super.startElement(qname);
    }

    @Override
    public StreamBuilder startElement(String name, String namespace) {
        return (StreamBuilder)super.startElement(name, namespace);
    }

    @Override
    public StreamBuilder startElement(String name) {
        return (StreamBuilder)super.startElement(name);
    }

    @Override
    public StreamBuilder startEntry() {
        return (StreamBuilder)super.startEntry();
    }

    @Override
    public StreamBuilder startFeed() {
        return (StreamBuilder)super.startFeed();
    }

    @Override
    public StreamBuilder startGenerator(String version, String uri) {
        return (StreamBuilder)super.startGenerator(version, uri);
    }

    @Override
    public StreamBuilder startLink(String iri, String rel, String type, String title, String hreflang, long length) {
        return (StreamBuilder)super.startLink(iri, rel, type, title, hreflang, length);
    }

    @Override
    public StreamBuilder startLink(String iri, String rel, String type) {
        return (StreamBuilder)super.startLink(iri, rel, type);
    }

    @Override
    public StreamBuilder startLink(String iri, String rel) {
        return (StreamBuilder)super.startLink(iri, rel);
    }

    @Override
    public StreamBuilder startLink(String iri) {
        return (StreamBuilder)super.startLink(iri);
    }

    @Override
    public StreamBuilder startPerson(QName qname) {
        return (StreamBuilder)super.startPerson(qname);
    }

    @Override
    public StreamBuilder startPerson(String name, String namespace, String prefix) {
        return (StreamBuilder)super.startPerson(name, namespace, prefix);
    }

    @Override
    public StreamBuilder startPerson(String name, String namespace) {
        return (StreamBuilder)super.startPerson(name, namespace);
    }

    @Override
    public StreamBuilder startPerson(String name) {
        return (StreamBuilder)super.startPerson(name);
    }

    @Override
    public StreamBuilder startService() {
        return (StreamBuilder)super.startService();
    }

    @Override
    public StreamBuilder startSource() {
        return (StreamBuilder)super.startSource();
    }

    @Override
    public StreamBuilder startText(QName qname, Text.Type type) {
        return (StreamBuilder)super.startText(qname, type);
    }

    @Override
    public StreamBuilder startText(String name, String namespace, String prefix, Text.Type type) {
        return (StreamBuilder)super.startText(name, namespace, prefix, type);
    }

    @Override
    public StreamBuilder startText(String name, String namespace, Text.Type type) {
        return (StreamBuilder)super.startText(name, namespace, type);
    }

    @Override
    public StreamBuilder startText(String name, Text.Type type) {
        return (StreamBuilder)super.startText(name, type);
    }

    @Override
    public StreamBuilder startWorkspace() {
        return (StreamBuilder)super.startWorkspace();
    }

    @Override
    public StreamBuilder writeAccepts(String ... accepts) {
        return (StreamBuilder)super.writeAccepts(accepts);
    }

    @Override
    public StreamBuilder writeAcceptsEntry() {
        return (StreamBuilder)super.writeAcceptsEntry();
    }

    @Override
    public StreamBuilder writeAcceptsNothing() {
        return (StreamBuilder)super.writeAcceptsNothing();
    }

    @Override
    public StreamBuilder writeAttribute(QName qname, Date value) {
        return (StreamBuilder)super.writeAttribute(qname, value);
    }

    @Override
    public StreamBuilder writeAttribute(QName qname, double value) {
        return (StreamBuilder)super.writeAttribute(qname, value);
    }

    @Override
    public StreamBuilder writeAttribute(QName qname, int value) {
        return (StreamBuilder)super.writeAttribute(qname, value);
    }

    @Override
    public StreamBuilder writeAttribute(QName qname, long value) {
        return (StreamBuilder)super.writeAttribute(qname, value);
    }

    @Override
    public StreamBuilder writeAttribute(QName qname, String value) {
        return (StreamBuilder)super.writeAttribute(qname, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, Date value) {
        return (StreamBuilder)super.writeAttribute(name, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, double value) {
        return (StreamBuilder)super.writeAttribute(name, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, int value) {
        return (StreamBuilder)super.writeAttribute(name, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, long value) {
        return (StreamBuilder)super.writeAttribute(name, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, Date value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, double value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, int value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, long value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, String prefix, Date value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, prefix, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, String prefix, double value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, prefix, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, String prefix, int value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, prefix, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, String prefix, long value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, prefix, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String namespace, String value) {
        return (StreamBuilder)super.writeAttribute(name, namespace, value);
    }

    @Override
    public StreamBuilder writeAttribute(String name, String value) {
        return (StreamBuilder)super.writeAttribute(name, value);
    }

    @Override
    public StreamBuilder writeAuthor(String name, String email, String uri) {
        return (StreamBuilder)super.writeAuthor(name, email, uri);
    }

    @Override
    public StreamBuilder writeAuthor(String name) {
        return (StreamBuilder)super.writeAuthor(name);
    }

    @Override
    public StreamBuilder writeBase(IRI iri) {
        return (StreamBuilder)super.writeBase(iri);
    }

    @Override
    public StreamBuilder writeBase(String iri) {
        return (StreamBuilder)super.writeBase(iri);
    }

    @Override
    public StreamBuilder writeCategory(String term, String scheme, String label) {
        return (StreamBuilder)super.writeCategory(term, scheme, label);
    }

    @Override
    public StreamBuilder writeCategory(String term, String scheme) {
        return (StreamBuilder)super.writeCategory(term, scheme);
    }

    @Override
    public StreamBuilder writeCategory(String term) {
        return (StreamBuilder)super.writeCategory(term);
    }

    @Override
    public StreamBuilder writeContent(String type, String value) {
        return (StreamBuilder)super.writeContent(type, value);
    }

    @Override
    public StreamBuilder writeContent(Content.Type type, DataHandler value) throws IOException {
        return (StreamBuilder)super.writeContent(type, value);
    }

    @Override
    public StreamBuilder writeContent(Content.Type type, InputStream value) throws IOException {
        return (StreamBuilder)super.writeContent(type, value);
    }

    @Override
    public StreamBuilder writeContent(Content.Type type, String value) {
        return (StreamBuilder)super.writeContent(type, value);
    }

    @Override
    public StreamBuilder writeContributor(String name, String email, String uri) {
        return (StreamBuilder)super.writeContributor(name, email, uri);
    }

    @Override
    public StreamBuilder writeContributor(String name) {
        return (StreamBuilder)super.writeContributor(name);
    }

    @Override
    public StreamBuilder writeDate(QName qname, Date date) {
        return (StreamBuilder)super.writeDate(qname, date);
    }

    @Override
    public StreamBuilder writeDate(QName qname, String date) {
        return (StreamBuilder)super.writeDate(qname, date);
    }

    @Override
    public StreamBuilder writeDate(String name, Date date) {
        return (StreamBuilder)super.writeDate(name, date);
    }

    @Override
    public StreamBuilder writeDate(String name, String namespace, Date date) {
        return (StreamBuilder)super.writeDate(name, namespace, date);
    }

    @Override
    public StreamBuilder writeDate(String name, String namespace, String prefix, Date date) {
        return (StreamBuilder)super.writeDate(name, namespace, prefix, date);
    }

    @Override
    public StreamBuilder writeDate(String name, String namespace, String prefix, String date) {
        return (StreamBuilder)super.writeDate(name, namespace, prefix, date);
    }

    @Override
    public StreamBuilder writeDate(String name, String namespace, String date) {
        return (StreamBuilder)super.writeDate(name, namespace, date);
    }

    @Override
    public StreamBuilder writeDate(String name, String date) {
        return (StreamBuilder)super.writeDate(name, date);
    }

    @Override
    public StreamBuilder writeDraft(boolean draft) {
        return (StreamBuilder)super.writeDraft(draft);
    }

    @Override
    public StreamBuilder writeEdited(Date date) {
        return (StreamBuilder)super.writeEdited(date);
    }

    @Override
    public StreamBuilder writeEdited(String date) {
        return (StreamBuilder)super.writeEdited(date);
    }

    @Override
    public StreamBuilder writeElementText(DataHandler value) throws IOException {
        return (StreamBuilder)super.writeElementText(value);
    }

    @Override
    public StreamBuilder writeElementText(Date value) {
        return (StreamBuilder)super.writeElementText(value);
    }

    @Override
    public StreamBuilder writeElementText(double value) {
        return (StreamBuilder)super.writeElementText(value);
    }

    @Override
    public StreamBuilder writeElementText(InputStream value) throws IOException {
        return (StreamBuilder)super.writeElementText(value);
    }

    @Override
    public StreamBuilder writeElementText(int value) {
        return (StreamBuilder)super.writeElementText(value);
    }

    @Override
    public StreamBuilder writeElementText(long value) {
        return (StreamBuilder)super.writeElementText(value);
    }

    @Override
    public StreamBuilder writeElementText(String format, Object ... args) {
        return (StreamBuilder)super.writeElementText(format, args);
    }

    @Override
    public StreamBuilder writeGenerator(String version, String uri, String value) {
        return (StreamBuilder)super.writeGenerator(version, uri, value);
    }

    @Override
    public StreamBuilder writeIcon(IRI iri) {
        return (StreamBuilder)super.writeIcon(iri);
    }

    @Override
    public StreamBuilder writeIcon(String iri) {
        return (StreamBuilder)super.writeIcon(iri);
    }

    @Override
    public StreamBuilder writeId(IRI iri) {
        return (StreamBuilder)super.writeId(iri);
    }

    @Override
    public StreamBuilder writeId(String iri) {
        return (StreamBuilder)super.writeId(iri);
    }

    @Override
    public StreamBuilder writeIRIElement(QName qname, IRI iri) {
        return (StreamBuilder)super.writeIRIElement(qname, iri);
    }

    @Override
    public StreamBuilder writeIRIElement(QName qname, String iri) {
        return (StreamBuilder)super.writeIRIElement(qname, iri);
    }

    @Override
    public StreamBuilder writeIRIElement(String name, IRI iri) {
        return (StreamBuilder)super.writeIRIElement(name, iri);
    }

    @Override
    public StreamBuilder writeIRIElement(String name, String namespace, IRI iri) {
        return (StreamBuilder)super.writeIRIElement(name, namespace, iri);
    }

    @Override
    public StreamBuilder writeIRIElement(String name, String namespace, String prefix, IRI iri) {
        return (StreamBuilder)super.writeIRIElement(name, namespace, prefix, iri);
    }

    @Override
    public StreamBuilder writeIRIElement(String name, String namespace, String prefix, String iri) {
        return (StreamBuilder)super.writeIRIElement(name, namespace, prefix, iri);
    }

    @Override
    public StreamBuilder writeIRIElement(String name, String namespace, String iri) {
        return (StreamBuilder)super.writeIRIElement(name, namespace, iri);
    }

    @Override
    public StreamBuilder writeIRIElement(String name, String iri) {
        return (StreamBuilder)super.writeIRIElement(name, iri);
    }

    @Override
    public StreamBuilder writeLanguage(Lang lang) {
        return (StreamBuilder)super.writeLanguage(lang);
    }

    @Override
    public StreamBuilder writeLanguage(Locale locale) {
        return (StreamBuilder)super.writeLanguage(locale);
    }

    @Override
    public StreamBuilder writeLanguage(String lang) {
        return (StreamBuilder)super.writeLanguage(lang);
    }

    @Override
    public StreamBuilder writeLink(String iri, String rel, String type, String title, String hreflang, long length) {
        return (StreamBuilder)super.writeLink(iri, rel, type, title, hreflang, length);
    }

    @Override
    public StreamBuilder writeLink(String iri, String rel, String type) {
        return (StreamBuilder)super.writeLink(iri, rel, type);
    }

    @Override
    public StreamBuilder writeLink(String iri, String rel) {
        return (StreamBuilder)super.writeLink(iri, rel);
    }

    @Override
    public StreamBuilder writeLink(String iri) {
        return (StreamBuilder)super.writeLink(iri);
    }

    @Override
    public StreamBuilder writeLogo(IRI iri) {
        return (StreamBuilder)super.writeLogo(iri);
    }

    @Override
    public StreamBuilder writeLogo(String iri) {
        return (StreamBuilder)super.writeLogo(iri);
    }

    @Override
    public StreamBuilder writePerson(QName qname, String name, String email, String uri) {
        return (StreamBuilder)super.writePerson(qname, name, email, uri);
    }

    @Override
    public StreamBuilder writePerson(String localname, String namespace, String prefix, String name, String email, String uri) {
        return (StreamBuilder)super.writePerson(localname, namespace, prefix, name, email, uri);
    }

    @Override
    public StreamBuilder writePerson(String localname, String namespace, String name, String email, String uri) {
        return (StreamBuilder)super.writePerson(localname, namespace, name, email, uri);
    }

    @Override
    public StreamBuilder writePerson(String localname, String name, String email, String uri) {
        return (StreamBuilder)super.writePerson(localname, name, email, uri);
    }

    @Override
    public StreamBuilder writePersonEmail(String email) {
        return (StreamBuilder)super.writePersonEmail(email);
    }

    @Override
    public StreamBuilder writePersonName(String name) {
        return (StreamBuilder)super.writePersonName(name);
    }

    @Override
    public StreamBuilder writePersonUri(String uri) {
        return (StreamBuilder)super.writePersonUri(uri);
    }

    @Override
    public StreamBuilder writePublished(Date date) {
        return (StreamBuilder)super.writePublished(date);
    }

    @Override
    public StreamBuilder writePublished(String date) {
        return (StreamBuilder)super.writePublished(date);
    }

    @Override
    public StreamBuilder writeRights(String value) {
        return (StreamBuilder)super.writeRights(value);
    }

    @Override
    public StreamBuilder writeRights(Text.Type type, String value) {
        return (StreamBuilder)super.writeRights(type, value);
    }

    @Override
    public StreamBuilder writeSubtitle(String value) {
        return (StreamBuilder)super.writeSubtitle(value);
    }

    @Override
    public StreamBuilder writeSubtitle(Text.Type type, String value) {
        return (StreamBuilder)super.writeSubtitle(type, value);
    }

    @Override
    public StreamBuilder writeSummary(String value) {
        return (StreamBuilder)super.writeSummary(value);
    }

    @Override
    public StreamBuilder writeSummary(Text.Type type, String value) {
        return (StreamBuilder)super.writeSummary(type, value);
    }

    @Override
    public StreamBuilder writeText(QName qname, Text.Type type, String value) {
        return (StreamBuilder)super.writeText(qname, type, value);
    }

    @Override
    public StreamBuilder writeText(String name, String namespace, String prefix, Text.Type type, String value) {
        return (StreamBuilder)super.writeText(name, namespace, prefix, type, value);
    }

    @Override
    public StreamBuilder writeText(String name, String namespace, Text.Type type, String value) {
        return (StreamBuilder)super.writeText(name, namespace, type, value);
    }

    @Override
    public StreamBuilder writeText(String name, Text.Type type, String value) {
        return (StreamBuilder)super.writeText(name, type, value);
    }

    @Override
    public StreamBuilder writeTitle(String value) {
        return (StreamBuilder)super.writeTitle(value);
    }

    @Override
    public StreamBuilder writeTitle(Text.Type type, String value) {
        return (StreamBuilder)super.writeTitle(type, value);
    }

    @Override
    public StreamBuilder writeUpdated(Date date) {
        return (StreamBuilder)super.writeUpdated(date);
    }

    @Override
    public StreamBuilder writeUpdated(String date) {
        return (StreamBuilder)super.writeUpdated(date);
    }

    @Override
    public StreamWriter writeElementText(String x0, Object[] x1) {
        return this.writeElementText(x0, x1);
    }

    @Override
    public StreamWriter writePerson(String x0, String x1, String x2, String x3) {
        return this.writePerson(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writePerson(String x0, String x1, String x2, String x3, String x4) {
        return this.writePerson(x0, x1, x2, x3, x4);
    }

    @Override
    public StreamWriter writePerson(String x0, String x1, String x2, String x3, String x4, String x5) {
        return this.writePerson(x0, x1, x2, x3, x4, x5);
    }

    @Override
    public StreamWriter startPerson(String x0) {
        return this.startPerson(x0);
    }

    @Override
    public StreamWriter startPerson(String x0, String x1) {
        return this.startPerson(x0, x1);
    }

    @Override
    public StreamWriter startPerson(String x0, String x1, String x2) {
        return this.startPerson(x0, x1, x2);
    }

    @Override
    public StreamWriter writeText(String x0, Text.Type x1, String x2) {
        return this.writeText(x0, x1, x2);
    }

    @Override
    public StreamWriter writeText(String x0, String x1, Text.Type x2, String x3) {
        return this.writeText(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeText(String x0, String x1, String x2, Text.Type x3, String x4) {
        return this.writeText(x0, x1, x2, x3, x4);
    }

    @Override
    public StreamWriter startText(String x0, Text.Type x1) {
        return this.startText(x0, x1);
    }

    @Override
    public StreamWriter startText(String x0, String x1, Text.Type x2) {
        return this.startText(x0, x1, x2);
    }

    @Override
    public StreamWriter startText(String x0, String x1, String x2, Text.Type x3) {
        return this.startText(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeDate(String x0, String x1, String x2, String x3) {
        return this.writeDate(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeDate(String x0, String x1, String x2) {
        return this.writeDate(x0, x1, x2);
    }

    @Override
    public StreamWriter writeDate(String x0, String x1) {
        return this.writeDate(x0, x1);
    }

    @Override
    public StreamWriter writeDate(String x0, String x1, String x2, Date x3) {
        return this.writeDate(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeDate(String x0, String x1, Date x2) {
        return this.writeDate(x0, x1, x2);
    }

    @Override
    public StreamWriter writeDate(String x0, Date x1) {
        return this.writeDate(x0, x1);
    }

    @Override
    public StreamWriter writeIRIElement(String x0, String x1) {
        return this.writeIRIElement(x0, x1);
    }

    @Override
    public StreamWriter writeIRIElement(String x0, String x1, String x2) {
        return this.writeIRIElement(x0, x1, x2);
    }

    @Override
    public StreamWriter writeIRIElement(String x0, String x1, String x2, String x3) {
        return this.writeIRIElement(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeIRIElement(String x0, String x1, String x2, IRI x3) {
        return this.writeIRIElement(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeIRIElement(String x0, String x1, IRI x2) {
        return this.writeIRIElement(x0, x1, x2);
    }

    @Override
    public StreamWriter writeIRIElement(String x0, IRI x1) {
        return this.writeIRIElement(x0, x1);
    }

    @Override
    public StreamWriter writeLanguage(Locale x0) {
        return this.writeLanguage(x0);
    }

    @Override
    public StreamWriter writeLanguage(Lang x0) {
        return this.writeLanguage(x0);
    }

    @Override
    public StreamWriter writeLanguage(String x0) {
        return this.writeLanguage(x0);
    }

    @Override
    public StreamWriter writeBase(IRI x0) {
        return this.writeBase(x0);
    }

    @Override
    public StreamWriter writeBase(String x0) {
        return this.writeBase(x0);
    }

    @Override
    public StreamWriter writeElementText(double x0) {
        return this.writeElementText(x0);
    }

    @Override
    public StreamWriter writeElementText(long x0) {
        return this.writeElementText(x0);
    }

    @Override
    public StreamWriter writeElementText(int x0) {
        return this.writeElementText(x0);
    }

    @Override
    public StreamWriter writeElementText(Date x0) {
        return this.writeElementText(x0);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, String x2, double x3) {
        return this.writeAttribute(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, double x2) {
        return this.writeAttribute(x0, x1, x2);
    }

    @Override
    public StreamWriter writeAttribute(String x0, double x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeAttribute(QName x0, double x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, String x2, long x3) {
        return this.writeAttribute(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, long x2) {
        return this.writeAttribute(x0, x1, x2);
    }

    @Override
    public StreamWriter writeAttribute(String x0, long x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeAttribute(QName x0, long x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, String x2, int x3) {
        return this.writeAttribute(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, int x2) {
        return this.writeAttribute(x0, x1, x2);
    }

    @Override
    public StreamWriter writeAttribute(String x0, int x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeAttribute(QName x0, int x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, String x2, Date x3) {
        return this.writeAttribute(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, Date x2) {
        return this.writeAttribute(x0, x1, x2);
    }

    @Override
    public StreamWriter writeAttribute(String x0, Date x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeAttribute(QName x0, Date x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter setAutoIndent(boolean x0) {
        return this.setAutoIndent(x0);
    }

    @Override
    public StreamWriter startElement(String x0, String x1) {
        return this.startElement(x0, x1);
    }

    @Override
    public StreamWriter startElement(String x0) {
        return this.startElement(x0);
    }

    @Override
    public StreamWriter startElement(QName x0) {
        return this.startElement(x0);
    }

    @Override
    public StreamWriter writeAttribute(QName x0, String x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, String x2) {
        return this.writeAttribute(x0, x1, x2);
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1) {
        return this.writeAttribute(x0, x1);
    }

    @Override
    public StreamWriter writeDraft(boolean x0) {
        return this.writeDraft(x0);
    }

    @Override
    public StreamWriter endControl() {
        return this.endControl();
    }

    @Override
    public StreamWriter startControl() {
        return this.startControl();
    }

    @Override
    public StreamWriter endCategories() {
        return this.endCategories();
    }

    @Override
    public StreamWriter startCategories(boolean x0, String x1) {
        return this.startCategories(x0, x1);
    }

    @Override
    public StreamWriter startCategories(boolean x0) {
        return this.startCategories(x0);
    }

    @Override
    public StreamWriter startCategories() {
        return this.startCategories();
    }

    @Override
    public StreamWriter writeAcceptsNothing() {
        return this.writeAcceptsNothing();
    }

    @Override
    public StreamWriter writeAcceptsEntry() {
        return this.writeAcceptsEntry();
    }

    @Override
    public StreamWriter writeAccepts(String[] x0) {
        return this.writeAccepts(x0);
    }

    @Override
    public StreamWriter endCollection() {
        return this.endCollection();
    }

    @Override
    public StreamWriter startCollection(String x0) {
        return this.startCollection(x0);
    }

    @Override
    public StreamWriter endWorkspace() {
        return this.endWorkspace();
    }

    @Override
    public StreamWriter startWorkspace() {
        return this.startWorkspace();
    }

    @Override
    public StreamWriter endService() {
        return this.endService();
    }

    @Override
    public StreamWriter startService() {
        return this.startService();
    }

    @Override
    public StreamWriter startCategory(String x0, String x1, String x2) {
        return this.startCategory(x0, x1, x2);
    }

    @Override
    public StreamWriter startCategory(String x0, String x1) {
        return this.startCategory(x0, x1);
    }

    @Override
    public StreamWriter startCategory(String x0) {
        return this.startCategory(x0);
    }

    @Override
    public StreamWriter endGenerator() {
        return this.endGenerator();
    }

    @Override
    public StreamWriter startGenerator(String x0, String x1) {
        return this.startGenerator(x0, x1);
    }

    @Override
    public StreamWriter writeGenerator(String x0, String x1, String x2) {
        return this.writeGenerator(x0, x1, x2);
    }

    @Override
    public StreamWriter endContributor() {
        return this.endContributor();
    }

    @Override
    public StreamWriter startContributor() {
        return this.startContributor();
    }

    @Override
    public StreamWriter writeContributor(String x0) {
        return this.writeContributor(x0);
    }

    @Override
    public StreamWriter writeContributor(String x0, String x1, String x2) {
        return this.writeContributor(x0, x1, x2);
    }

    @Override
    public StreamWriter endAuthor() {
        return this.endAuthor();
    }

    @Override
    public StreamWriter startAuthor() {
        return this.startAuthor();
    }

    @Override
    public StreamWriter writeAuthor(String x0) {
        return this.writeAuthor(x0);
    }

    @Override
    public StreamWriter writeAuthor(String x0, String x1, String x2) {
        return this.writeAuthor(x0, x1, x2);
    }

    @Override
    public StreamWriter writeRights(Text.Type x0, String x1) {
        return this.writeRights(x0, x1);
    }

    @Override
    public StreamWriter writeRights(String x0) {
        return this.writeRights(x0);
    }

    @Override
    public StreamWriter writeSummary(Text.Type x0, String x1) {
        return this.writeSummary(x0, x1);
    }

    @Override
    public StreamWriter writeSummary(String x0) {
        return this.writeSummary(x0);
    }

    @Override
    public StreamWriter writeSubtitle(Text.Type x0, String x1) {
        return this.writeSubtitle(x0, x1);
    }

    @Override
    public StreamWriter writeSubtitle(String x0) {
        return this.writeSubtitle(x0);
    }

    @Override
    public StreamWriter writeTitle(Text.Type x0, String x1) {
        return this.writeTitle(x0, x1);
    }

    @Override
    public StreamWriter writeTitle(String x0) {
        return this.writeTitle(x0);
    }

    @Override
    public StreamWriter writeElementText(DataHandler x0) throws IOException {
        return this.writeElementText(x0);
    }

    @Override
    public StreamWriter writeElementText(InputStream x0) throws IOException {
        return this.writeElementText(x0);
    }

    @Override
    public StreamWriter writeIRIElement(QName x0, IRI x1) {
        return this.writeIRIElement(x0, x1);
    }

    @Override
    public StreamWriter writeLogo(IRI x0) {
        return this.writeLogo(x0);
    }

    @Override
    public StreamWriter writeIcon(IRI x0) {
        return this.writeIcon(x0);
    }

    @Override
    public StreamWriter writeId(IRI x0) {
        return this.writeId(x0);
    }

    @Override
    public StreamWriter writeDate(QName x0, Date x1) {
        return this.writeDate(x0, x1);
    }

    @Override
    public StreamWriter writeEdited(String x0) {
        return this.writeEdited(x0);
    }

    @Override
    public StreamWriter writePublished(String x0) {
        return this.writePublished(x0);
    }

    @Override
    public StreamWriter writeUpdated(String x0) {
        return this.writeUpdated(x0);
    }

    @Override
    public StreamWriter writeUpdated(Date x0) {
        return this.writeUpdated(x0);
    }

    @Override
    public StreamWriter writeText(QName x0, Text.Type x1, String x2) {
        return this.writeText(x0, x1, x2);
    }

    @Override
    public StreamWriter writePublished(Date x0) {
        return this.writePublished(x0);
    }

    @Override
    public StreamWriter writePerson(QName x0, String x1, String x2, String x3) {
        return this.writePerson(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writeLink(String x0, String x1, String x2, String x3, String x4, long x5) {
        return this.writeLink(x0, x1, x2, x3, x4, x5);
    }

    @Override
    public StreamWriter writeLink(String x0, String x1, String x2) {
        return this.writeLink(x0, x1, x2);
    }

    @Override
    public StreamWriter writeLink(String x0, String x1) {
        return this.writeLink(x0, x1);
    }

    @Override
    public StreamWriter writeLink(String x0) {
        return this.writeLink(x0);
    }

    @Override
    public StreamWriter writeLogo(String x0) {
        return this.writeLogo(x0);
    }

    @Override
    public StreamWriter writeIcon(String x0) {
        return this.writeIcon(x0);
    }

    @Override
    public StreamWriter writeId(String x0) {
        return this.writeId(x0);
    }

    @Override
    public StreamWriter writeEdited(Date x0) {
        return this.writeEdited(x0);
    }

    @Override
    public StreamWriter writeContent(String x0, String x1) {
        return this.writeContent(x0, x1);
    }

    @Override
    public StreamWriter writeContent(Content.Type x0, DataHandler x1) throws IOException {
        return this.writeContent(x0, x1);
    }

    @Override
    public StreamWriter writeContent(Content.Type x0, InputStream x1) throws IOException {
        return this.writeContent(x0, x1);
    }

    @Override
    public StreamWriter writeContent(Content.Type x0, String x1) {
        return this.writeContent(x0, x1);
    }

    @Override
    public StreamWriter writeCategory(String x0, String x1, String x2) {
        return this.writeCategory(x0, x1, x2);
    }

    @Override
    public StreamWriter writeCategory(String x0, String x1) {
        return this.writeCategory(x0, x1);
    }

    @Override
    public StreamWriter writeCategory(String x0) {
        return this.writeCategory(x0);
    }

    @Override
    public StreamWriter startLink(String x0, String x1, String x2) {
        return this.startLink(x0, x1, x2);
    }

    @Override
    public StreamWriter startLink(String x0, String x1) {
        return this.startLink(x0, x1);
    }

    @Override
    public StreamWriter startLink(String x0) {
        return this.startLink(x0);
    }

    @Override
    public StreamWriter startContent(String x0) {
        return this.startContent(x0);
    }

    @Override
    public StreamWriter startContent(Content.Type x0) {
        return this.startContent(x0);
    }

    @Override
    public StreamWriter startContent(String x0, String x1) {
        return this.startContent(x0, x1);
    }

    @Override
    public StreamWriter startContent(Content.Type x0, String x1) {
        return this.startContent(x0, x1);
    }

    @Override
    public StreamWriter writePersonUri(String x0) {
        return this.writePersonUri(x0);
    }

    @Override
    public StreamWriter writePersonName(String x0) {
        return this.writePersonName(x0);
    }

    @Override
    public StreamWriter writePersonEmail(String x0) {
        return this.writePersonEmail(x0);
    }

    @Override
    public StreamWriter writeIRIElement(QName x0, String x1) {
        return this.writeIRIElement(x0, x1);
    }

    @Override
    public StreamWriter writeDate(QName x0, String x1) {
        return this.writeDate(x0, x1);
    }

    @Override
    public StreamWriter startText(QName x0, Text.Type x1) {
        return this.startText(x0, x1);
    }

    @Override
    public StreamWriter startSource() {
        return this.startSource();
    }

    @Override
    public StreamWriter startPerson(QName x0) {
        return this.startPerson(x0);
    }

    @Override
    public StreamWriter startLink(String x0, String x1, String x2, String x3, String x4, long x5) {
        return this.startLink(x0, x1, x2, x3, x4, x5);
    }

    @Override
    public StreamWriter endText() {
        return this.endText();
    }

    @Override
    public StreamWriter endSource() {
        return this.endSource();
    }

    @Override
    public StreamWriter endPerson() {
        return this.endPerson();
    }

    @Override
    public StreamWriter endLink() {
        return this.endLink();
    }

    @Override
    public StreamWriter endContent() {
        return this.endContent();
    }

    @Override
    public StreamWriter endCategory() {
        return this.endCategory();
    }

    @Override
    public StreamWriter endEntry() {
        return this.endEntry();
    }

    @Override
    public StreamWriter startEntry() {
        return this.startEntry();
    }

    @Override
    public StreamWriter endFeed() {
        return this.endFeed();
    }

    @Override
    public StreamWriter startFeed() {
        return this.startFeed();
    }

    @Override
    public StreamWriter endDocument() {
        return this.endDocument();
    }

    @Override
    public StreamWriter startDocument() {
        return this.startDocument();
    }

    @Override
    public StreamWriter setChannel(WritableByteChannel x0, String x1) {
        return this.setChannel(x0, x1);
    }

    @Override
    public StreamWriter setChannel(WritableByteChannel x0) {
        return this.setChannel(x0);
    }

    @Override
    public StreamWriter setAutoclose(boolean x0) {
        return this.setAutoclose(x0);
    }

    @Override
    public StreamWriter setAutoflush(boolean x0) {
        return this.setAutoflush(x0);
    }

    @Override
    public StreamWriter indent() {
        return this.indent();
    }

    @Override
    public StreamWriter writeAttribute(String x0, String x1, String x2, String x3) {
        return this.writeAttribute(x0, x1, x2, x3);
    }

    @Override
    public StreamWriter writePI(String x0, String x1) {
        return this.writePI(x0, x1);
    }

    @Override
    public StreamWriter writePI(String x0) {
        return this.writePI(x0);
    }

    @Override
    public StreamWriter writeComment(String x0) {
        return this.writeComment(x0);
    }

    @Override
    public StreamWriter endElement() {
        return this.endElement();
    }

    @Override
    public StreamWriter writeElementText(String x0) {
        return this.writeElementText(x0);
    }

    @Override
    public StreamWriter startElement(String x0, String x1, String x2) {
        return this.startElement(x0, x1, x2);
    }

    @Override
    public StreamWriter writeId() {
        return this.writeId();
    }

    @Override
    public StreamWriter startDocument(String x0) {
        return this.startDocument(x0);
    }

    @Override
    public StreamWriter startDocument(String x0, String x1) {
        return this.startDocument(x0, x1);
    }

    @Override
    public StreamWriter setOutputStream(OutputStream x0, String x1) {
        return this.setOutputStream(x0, x1);
    }

    @Override
    public StreamWriter setOutputStream(OutputStream x0) {
        return this.setOutputStream(x0);
    }

    @Override
    public StreamWriter setWriter(Writer x0) {
        return this.setWriter(x0);
    }

    @Override
    public StreamWriter flush() {
        return this.flush();
    }
}

