/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHelper {
    public static Map<String, Object[]> getCacheableHeaders(ClientResponse response) {
        String[] headers;
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        for (String header : headers = response.getHeaderNames()) {
            if (!MethodHelper.isCacheableHeader(header, response)) continue;
            Object[] list = response.getHeaders(header);
            map.put(header, list);
        }
        return map;
    }

    public static boolean isCacheableHeader(String header, ClientResponse response) {
        return !MethodHelper.isNoCacheOrPrivate(header, response) && !MethodHelper.isHopByHop(header);
    }

    public static boolean isNoCacheOrPrivate(String header, ClientResponse response) {
        String[] no_cache_headers = response.getNoCacheHeaders();
        String[] private_headers = response.getPrivateHeaders();
        return MethodHelper.contains(no_cache_headers, header) || MethodHelper.contains(private_headers, header);
    }

    private static boolean contains(String[] headers, String header) {
        if (headers != null) {
            for (String h : headers) {
                if (!h.equals(header)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHopByHop(String header) {
        try {
            HopByHop.valueOf(header.replaceAll("-", ""));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static EntityEnclosingMethod getMethod(EntityEnclosingMethod method, RequestEntity entity) {
        if (entity != null) {
            method.setRequestEntity(entity);
        }
        return method;
    }

    public static HttpMethod createMethod(String method, String uri, RequestEntity entity, RequestOptions options) {
        if (method == null) {
            return null;
        }
        Method m = Method.fromString(method);
        Method actual = null;
        GetMethod httpMethod = null;
        if (options.isUsePostOverride()) {
            if (m.equals((Object)Method.PUT)) {
                actual = m;
            } else if (m.equals((Object)Method.DELETE)) {
                actual = m;
            }
            if (actual != null) {
                m = Method.POST;
            }
        }
        switch (m) {
            case GET: {
                httpMethod = new GetMethod(uri);
                break;
            }
            case POST: {
                httpMethod = MethodHelper.getMethod((EntityEnclosingMethod)new PostMethod(uri), entity);
                break;
            }
            case PUT: {
                httpMethod = MethodHelper.getMethod((EntityEnclosingMethod)new PutMethod(uri), entity);
                break;
            }
            case DELETE: {
                httpMethod = new DeleteMethod(uri);
                break;
            }
            case HEAD: {
                httpMethod = new HeadMethod(uri);
                break;
            }
            case OPTIONS: {
                httpMethod = new OptionsMethod(uri);
                break;
            }
            case TRACE: {
                httpMethod = new TraceMethod(uri);
                break;
            }
            default: {
                httpMethod = MethodHelper.getMethod(new ExtensionMethod(method, uri), entity);
            }
        }
        if (actual != null) {
            httpMethod.addRequestHeader("X-HTTP-Method-Override", actual.name());
        }
        MethodHelper.initHeaders(options, (HttpMethod)httpMethod);
        if (!options.isUseExpectContinue()) {
            httpMethod.getParams().setBooleanParameter("http.protocol.expect-continue", false);
        }
        if (!(httpMethod instanceof EntityEnclosingMethod)) {
            httpMethod.setFollowRedirects(options.isFollowRedirects());
        }
        return httpMethod;
    }

    private static void initHeaders(RequestOptions options, HttpMethod method) {
        String[] headers;
        for (String header : headers = options.getHeaderNames()) {
            String[] values;
            for (String value : values = options.getHeaders(header)) {
                method.addRequestHeader(header, value.toString());
            }
        }
        String cc = options.getCacheControl();
        if (cc != null && cc.length() != 0) {
            method.setRequestHeader("Cache-Control", cc);
        }
        if (options.getAuthorization() != null) {
            method.setDoAuthentication(false);
        }
    }

    public static RequestOptions createDefaultRequestOptions() {
        RequestOptions options = new RequestOptions();
        options.setAcceptEncoding("gzip", "deflate");
        options.setAccept("application/atom+xml;type=entry", "application/atom+xml;type=feed", "application/atom+xml", "application/atomsvc+xml", "application/atomcat+xml", "application/xml", "text/xml", "*/*");
        options.setAcceptCharset("utf-8", "*;q=0.5");
        return options;
    }

    public static final class ExtensionMethod
    extends EntityEnclosingMethod {
        private String method = null;

        public ExtensionMethod(String method, String uri) {
            super(method);
            try {
                this.setURI(new URI(uri, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.method = method;
        }

        public String getName() {
            return this.method;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method GET = new Method("GET", 0);
        public static final /* enum */ Method POST = new Method("POST", 1);
        public static final /* enum */ Method PUT = new Method("PUT", 2);
        public static final /* enum */ Method DELETE = new Method("DELETE", 3);
        public static final /* enum */ Method OPTIONS = new Method("OPTIONS", 4);
        public static final /* enum */ Method TRACE = new Method("TRACE", 5);
        public static final /* enum */ Method HEAD = new Method("HEAD", 6);
        public static final /* enum */ Method OTHER = new Method("OTHER", 7);
        private static final /* synthetic */ Method[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$protocol$client$util$MethodHelper$Method;

        public static final Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$protocol$client$util$MethodHelper$Method;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$client$util$MethodHelper$Method = new Method[0].getClass().getComponentType();
            }
            return (Method)Enum.valueOf((Class)clazz, (String)name);
        }

        private Method(String string, int n) {
            super(string, n);
        }

        public static Method fromString(String method) {
            try {
                return Method.valueOf(method.toUpperCase());
            }
            catch (Exception e) {
                return OTHER;
            }
        }

        static {
            $VALUES = new Method[]{GET, POST, PUT, DELETE, OPTIONS, TRACE, HEAD, OTHER};
            Method[] methodArray = Method.values();
            Class<?> clazz = class$org$apache$abdera$protocol$client$util$MethodHelper$Method;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$client$util$MethodHelper$Method = new Method[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])methodArray, (Class)clazz);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HopByHop
    extends Enum<HopByHop> {
        public static final /* enum */ HopByHop Connection = new HopByHop("Connection", 0);
        public static final /* enum */ HopByHop KeepAlive = new HopByHop("KeepAlive", 1);
        public static final /* enum */ HopByHop ProxyAuthenticate = new HopByHop("ProxyAuthenticate", 2);
        public static final /* enum */ HopByHop ProxyAuthorization = new HopByHop("ProxyAuthorization", 3);
        public static final /* enum */ HopByHop TE = new HopByHop("TE", 4);
        public static final /* enum */ HopByHop Trailers = new HopByHop("Trailers", 5);
        public static final /* enum */ HopByHop TransferEncoding = new HopByHop("TransferEncoding", 6);
        public static final /* enum */ HopByHop Upgrade = new HopByHop("Upgrade", 7);
        private static final /* synthetic */ HopByHop[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$org$apache$abdera$protocol$client$util$MethodHelper$HopByHop;

        public static final HopByHop[] values() {
            return (HopByHop[])$VALUES.clone();
        }

        public static HopByHop valueOf(String name) {
            Class<?> clazz = class$org$apache$abdera$protocol$client$util$MethodHelper$HopByHop;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$client$util$MethodHelper$HopByHop = new HopByHop[0].getClass().getComponentType();
            }
            return (HopByHop)Enum.valueOf((Class)clazz, (String)name);
        }

        private HopByHop(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new HopByHop[]{Connection, KeepAlive, ProxyAuthenticate, ProxyAuthorization, TE, Trailers, TransferEncoding, Upgrade};
            HopByHop[] hopByHopArray = HopByHop.values();
            Class<?> clazz = class$org$apache$abdera$protocol$client$util$MethodHelper$HopByHop;
            if (clazz == null) {
                clazz = class$org$apache$abdera$protocol$client$util$MethodHelper$HopByHop = new HopByHop[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])hopByHopArray, (Class)clazz);
        }
    }
}

