/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.cache;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.cache.AbstractCache;
import org.apache.abdera.protocol.client.cache.Cache;
import org.apache.abdera.protocol.client.cache.CachedResponse;
import org.apache.abdera.protocol.client.cache.InMemoryCachedResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InMemoryCache
extends AbstractCache {
    protected final transient Map<Object, CachedResponse> cache;

    protected InMemoryCache(Abdera abdera, Map<Object, CachedResponse> map) {
        super(abdera);
        this.cache = map;
    }

    @Override
    protected CachedResponse createCachedResponse(ClientResponse response, Object key) throws IOException {
        return new InMemoryCachedResponse(this.abdera, this, key, response);
    }

    @Override
    public Cache clear() {
        this.cache.clear();
        return this;
    }

    @Override
    public CachedResponse get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public Cache remove(Object key) {
        this.cache.remove(key);
        return this;
    }

    @Override
    protected void add(Object key, CachedResponse response) {
        this.cache.put(key, response);
    }

    public Iterator<Object> iterator() {
        return this.cache.keySet().iterator();
    }
}

