/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdi.rename.dropins;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactChanger
implements FilenameFilter {
    public static final String ART_FILENAME = "artifacts.xml";
    public static final String NEW_ART_FILENAME = "artifacts.xml.old";
    public static final String JAR_FILENAME = "artifacts.jar";
    public static final String NEW_JAR_FILENAME = "artifacts.jar.old";
    public static final String SITE_FILENAME = "site.xml";
    public static final String NEW_SITE_FILENAME = "site.xml.old";
    public static final String SITE_JAR = "site.jar";
    public static final String NEW_SITE_JAR = "site.jar.old";
    public static final String CONTENT_FILENAME = "content.xml";
    public static final String NEW_CONTENT_FILENAME = "content.xml.old";
    public static final String CONTENT_JAR = "content.jar";
    public static final String NEW_CONTENT_JAR = "content.jar.old";
    public static final String FOLDER_TO_EXLCLUDE = "com.ibm.rational.equinox.transforms.metadata";

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out, true);
        ArtifactChanger.run(args, out);
    }

    public static void run(String[] args, PrintWriter out) {
        if (args[0] == null) {
            out.println("ERROR: ArtifactChanger received no argument.");
            return;
        }
        String installLocation = args[0];
        File dropinsDir = new File(String.valueOf(installLocation) + "/dropins/");
        if (!dropinsDir.exists()) {
            return;
        }
        File[] filesToRename = ArtifactChanger.listFilesAsArray(dropinsDir, new ArtifactChanger(), true);
        boolean success = false;
        File[] fileArray = filesToRename;
        int n = filesToRename.length;
        int n2 = 0;
        while (n2 < n) {
            File current = fileArray[n2];
            String renamedArtifact = "";
            String fileName = current.toString();
            if (fileName.contains(ART_FILENAME)) {
                renamedArtifact = current.toString().replace(ART_FILENAME, NEW_ART_FILENAME);
            } else if (fileName.contains(JAR_FILENAME)) {
                renamedArtifact = current.toString().replace(JAR_FILENAME, NEW_JAR_FILENAME);
            } else if (fileName.contains(SITE_FILENAME)) {
                renamedArtifact = current.toString().replace(SITE_FILENAME, NEW_SITE_FILENAME);
            } else if (fileName.contains(SITE_JAR)) {
                renamedArtifact = current.toString().replace(SITE_JAR, NEW_SITE_JAR);
            } else if (fileName.contains(CONTENT_FILENAME)) {
                renamedArtifact = current.toString().replace(CONTENT_FILENAME, NEW_CONTENT_FILENAME);
            } else if (fileName.contains(CONTENT_JAR)) {
                renamedArtifact = current.toString().replace(CONTENT_JAR, NEW_CONTENT_JAR);
            }
            success = current.renameTo(new File(renamedArtifact));
            if (success) {
                out.println("Renamed file " + current + " to " + renamedArtifact);
            } else {
                out.println("ERROR: There was a problem renaming file " + current + " to " + renamedArtifact);
            }
            ++n2;
        }
    }

    public static File[] listFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection<File> files = ArtifactChanger.listFiles(directory, filter, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        Vector<File> files = new Vector<File>();
        File[] fileArray = entries = directory.listFiles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (recurse && entry.isDirectory() && !entry.getName().equals(FOLDER_TO_EXLCLUDE)) {
                files.addAll(ArtifactChanger.listFiles(entry, filter, recurse));
            }
            ++n2;
        }
        return files;
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.equals(ART_FILENAME) || name.equals(JAR_FILENAME) || name.equals(SITE_FILENAME) || name.equals(SITE_JAR) || name.equals(CONTENT_FILENAME) || name.equals(CONTENT_JAR);
    }
}

