@echo off
setlocal
set BASE_DIR=%~dp0

REM *********** Local envars ***************************

REM The JRE java.exe to be used by Ant.  Note: for WTP 2.0 the JDK needs to be 1.5 or higher.
set JAVAEXE="%RAD75_JAVA_HOME%\bin\java.exe"

REM The Eclipse install directory.  Some Eclipse based products may refer to this directory
REM as the non shared directory.
set INSTALL_DIRECTORY="%RAD75_INSTALL%"

REM The Eclipse Equinox Launcher jar.  Usually this plugin jar file is located in the
REM shared plugin directory(ie. plugins\org.eclipse.equinox.launcher*.jar )
set LAUNCHER_JAR="%RAD75_LAUNCHER%"

:workspace
if not $"%WORKSPACE%"$==$""$ goto check
REM #######################################################
REM ##### you must edit the "WORKSPACE" setting below #####
REM #######################################################
REM *********** The location of your workspace ************
set WORKSPACE=X:\MyWorkspace

:check
REM ************* The location of your workspace *****************
if not exist "%WORKSPACE%" echo ERROR: incorrect workspace=%WORKSPACE%, edit this runAnt.bat and correct the WORKSPACE envar
if not exist "%WORKSPACE%" goto done


:run
@echo on
%JAVAEXE% -Dwtp.autotest.noninteractive=true -cp %LAUNCHER_JAR% org.eclipse.equinox.launcher.Main -install %INSTALL_DIRECTORY% -application com.ibm.etools.j2ee.ant.RunAnt  -data "%WORKSPACE%"  %*
@if %ERRORLEVEL% EQU 0 goto done
@if %ERRORLEVEL% EQU 13 echo runAnt BUILD FAILED.
@if %ERRORLEVEL% EQU 13 goto done
@if %ERRORLEVEL% EQU 15 echo WORKSPACE is already BEING USED.
@if %ERRORLEVEL% EQU 15 goto done
@if %ERRORLEVEL% EQU 23 echo totally clean (UNINITIALIZED) workspace, it is now setup.  will rerun...
@if %ERRORLEVEL% EQU 23 goto run
@echo runAnt FAILED? (return code %ERRORLEVEL%)
:pause
@pause

:done
