/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ast.jacl2jython;

import com.ibm.ws.ast.jacl2jython.Jacl2JythonMessages;
import com.ibm.ws.ast.jacl2jython.Token;
import com.ibm.ws.ast.jacl2jython.TokenMgrError;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = TokenMgrError.eol;

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String string = "";
        int n = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (n < this.expectedTokenSequences[i].length) {
                n = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                string = string + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            string = string + this.eol + "    ";
        }
        String[] stringArray = new String[]{Integer.toString(this.currentToken.next.beginLine), Integer.toString(this.currentToken.next.beginColumn)};
        String string2 = Jacl2JythonMessages.getParameterResourceString("Location_at_line_column", stringArray) + this.eol;
        String[] stringArray2 = new String[]{""};
        Token token = this.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringArray2[0] = stringArray2[0] + " ";
            }
            if (token.kind == 0) {
                stringArray2[0] = stringArray2[0] + this.tokenImage[0];
                break;
            }
            stringArray2[0] = stringArray2[0] + this.add_escapes(token.image);
            token = token.next;
        }
        if (!stringArray2[0].equals("")) {
            string2 = string2 + Jacl2JythonMessages.getParameterResourceString("Cause_encountered_unexpected_token", stringArray2);
        }
        string2 = this.expectedTokenSequences.length == 1 ? string2 + this.eol + Jacl2JythonMessages.getParameterResourceString("Was_expecting", new String[]{string}) : string2 + this.eol + Jacl2JythonMessages.getParameterResourceString("Was_expecting_one_of", new String[]{this.eol + "    " + string});
        return string2;
    }

    protected String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

