/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ast.jacl2jython;

import java.io.IOException;
import java.io.InputStream;

public final class ASCII_CharStream {
    public static final boolean staticFlag = true;
    static int bufsize;
    static int available;
    static int tokenBegin;
    public static int bufpos;
    private static int[] bufline;
    private static int[] bufcolumn;
    private static int column;
    private static int line;
    private static boolean prevCharIsCR;
    private static boolean prevCharIsLF;
    private static InputStream inputStream;
    private static byte[] buffer;
    private static int maxNextCharInd;
    private static int inBuf;

    private static final void ExpandBuff(boolean bl) {
        byte[] byArray = new byte[bufsize + 2048];
        int[] nArray = new int[bufsize + 2048];
        int[] nArray2 = new int[bufsize + 2048];
        try {
            if (bl) {
                System.arraycopy(buffer, tokenBegin, byArray, 0, bufsize - tokenBegin);
                System.arraycopy(buffer, 0, byArray, bufsize - tokenBegin, bufpos);
                buffer = byArray;
                System.arraycopy(bufline, tokenBegin, nArray, 0, bufsize - tokenBegin);
                System.arraycopy(bufline, 0, nArray, bufsize - tokenBegin, bufpos);
                bufline = nArray;
                System.arraycopy(bufcolumn, tokenBegin, nArray2, 0, bufsize - tokenBegin);
                System.arraycopy(bufcolumn, 0, nArray2, bufsize - tokenBegin, bufpos);
                bufcolumn = nArray2;
                maxNextCharInd = bufpos += bufsize - tokenBegin;
            } else {
                System.arraycopy(buffer, tokenBegin, byArray, 0, bufsize - tokenBegin);
                buffer = byArray;
                System.arraycopy(bufline, tokenBegin, nArray, 0, bufsize - tokenBegin);
                bufline = nArray;
                System.arraycopy(bufcolumn, tokenBegin, nArray2, 0, bufsize - tokenBegin);
                bufcolumn = nArray2;
                maxNextCharInd = bufpos -= tokenBegin;
            }
        }
        catch (Throwable throwable) {
            throw new Error(throwable.getMessage());
        }
        available = bufsize += 2048;
        tokenBegin = 0;
    }

    private static final void FillBuff() throws IOException {
        if (maxNextCharInd == available) {
            if (available == bufsize) {
                if (tokenBegin > 2048) {
                    maxNextCharInd = 0;
                    bufpos = 0;
                    available = tokenBegin;
                } else if (tokenBegin < 0) {
                    maxNextCharInd = 0;
                    bufpos = 0;
                } else {
                    ASCII_CharStream.ExpandBuff(false);
                }
            } else if (available > tokenBegin) {
                available = bufsize;
            } else if (tokenBegin - available < 2048) {
                ASCII_CharStream.ExpandBuff(true);
            } else {
                available = tokenBegin;
            }
        }
        try {
            int n = inputStream.read(buffer, maxNextCharInd, available - maxNextCharInd);
            if (n == -1) {
                inputStream.close();
                throw new IOException();
            }
            maxNextCharInd += n;
            return;
        }
        catch (IOException iOException) {
            --bufpos;
            ASCII_CharStream.backup(0);
            if (tokenBegin == -1) {
                tokenBegin = bufpos;
            }
            throw iOException;
        }
    }

    public static final char BeginToken() throws IOException {
        tokenBegin = -1;
        char c = ASCII_CharStream.readChar();
        tokenBegin = bufpos;
        return c;
    }

    private static final void UpdateLineColumn(char c) {
        ++column;
        if (prevCharIsLF) {
            prevCharIsLF = false;
            column = 1;
            ++line;
        } else if (prevCharIsCR) {
            prevCharIsCR = false;
            if (c == '\n') {
                prevCharIsLF = true;
            } else {
                column = 1;
                ++line;
            }
        }
        switch (c) {
            case '\r': {
                prevCharIsCR = true;
                break;
            }
            case '\n': {
                prevCharIsLF = true;
                break;
            }
            case '\t': {
                --column;
                column += 8 - (column & 7);
                break;
            }
        }
        ASCII_CharStream.bufline[ASCII_CharStream.bufpos] = line;
        ASCII_CharStream.bufcolumn[ASCII_CharStream.bufpos] = column;
    }

    public static final char readChar() throws IOException {
        if (inBuf > 0) {
            --inBuf;
            return (char)(0xFF & buffer[bufpos == bufsize - 1 ? (bufpos = 0) : (bufpos = bufpos + 1)]);
        }
        if (++bufpos >= maxNextCharInd) {
            ASCII_CharStream.FillBuff();
        }
        char c = (char)(0xFF & buffer[bufpos]);
        ASCII_CharStream.UpdateLineColumn(c);
        return c;
    }

    public static final int getColumn() {
        return bufcolumn[bufpos];
    }

    public static final int getLine() {
        return bufline[bufpos];
    }

    public static final int getEndColumn() {
        return bufcolumn[bufpos];
    }

    public static final int getEndLine() {
        return bufline[bufpos];
    }

    public static final int getBeginColumn() {
        return bufcolumn[tokenBegin];
    }

    public static final int getBeginLine() {
        return bufline[tokenBegin];
    }

    public static final void backup(int n) {
        inBuf += n;
        if ((bufpos -= n) < 0) {
            bufpos += bufsize;
        }
    }

    public ASCII_CharStream(InputStream inputStream, int n, int n2, int n3) {
        if (ASCII_CharStream.inputStream != null) {
            throw new Error("\n   ERROR: Second call to the constructor of a static ASCII_CharStream.  You must\n       either use ReInit() or set the JavaCC option STATIC to false\n       during the generation of this class.");
        }
        ASCII_CharStream.inputStream = inputStream;
        line = n;
        column = n2 - 1;
        available = bufsize = n3;
        buffer = new byte[n3];
        bufline = new int[n3];
        bufcolumn = new int[n3];
    }

    public ASCII_CharStream(InputStream inputStream, int n, int n2) {
        this(inputStream, n, n2, 4096);
    }

    public static void ReInit(InputStream inputStream, int n, int n2, int n3) {
        ASCII_CharStream.inputStream = inputStream;
        line = n;
        column = n2 - 1;
        if (buffer == null || n3 != buffer.length) {
            available = bufsize = n3;
            buffer = new byte[n3];
            bufline = new int[n3];
            bufcolumn = new int[n3];
        }
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
        tokenBegin = 0;
        bufpos = -1;
    }

    public static void ReInit(InputStream inputStream, int n, int n2) {
        ASCII_CharStream.ReInit(inputStream, n, n2, 4096);
    }

    public static final String GetImage() {
        if (bufpos >= tokenBegin) {
            return new String(buffer, 0, tokenBegin, bufpos - tokenBegin + 1);
        }
        return new String(buffer, 0, tokenBegin, bufsize - tokenBegin) + new String(buffer, 0, 0, bufpos + 1);
    }

    public static final byte[] GetSuffix(int n) {
        byte[] byArray = new byte[n];
        if (bufpos + 1 >= n) {
            System.arraycopy(buffer, bufpos - n + 1, byArray, 0, n);
        } else {
            System.arraycopy(buffer, bufsize - (n - bufpos - 1), byArray, 0, n - bufpos - 1);
            System.arraycopy(buffer, 0, byArray, n - bufpos - 1, bufpos + 1);
        }
        return byArray;
    }

    public static void Done() {
        buffer = null;
        bufline = null;
        bufcolumn = null;
    }

    public static void adjustBeginLineColumn(int n, int n2) {
        int n3;
        int n4 = tokenBegin;
        int n5 = bufpos >= tokenBegin ? bufpos - tokenBegin + inBuf + 1 : bufsize - tokenBegin + bufpos + 1 + inBuf;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n5 && bufline[n6 = n4 % bufsize] == bufline[n7 = ++n4 % bufsize]; ++n3) {
            ASCII_CharStream.bufline[n6] = n;
            n8 = n9 + bufcolumn[n7] - bufcolumn[n6];
            ASCII_CharStream.bufcolumn[n6] = n2 + n9;
            n9 = n8;
        }
        if (n3 < n5) {
            ASCII_CharStream.bufline[n6] = n++;
            ASCII_CharStream.bufcolumn[n6] = n2 + n9;
            while (n3++ < n5) {
                n6 = n4 % bufsize;
                if (bufline[n6] != bufline[++n4 % bufsize]) {
                    ASCII_CharStream.bufline[n6] = n++;
                    continue;
                }
                ASCII_CharStream.bufline[n6] = n;
            }
        }
        line = bufline[n6];
        column = bufcolumn[n6];
    }

    static {
        bufpos = -1;
        column = 0;
        line = 1;
        prevCharIsCR = false;
        prevCharIsLF = false;
        maxNextCharInd = 0;
        inBuf = 0;
    }
}

