/*
 * @(#)DeleteOnExitHook.java	1.4 06/06/20
 *
 * Copyright 2004 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.io;

import java.util.*;
import java.io.File;

/**
 * This class holds a set of filenames to be deleted on VM exit through a shutdown hook.
 * A set is used both to prevent double-insertion of the same file as well as offer 
 * quick removal.
 */

class DeleteOnExitHook {
    private static DeleteOnExitHook instance = null;

    private static LinkedHashSet<String> files = new LinkedHashSet<String>();

    private static boolean shutDownInProgress = false; 	/*JSE-3333*/     //IBM-perf_FileIO
                                                                                //IBM-perf_FileIO
    static DeleteOnExitHook hook() {
	if (instance == null)
	    instance = new DeleteOnExitHook();

	return instance;
    }

    private DeleteOnExitHook() {}

    static void add(String file) {
	synchronized(files) {
	    if(shutDownInProgress)              /*JSE-3333*/                    //IBM-perf_FileIO
		throw new IllegalStateException("Shutdown in progress");

	    files.add(file);
	}
    }

    void run() {
	/*JSE-4074 :: Copy the content of the LinkedHashSet 'files' to the arraylist 'toBeDeleted'  //IBM-perf_FileIO
	 * before files.clear() is called                                       //IBM-perf_FileIO
	 */                                                                     //IBM-perf_FileIO
	ArrayList<String> toBeDeleted;	/*JSE-4074*/	              //IBM-perf_FileIO
	synchronized (files) {
	    toBeDeleted = new ArrayList<String>(files);	/*JSE-4074*/     //IBM-perf_FileIO
	    files.clear();                    /*JSE-3333*/                      //IBM-perf_FileIO
	    shutDownInProgress = true;        /*JSE-3333*/                      //IBM-perf_FileIO
	}

	                                                                        //IBM-perf_FileIO

	// reverse the list to maintain previous jdk deletion order.
	// Last in first deleted.
	Collections.reverse(toBeDeleted);
	for (String filename : toBeDeleted) {
	    (new File(filename)).delete();
	}
    }
}

//IBM-perf_FileIO
