/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XNodeInfo;

public class XMBeanInfo
extends JPanel {
    private static final Color lightYellow = new Color(255, 255, 128);
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private final String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Value", new Object[0])};
    private JTable infoTable = new JTable();
    private JTable descTable = new JTable();
    private JPanel infoBorderPanel = new JPanel(new BorderLayout());
    private JPanel descBorderPanel = new JPanel(new BorderLayout());
    private static MBeanInfoTableCellRenderer renderer = new MBeanInfoTableCellRenderer();
    private static TableCellEditor editor = new MBeanInfoTableCellEditor(new JTextField());

    public XMBeanInfo() {
        super(new GridLayout(2, 1));
        Utilities.setAccessibleName(this.infoTable, Resources.getText("MBeanInfo", new Object[0]));
        Utilities.setAccessibleDescription(this.infoTable, Resources.getText("MBeanInfo.description", new Object[0]));
        this.infoTable.setModel(new ReadOnlyDefaultTableModel());
        this.infoTable.setRowSelectionAllowed(false);
        this.infoTable.setColumnSelectionAllowed(false);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.infoTable.getModel()).setColumnIdentifiers(this.columnNames);
        this.infoTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.infoTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.infoTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.infoTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.infoTable.getColumnModel().getColumn(0).setCellEditor(editor);
        this.infoTable.getColumnModel().getColumn(1).setCellEditor(editor);
        this.infoTable.addKeyListener(new Utils.CopyKeyAdapter());
        this.infoTable.setAutoResizeMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.infoTable);
        Utilities.setAccessibleName(jScrollPane, Resources.getText("MBeanInfo", new Object[0]));
        Utilities.setAccessibleDescription(jScrollPane, Resources.getText("MBeanInfo.description", new Object[0]));
        Utilities.setAccessibleName(jScrollPane.getViewport(), Resources.getText("MBeanInfo", new Object[0]));
        Utilities.setAccessibleDescription(jScrollPane.getViewport(), Resources.getText("MBeanInfo.description", new Object[0]));
        this.infoBorderPanel.setBorder(BorderFactory.createTitledBorder("MBeanInfoPlaceHolder"));
        this.infoBorderPanel.add(jScrollPane);
        Utilities.setAccessibleName(this.infoBorderPanel, Resources.getText("MBeanInfo", new Object[0]));
        Utilities.setAccessibleDescription(this.infoBorderPanel, Resources.getText("MBeanInfo.description", new Object[0]));
        this.descTable.setModel(new ReadOnlyDefaultTableModel());
        Utilities.setAccessibleName(this.descTable, Resources.getText("MBeanDescriptor", new Object[0]));
        Utilities.setAccessibleDescription(this.descTable, Resources.getText("MBeanDescriptor.description", new Object[0]));
        this.descTable.setRowSelectionAllowed(false);
        this.descTable.setColumnSelectionAllowed(false);
        this.descTable.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.descTable.getModel()).setColumnIdentifiers(this.columnNames);
        this.descTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.descTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.descTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.descTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.descTable.getColumnModel().getColumn(0).setCellEditor(editor);
        this.descTable.getColumnModel().getColumn(1).setCellEditor(editor);
        this.descTable.addKeyListener(new Utils.CopyKeyAdapter());
        this.descTable.setAutoResizeMode(2);
        JScrollPane jScrollPane2 = new JScrollPane(this.descTable);
        Utilities.setAccessibleName(jScrollPane2, Resources.getText("MBeanDescriptor", new Object[0]));
        Utilities.setAccessibleDescription(jScrollPane2, Resources.getText("MBeanDescriptor.description", new Object[0]));
        Utilities.setAccessibleName(jScrollPane2.getViewport(), Resources.getText("MBeanDescriptor", new Object[0]));
        Utilities.setAccessibleDescription(jScrollPane2.getViewport(), Resources.getText("MBeanDescriptor.description", new Object[0]));
        this.descBorderPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Descriptor", new Object[0])));
        this.descBorderPanel.add(jScrollPane2);
        Utilities.setAccessibleName(this.descBorderPanel, Resources.getText("MBeanDescriptor", new Object[0]));
        Utilities.setAccessibleDescription(this.descBorderPanel, Resources.getText("MBeanDescriptor.description", new Object[0]));
        this.add(this.infoBorderPanel);
        this.add(this.descBorderPanel);
    }

    public void emptyInfoTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
    }

    public void emptyDescTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.descTable.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
    }

    private void addDescriptor(Descriptor descriptor, String string) {
        if (descriptor != null && descriptor.getFieldNames().length > 0) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.descTable.getModel();
            Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
            defaultTableModel.addRow(objectArray);
            for (String string2 : descriptor.getFieldNames()) {
                objectArray[0] = string2;
                Object object = descriptor.getFieldValue(string2);
                objectArray[1] = object instanceof boolean[] ? Arrays.toString((boolean[])object) : (object instanceof byte[] ? Arrays.toString((byte[])object) : (object instanceof char[] ? Arrays.toString((char[])object) : (object instanceof double[] ? Arrays.toString((double[])object) : (object instanceof float[] ? Arrays.toString((float[])object) : (object instanceof int[] ? Arrays.toString((int[])object) : (object instanceof long[] ? Arrays.toString((long[])object) : (object instanceof short[] ? Arrays.toString((short[])object) : (object instanceof Object[] ? Arrays.toString((Object[])object) : object))))))));
                defaultTableModel.addRow(objectArray);
            }
            defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
        }
    }

    public void addMBeanInfo(XMBean xMBean, MBeanInfo mBeanInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Resources.getText("MBeanInfo", new Object[0]));
        String string = Resources.getText("Info", new Object[0]) + ":";
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("ObjectName", new Object[0]);
        objectArray[1] = xMBean.getObjectName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("ClassName", new Object[0]);
        objectArray[1] = mBeanInfo.getClassName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Description", new Object[0]);
        objectArray[1] = mBeanInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanInfo.getDescriptor(), string);
        int n = 0;
        for (MBeanConstructorInfo mBeanConstructorInfo : mBeanInfo.getConstructors()) {
            this.addMBeanConstructorInfo(mBeanConstructorInfo, Resources.getText("Constructor", new Object[0]) + "-" + n + ":");
            int n2 = 0;
            for (MBeanParameterInfo mBeanParameterInfo : mBeanConstructorInfo.getSignature()) {
                this.addMBeanParameterInfo(mBeanParameterInfo, Resources.getText("Parameter", new Object[0]) + "-" + n + "-" + n2 + ":");
                ++n2;
            }
            ++n;
        }
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    public void addMBeanAttributeInfo(MBeanAttributeInfo mBeanAttributeInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Resources.getText("MBeanAttributeInfo", new Object[0]));
        String string = Resources.getText("Attribute", new Object[0]) + ":";
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Name", new Object[0]);
        objectArray[1] = mBeanAttributeInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Description", new Object[0]);
        objectArray[1] = mBeanAttributeInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Readable", new Object[0]);
        objectArray[1] = mBeanAttributeInfo.isReadable();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Writable", new Object[0]);
        objectArray[1] = mBeanAttributeInfo.isWritable();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Is", new Object[0]);
        objectArray[1] = mBeanAttributeInfo.isIs();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Type", new Object[0]);
        objectArray[1] = mBeanAttributeInfo.getType();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanAttributeInfo.getDescriptor(), string);
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    public void addMBeanOperationInfo(MBeanOperationInfo mBeanOperationInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Resources.getText("MBeanOperationInfo", new Object[0]));
        String string = Resources.getText("Operation", new Object[0]) + ":";
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Name", new Object[0]);
        objectArray[1] = mBeanOperationInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Description", new Object[0]);
        objectArray[1] = mBeanOperationInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Impact", new Object[0]);
        switch (mBeanOperationInfo.getImpact()) {
            case 0: {
                objectArray[1] = Resources.getText("INFO", new Object[0]);
                break;
            }
            case 1: {
                objectArray[1] = Resources.getText("ACTION", new Object[0]);
                break;
            }
            case 2: {
                objectArray[1] = Resources.getText("ACTION_INFO", new Object[0]);
                break;
            }
            case 3: {
                objectArray[1] = Resources.getText("UNKNOWN", new Object[0]);
            }
        }
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("ReturnType", new Object[0]);
        objectArray[1] = mBeanOperationInfo.getReturnType();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanOperationInfo.getDescriptor(), string);
        int n = 0;
        for (MBeanParameterInfo mBeanParameterInfo : mBeanOperationInfo.getSignature()) {
            this.addMBeanParameterInfo(mBeanParameterInfo, Resources.getText("Parameter", new Object[0]) + "-" + n++ + ":");
        }
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    public void addMBeanNotificationInfo(MBeanNotificationInfo mBeanNotificationInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Resources.getText("MBeanNotificationInfo", new Object[0]));
        String string = Resources.getText("Notification", new Object[0]) + ":";
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Name", new Object[0]);
        objectArray[1] = mBeanNotificationInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Description", new Object[0]);
        objectArray[1] = mBeanNotificationInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("NotifTypes", new Object[0]);
        objectArray[1] = Arrays.toString(mBeanNotificationInfo.getNotifTypes());
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanNotificationInfo.getDescriptor(), string);
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    private void addMBeanConstructorInfo(MBeanConstructorInfo mBeanConstructorInfo, String string) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Name", new Object[0]);
        objectArray[1] = mBeanConstructorInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Description", new Object[0]);
        objectArray[1] = mBeanConstructorInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanConstructorInfo.getDescriptor(), string);
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    private void addMBeanParameterInfo(MBeanParameterInfo mBeanParameterInfo, String string) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] objectArray = new Object[]{new TableRowDivider(string), new TableRowDivider("")};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Name", new Object[0]);
        objectArray[1] = mBeanParameterInfo.getName();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Description", new Object[0]);
        objectArray[1] = mBeanParameterInfo.getDescription();
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("Type", new Object[0]);
        objectArray[1] = mBeanParameterInfo.getType();
        defaultTableModel.addRow(objectArray);
        this.addDescriptor(mBeanParameterInfo.getDescriptor(), string);
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    public static void loadInfo(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        Serializable serializable;
        XNodeInfo xNodeInfo;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        MBeanInfo mBeanInfo;
        XMBean xMBean = (XMBean)((XNodeInfo)defaultMutableTreeNode.getUserObject()).getData();
        try {
            mBeanInfo = xMBean.getMBeanInfo();
        }
        catch (Exception exception) {
            if (JConsole.isDebug()) {
                exception.printStackTrace();
            }
            return;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        MBeanNotificationInfo[] mBeanNotificationInfoArray = mBeanInfo.getNotifications();
        if (mBeanAttributeInfoArray != null && mBeanAttributeInfoArray.length > 0) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            xNodeInfo = new XNodeInfo(XNodeInfo.Type.ATTRIBUTES, xMBean, Resources.getText("Attributes", new Object[0]), null);
            defaultMutableTreeNode2.setUserObject(xNodeInfo);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (MBeanFeatureInfo mBeanFeatureInfo : mBeanAttributeInfoArray) {
                serializable = new DefaultMutableTreeNode();
                object = new XNodeInfo(XNodeInfo.Type.ATTRIBUTE, new Object[]{xMBean, mBeanFeatureInfo}, mBeanFeatureInfo.getName(), null);
                ((DefaultMutableTreeNode)serializable).setUserObject(object);
                defaultMutableTreeNode2.add((MutableTreeNode)((Object)serializable));
            }
        }
        if (mBeanOperationInfoArray != null && mBeanOperationInfoArray.length > 0) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            xNodeInfo = new XNodeInfo(XNodeInfo.Type.OPERATIONS, xMBean, Resources.getText("Operations", new Object[0]), null);
            defaultMutableTreeNode2.setUserObject(xNodeInfo);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (MBeanFeatureInfo mBeanFeatureInfo : mBeanOperationInfoArray) {
                serializable = new StringBuilder();
                for (MBeanParameterInfo mBeanParameterInfo : ((MBeanOperationInfo)mBeanFeatureInfo).getSignature()) {
                    ((StringBuilder)serializable).append(mBeanParameterInfo.getType() + ",");
                }
                object = ((StringBuilder)serializable).toString();
                if (((String)object).length() > 0) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                String string = mBeanFeatureInfo.getName() + "(" + (String)object + ")";
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode();
                XNodeInfo xNodeInfo2 = new XNodeInfo(XNodeInfo.Type.OPERATION, new Object[]{xMBean, mBeanFeatureInfo}, mBeanFeatureInfo.getName(), string);
                defaultMutableTreeNode3.setUserObject(xNodeInfo2);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        }
        if (xMBean.isBroadcaster()) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            xNodeInfo = new XNodeInfo(XNodeInfo.Type.NOTIFICATIONS, xMBean, Resources.getText("Notifications", new Object[0]), null);
            defaultMutableTreeNode2.setUserObject(xNodeInfo);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (mBeanNotificationInfoArray != null && mBeanNotificationInfoArray.length > 0) {
                for (MBeanFeatureInfo mBeanFeatureInfo : mBeanNotificationInfoArray) {
                    serializable = new DefaultMutableTreeNode();
                    object = new XNodeInfo(XNodeInfo.Type.NOTIFICATION, mBeanFeatureInfo, mBeanFeatureInfo.getName(), null);
                    ((DefaultMutableTreeNode)serializable).setUserObject(object);
                    defaultMutableTreeNode2.add((MutableTreeNode)((Object)serializable));
                }
            }
        }
    }

    private static class MBeanInfoTableCellEditor
    extends Utils.ReadOnlyTableCellEditor {
        public MBeanInfoTableCellEditor(JTextField jTextField) {
            super(jTextField);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (object instanceof TableRowDivider) {
                JLabel jLabel = new JLabel(object.toString());
                jLabel.setBackground(Utilities.ensureContrast(lightYellow, jLabel.getForeground()));
                jLabel.setOpaque(true);
                return jLabel;
            }
            return component;
        }
    }

    private static class MBeanInfoTableCellRenderer
    extends DefaultTableCellRenderer {
        private MBeanInfoTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof TableRowDivider) {
                JLabel jLabel = new JLabel(object.toString());
                jLabel.setBackground(Utilities.ensureContrast(lightYellow, jLabel.getForeground()));
                jLabel.setOpaque(true);
                return jLabel;
            }
            return component;
        }
    }

    private static class TableRowDivider {
        private String tableRowDividerText;

        public TableRowDivider(String string) {
            this.tableRowDividerText = string;
        }

        public String toString() {
            return this.tableRowDividerText;
        }
    }

    private static class ReadOnlyDefaultTableModel
    extends DefaultTableModel {
        private ReadOnlyDefaultTableModel() {
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

