/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import java.io.File;

public class FileName {
    private String directory;
    private String name;
    private String fileExtension;

    public FileName(String fullFileName) {
        this.splitFileName(fullFileName);
    }

    public FileName(FileName fileName) {
        this.directory = fileName.directory;
        this.name = fileName.name;
        this.fileExtension = fileName.fileExtension;
    }

    public FileName(String fullFileName, String defaultExtension) {
        this(fullFileName);
        if (this.fileExtension.equals("")) {
            this.fileExtension = defaultExtension;
        }
    }

    public FileName(File pathname) {
        if (pathname.isDirectory()) {
            this.directory = pathname.getAbsolutePath();
            this.name = "";
            this.fileExtension = "";
        } else {
            this.splitFileName(pathname.getAbsolutePath());
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getName() {
        return this.name;
    }

    public String getFile() {
        return this.getName() + this.getFileExtension();
    }

    public void setExtension(String newExtension) {
        this.fileExtension = newExtension;
    }

    public FileName substituteExtension(String newExtension) {
        FileName returnVal = new FileName(this.toString());
        returnVal.fileExtension = newExtension;
        return returnVal;
    }

    private void splitFileName(String fileName) {
        File tempFile = new File(fileName);
        String wholeFileName = tempFile.getName();
        String absolutePath = tempFile.getAbsolutePath();
        this.directory = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
        if (wholeFileName.lastIndexOf(".") == -1) {
            this.name = wholeFileName;
            this.fileExtension = "";
        } else {
            this.name = wholeFileName.substring(0, wholeFileName.lastIndexOf("."));
            this.fileExtension = wholeFileName.substring(wholeFileName.lastIndexOf("."), wholeFileName.length());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof FileName) {
            return ((FileName)o).toString().equals(this.toString());
        }
        if (o instanceof String) {
            return ((String)o).equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.directory + File.separator + this.name + this.fileExtension;
    }

    public FileName changeExtension(String extension) {
        FileName newFileName = new FileName(this);
        newFileName.fileExtension = extension;
        return newFileName;
    }
}

