/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractEntry;
import com.ibm.gsk.ikeyman.keystore.entry.ByteArray;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.X509Version;
import com.ibm.gsk.ikeyman.keystore.ext.Details;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.io.File;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;

class CertificateItemImpl
extends AbstractEntry
implements CertificateItem {
    private Integer keySize = null;
    private DisplayItemFactory.TreeDisplayItem version = null;
    private ByteArray serialNumber = null;
    private DisplayItemFactory.DNItem issuerDN = null;
    private DisplayItemFactory.DNItem subjectDN = null;
    private DisplayItemFactory.ValidityItem validity = null;
    private DisplayItemFactory.DisplayItem fingerprint = null;
    private DisplayItemFactory.AlgorithmItem publicKeyAlgorithm = null;
    private List<DisplayItemFactory.ExtensionItem> extensions = null;
    private DisplayItemFactory.AlgorithmItem signatureAlgorithm = null;
    private ByteArray signature = null;
    private DisplayItemFactory.SanItem san = null;
    protected X509Certificate cert;

    public CertificateItemImpl(String label, X509Certificate cert) throws KeyManagerException {
        super(label);
        this.cert = cert;
        this.populateData();
    }

    private void populateData() throws KeyManagerException {
        try {
            this.validity = DisplayItemFactory.getValidityItem(this.cert.getNotBefore(), this.cert.getNotAfter());
            this.version = X509Version.getVersion(this.cert.getVersion());
            this.extensions = DisplayItemFactory.getExtensionItems(this.cert);
            this.fingerprint = DisplayItemFactory.getFinterprintItem(this.cert);
            this.issuerDN = DisplayItemFactory.getDNItem(this.cert.getIssuerX500Principal());
            this.keySize = CertificateItemImpl.computeKeySize(this.getPublicKey());
            this.publicKeyAlgorithm = DisplayItemFactory.getAlgorithmItem(this.getPublicKey());
            this.serialNumber = new ByteArray(this.cert.getSerialNumber().toByteArray());
            this.signature = new ByteArray(this.cert.getSignature());
            this.signatureAlgorithm = DisplayItemFactory.getAlgorithmItem(this.cert.getSigAlgOID(), this.cert.getSigAlgParams());
            this.subjectDN = DisplayItemFactory.getDNItem(this.cert.getSubjectX500Principal());
        }
        catch (KeyManagerException e) {
            e.addDetail(this.getLabel());
            throw e;
        }
        try {
            this.san = DisplayItemFactory.getSanItem(this.cert.getSubjectAlternativeNames());
        }
        catch (CertificateParsingException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_SAN_IN_CERT, (Throwable)e, this.getLabel());
        }
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public DisplayItemFactory.DisplayItem getFingerprint() {
        return this.fingerprint;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public DisplayItemFactory.AlgorithmItem getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DisplayItemFactory.DNItem getSubjectDN() {
        return this.subjectDN;
    }

    public DisplayItemFactory.DNItem getIssuerDN() {
        return this.issuerDN;
    }

    public DisplayItemFactory.ValidityItem getValidity() {
        return this.validity;
    }

    private static String getProvider() {
        return KeymanUtil.getJCEProviderName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.getLabel().equals((String)obj);
        }
        if (obj instanceof CertificateItemImpl) {
            return this.getLabel().equals(((CertificateItemImpl)obj).getLabel());
        }
        return super.equals(obj);
    }

    private static int computeKeySize(PublicKey key) {
        int kSize = 0;
        kSize = key instanceof RSAPublicKey ? ((RSAPublicKey)key).getModulus().bitLength() : ((DSAPublicKey)key).getY().bitLength();
        if (kSize % 2 != 0) {
            ++kSize;
        }
        return kSize;
    }

    public void extract(String targetFile, CertificateWriter.OutputMode mode) throws KeyManagerException {
        CertificateWriter writer = new CertificateWriter(this.cert, mode);
        writer.write(new File(targetFile));
    }

    public DisplayItemFactory.SanItem getSan() {
        return this.san;
    }

    public boolean isTrusted() {
        return true;
    }

    private String trustString() {
        return this.isTrusted() ? Messages.getString("Label.Enabled") : Messages.getString("Label.Disabled");
    }

    public String toLongString() {
        return Messages.getString("Label.Label") + " " + this.getLabel() + "\n" + Messages.getString("Label.KeySize") + KeymanUtil.getLocalisedColon() + " " + this.keySize + "\n" + Messages.getString("Label.Version") + KeymanUtil.getLocalisedColon() + " " + this.version.toString() + "\n" + Messages.getString("Label.SerialNumber") + KeymanUtil.getLocalisedColon() + " " + this.serialNumber.toString() + "\n" + Messages.getString("Label.IssuedBy") + " " + this.issuerDN.toString() + "\n" + Messages.getString("Label.Subject") + KeymanUtil.getLocalisedColon() + " " + this.subjectDN.toString() + "\n" + Messages.getString("Label.Valid") + KeymanUtil.getLocalisedColon() + " " + this.validity.toString() + "\n" + Messages.getString("Label.Fingerprint") + " " + this.fingerprint + "\n" + Messages.getString("Label.SigAlg") + KeymanUtil.getLocalisedColon() + " " + this.signatureAlgorithm.toString() + "\n" + Messages.getString("Label.TrustStatus") + KeymanUtil.getLocalisedColon() + " " + this.trustString() + "\n";
    }

    public KeymanTree toTree() {
        KeymanTree tree = new KeymanTree(KeymanTree.newNode(this.getLabel()));
        KeymanTree.KeymanTreeNode rootNode = (KeymanTree.KeymanTreeNode)tree.getRoot();
        KeymanTree.KeymanTreeNode certNode = rootNode.addChild(KeymanTree.newNode(Messages.getString("Label.Certificate")));
        KeymanTree.KeymanTreeNode tbsCertNode = certNode.addChild(KeymanTree.newNode(Messages.getString("Label.TBSCertificate")));
        tbsCertNode.addChildren(this.version.getTreeNodes());
        tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.SerialNumber"), this.serialNumber.toString()));
        KeymanTree.KeymanTreeNode issuerNode = tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.Issuer")));
        issuerNode.addChildren(this.issuerDN.getTreeNodes());
        tbsCertNode.addChildren(this.getValidity().getTreeNodes());
        KeymanTree.KeymanTreeNode subjectNode = tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.Subject")));
        subjectNode.addChildren(this.subjectDN.getTreeNodes());
        KeymanTree.KeymanTreeNode spkiNode = tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKeyInfo")));
        KeymanTree.KeymanTreeNode algorithmNode = spkiNode.addChild(KeymanTree.newNode(Messages.getString("Label.Algorithm")));
        algorithmNode.addChildren(this.publicKeyAlgorithm.getTreeNodes());
        spkiNode.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKey"), new ByteArray(this.getPublicKey().getEncoded()).toString()));
        if (this.extensions.size() > 0) {
            KeymanTree.KeymanTreeNode extensionsNode = tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.Extensions")));
            for (DisplayItemFactory.ExtensionItem extension : this.extensions) {
                extensionsNode.addChildren(extension.getTreeNodes());
            }
        }
        KeymanTree.KeymanTreeNode saNode = certNode.addChild(KeymanTree.newNode(Messages.getString("Label.SigAlg")));
        saNode.addChildren(this.signatureAlgorithm.getTreeNodes());
        certNode.addChild(KeymanTree.newNode(Messages.getString("Label.SigVal"), this.signature.toString()));
        return tree;
    }

    public KeyStore.Entry toKeyStoreEntry() {
        return new KeyStore.TrustedCertificateEntry(this.getCert());
    }

    public String get(Details.DetailIdentifier id) throws KeyManagerException {
        switch (id) {
            case Fingerprint: {
                return ((Object)this.getFingerprint()).toString();
            }
            case IssuedBy: {
                return this.issuerDN.toString();
            }
            case KeySize: {
                return this.keySize + "";
            }
            case SerialNumber: {
                return this.serialNumber.toString();
            }
            case SignatureAlgorithm: {
                return this.signatureAlgorithm.toString();
            }
            case Subject: {
                return this.subjectDN.toString();
            }
            case TrustStatus: {
                return this.isTrusted() + "";
            }
            case Valid: {
                return this.validity.toString();
            }
            case Version: {
                return this.version.toString();
            }
            case EmailAddress: {
                return this.san.getEmailAddress();
            }
            case DnsName: {
                return this.san.getDnsName();
            }
            case IpAddress: {
                return this.san.getIpAddress();
            }
        }
        return super.get(id);
    }

    public boolean isValid() {
        return !this.validity.isExpired();
    }
}

