/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;

class ByteArray {
    private byte[] data;

    public ByteArray(byte[] data) {
        this.data = data;
    }

    public String getHexDump(String indentation) {
        String hexString = indentation;
        if (this.data != null && this.data.length > 0) {
            for (int i = 0; i < this.data.length; ++i) {
                int integerValue;
                if (i % 16 == 0) {
                    if (i > 0 && i < this.data.length) {
                        hexString = hexString + "\n" + indentation;
                    }
                } else {
                    hexString = hexString + " ";
                }
                if ((integerValue = this.data[i] & 0xFF) < 16) {
                    hexString = hexString + "0";
                }
                hexString = hexString + Integer.toHexString(integerValue).toUpperCase();
            }
        } else {
            return Messages.getString("Label.Null");
        }
        return hexString;
    }

    public String getHexDumpWithASCII(String indentation) {
        String concatenatedString = new String("");
        int HEX_DUMP_WIDTH = 16;
        if (this.data != null && this.data.length > 0) {
            int byteSectionLength;
            for (int i = 0; i < this.data.length; i += byteSectionLength) {
                int j;
                byteSectionLength = i + 16 <= this.data.length ? 16 : this.data.length % 16;
                byte[] byteSection = new byte[byteSectionLength];
                String asciiString = "";
                for (j = 0; j < byteSection.length; ++j) {
                    byteSection[j] = this.data[i + j];
                    asciiString = byteSection[j] < 0 || Character.getType((char)byteSection[j]) == 15 ? asciiString + "." : asciiString + (char)byteSection[j];
                }
                String hexString = this.getHexDump(indentation);
                concatenatedString = concatenatedString + hexString;
                if (byteSection.length % 16 != 0) {
                    for (j = 0; j < 16 - byteSection.length % 16; ++j) {
                        concatenatedString = concatenatedString + "   ";
                    }
                }
                concatenatedString = concatenatedString + "    " + asciiString;
                if (i + byteSectionLength >= this.data.length) continue;
                concatenatedString = concatenatedString + "\n";
            }
        } else {
            return Messages.getString("Label.Null");
        }
        return concatenatedString;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentation) {
        return this.getHexDump(KeymanUtil.getIndentedString(indentation));
    }
}

