/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;

public class SecretKeyWriter {
    private OutputStream outputStream;

    public SecretKeyWriter(OutputStream out) {
        this.outputStream = out;
    }

    public void write(String alias, String algorithm, byte[] encryptedKey) throws IOException {
        DerOutputStream derData = new DerOutputStream();
        derData.putGeneralString(alias);
        derData.putGeneralString(algorithm);
        derData.putOctetString(encryptedKey);
        int len = derData.toByteArray().length + 1;
        byte tag = DerValue.createTag((byte)-128, (boolean)true, (byte)0);
        this.outputStream.write(SecretKeyWriter.toByte4FromInt(len));
        this.outputStream.write(tag);
        this.outputStream.write(derData.toByteArray());
    }

    private static byte[] toByte4FromInt(int length) {
        return new byte[]{(byte)(length >> 24), (byte)(length >> 16), (byte)(length >> 8), (byte)length};
    }
}

