/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.command.ParserFactory;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.panels.FileNameEnum;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.misc.BASE64Encoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class CertificateWriter {
    public static final String BEGIN_CERT_TAG = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT_TAG = "-----END CERTIFICATE-----";
    private byte[] certData;
    private OutputMode mode;

    public CertificateWriter(X509Certificate cert, OutputMode mode) throws KeyManagerException {
        try {
            this.certData = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)e);
        }
        this.mode = mode;
    }

    public void write(File outFile) throws KeyManagerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(outFile);
        }
        catch (SecurityException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_WRITE_PERMISSION, (Throwable)e, outFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_FILE_CREATION_ERROR, (Throwable)e, outFile.getAbsolutePath());
        }
        try {
            switch (this.mode) {
                case BinaryDER: {
                    this.writeBinary(fout);
                    break;
                }
                case Base64EncodedAscii: {
                    this.writeASCII(fout);
                }
            }
        }
        catch (KeyManagerException e) {
            if (outFile.exists()) {
                outFile.delete();
            }
            e.addDetail(outFile.getAbsolutePath());
            throw e;
        }
    }

    private void writeBinary(FileOutputStream outStream) throws KeyManagerException {
        try {
            outStream.write(this.certData);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_STREAM_WRITE_ERROR, (Throwable)e);
        }
        try {
            outStream.close();
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_STREAM_CLOSE_ERROR, (Throwable)e);
        }
    }

    private void writeASCII(FileOutputStream outStream) throws KeyManagerException {
        PrintStream pout = new PrintStream(outStream);
        BASE64Encoder encoder = new BASE64Encoder();
        pout.println(BEGIN_CERT_TAG);
        try {
            encoder.encodeBuffer(this.certData, (OutputStream)pout);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_STREAM_WRITE_ERROR, (Throwable)e);
        }
        pout.println(END_CERT_TAG);
        pout.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputMode implements FileNameEnum
    {
        Base64EncodedAscii,
        BinaryDER;


        public String toString() {
            switch (this) {
                case Base64EncodedAscii: {
                    return Messages.getString("Label.Base64ASCII");
                }
                case BinaryDER: {
                    return Messages.getString("Label.BinaryDER");
                }
            }
            return "";
        }

        @Override
        public String getDefaultFileName() {
            switch (this) {
                case Base64EncodedAscii: {
                    return KeymanSettings.Setting.DefaultCertificateNameArm.getString();
                }
                case BinaryDER: {
                    return KeymanSettings.Setting.DefaultCertificateNameDer.getString();
                }
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class OutputModeParser
        implements ParserFactory.ParserDelegate<OutputMode> {
            private static final Map<String, OutputMode> parseMap = new TreeMap<String, OutputMode>(ComparatorFactory.newIgnoreCaseStringComparator());

            @Override
            public OutputMode parse(String value) throws KeyManagerException {
                if (parseMap.containsKey(value)) {
                    return parseMap.get(value);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_OUTPUT_MODE, value, this.getValues());
            }

            private String getValues() {
                return parseMap.keySet().toString();
            }

            @Override
            public Collection<? extends String> getValidValues() {
                return parseMap.keySet();
            }

            static {
                parseMap.put("binary", BinaryDER);
                parseMap.put("ascii", Base64EncodedAscii);
            }
        }
    }
}

