/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicRadio;
import com.ibm.gsk.ikeyman.gui.panels.InputPanelFactory;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SecretKeyDataPanel
extends InputPanelFactory.InputJPanel {
    private static final long serialVersionUID = 1L;
    private JLabel algorithmLabel = null;
    private JComboBox algorithmCombo = null;
    private JLabel keySizeLbl = null;
    private JComboBox keySizeCombo = null;
    private JPanel jPanel = null;
    private JRadioButton aliasRadio = null;
    private JRadioButton aliasRangeRadio = null;
    private JTextField aliasField = null;
    private ButtonGroup aliasGroup = new ButtonGroup();
    private JPanel jPanel2 = null;
    private KeyStoreInfo database;

    protected SecretKeyDataPanel(KeyStoreInfo database) {
        this.database = database;
        this.initialize();
    }

    private void initialize() {
        this.setSize(302, 307);
        this.setLayout(new GridBagLayout());
        this.addComponent(this, this.getJPanel2(), 0, 0, new Insets(0, 5, 5, 5), 2, 10, 2, 1.0);
        this.addComponent(this, this.getJPanel(), 0, 1, new Insets(0, 5, 5, 5), 2, 10, 2, 1.0);
        this.updateKeySizeCombo();
    }

    private JComboBox getAlgorithmCombo() {
        if (this.algorithmCombo == null) {
            this.algorithmCombo = new JComboBox<KeyCreatorFactory.SecretKeyTypes>(KeyCreatorFactory.SecretKeyTypes.values());
            this.algorithmCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SecretKeyDataPanel.this.algorithmComboHandler(e);
                }
            });
            this.algorithmCombo.getAccessibleContext().setAccessibleName(Messages.getString("Label.Algorithm"));
            this.algorithmCombo.setName(ControlNames.SecretKeyDataPanelAlgorithmCombo.toString());
            this.algorithmCombo.setToolTipText(Messages.getString("Tooltip.Algorithm"));
        }
        return this.algorithmCombo;
    }

    private void algorithmComboHandler(ItemEvent e) {
        if (e.getSource().equals(this.algorithmCombo)) {
            this.updateKeySizeCombo();
        }
    }

    private void updateKeySizeCombo() {
        Integer[] keySizes = this.database.getKeyCreator().getKeySizes((KeyCreatorFactory.SecretKeyTypes)((Object)this.algorithmCombo.getSelectedItem()));
        this.keySizeCombo.setModel(new DefaultComboBoxModel<Integer>(keySizes));
    }

    private JComboBox getKeySizeCombo() {
        if (this.keySizeCombo == null) {
            this.keySizeCombo = new JComboBox();
            this.keySizeCombo.setToolTipText(Messages.getString("Tooltip.SecretKeySize"));
            this.keySizeCombo.getAccessibleContext().setAccessibleName(Messages.getString("Label.KeySize"));
            this.keySizeCombo.setName(ControlNames.SecretKeyDataPanelKeySizeCombo.toString());
        }
        return this.keySizeCombo;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("Label.Alias"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jPanel.setName(ControlNames.SecretKeyDataPanelAliasBorder.toString());
            this.addComponent(this.jPanel, this.getAliasRadio(), 0, 0, new Insets(0, 0, 0, 0), 1, 17, 0);
            this.addComponent(this.jPanel, this.getAliasRangeRadio(), 0, 1, new Insets(0, 0, 0, 0), 1, 17, 0);
            this.addComponent(this.jPanel, this.getAliasField(), 0, 2, new Insets(5, 10, 5, 10), 1, 17, 2, 1.0);
        }
        return this.jPanel;
    }

    private JRadioButton getAliasRadio() {
        if (this.aliasRadio == null) {
            this.aliasRadio = new MnemonicRadio();
            this.aliasRadio.setText(Messages.getStringWithMnemonics("Label.Alias"));
            this.aliasRadio.setToolTipText(Messages.getString("Tooltip.Alias"));
            this.aliasRadio.setSelected(true);
            this.aliasRadio.setName(ControlNames.SecretKeyDataPanelAliasRadio.toString());
            this.aliasGroup.add(this.aliasRadio);
        }
        return this.aliasRadio;
    }

    private JRadioButton getAliasRangeRadio() {
        if (this.aliasRangeRadio == null) {
            this.aliasRangeRadio = new MnemonicRadio();
            this.aliasRangeRadio.setText(Messages.getStringWithMnemonics("Label.AliasRange"));
            this.aliasRangeRadio.setToolTipText(Messages.getString("Tooltip.AliasRange"));
            this.aliasRangeRadio.setName(ControlNames.SecretKeyDataPanelAliasRangeRadio.toString());
            this.aliasGroup.add(this.aliasRangeRadio);
        }
        return this.aliasRangeRadio;
    }

    private JTextField getAliasField() {
        if (this.aliasField == null) {
            this.aliasField = new JTextField();
            this.aliasField.setColumns(25);
            this.aliasField.setToolTipText(Messages.getString("Tooltip.AliasField"));
            this.aliasField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Alias"));
            this.aliasField.setName(ControlNames.SecretKeyDataPanelAliasField.toString());
        }
        return this.aliasField;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.keySizeLbl = new MnemonicLabel();
            this.keySizeLbl.setText(Messages.getStringWithMnemonics("Label.KeySize"));
            this.keySizeLbl.setName(ControlNames.SecretKeyDataPanelKeySizeLabel.toString());
            this.algorithmLabel = new MnemonicLabel();
            this.algorithmLabel.setText(Messages.getStringWithMnemonics("Label.Algorithm"));
            this.algorithmLabel.setName(ControlNames.SecretKeyDataPanelAlgorithmLabel.toString());
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("Label.KeyType"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jPanel2.setName(ControlNames.SecretKeyDataPanelKeyTypeBorder.toString());
            this.addComponent(this.jPanel2, this.algorithmLabel, 0, 0, new Insets(0, 5, 0, 0), 1, 17, 0);
            this.addComponent(this.jPanel2, this.getAlgorithmCombo(), 1, 0, new Insets(0, 50, 5, 10), 1, 17, 2, 1.0);
            this.addComponent(this.jPanel2, this.keySizeLbl, 0, 1, new Insets(0, 5, 0, 0), 1, 17, 0);
            this.addComponent(this.jPanel2, this.getKeySizeCombo(), 1, 1, new Insets(0, 50, 5, 10), 1, 17, 2, 1.0);
            this.keySizeLbl.setLabelFor(this.getKeySizeCombo());
            this.algorithmLabel.setLabelFor(this.getAlgorithmCombo());
        }
        return this.jPanel2;
    }

    public void getParameters(ParameterMap map) throws KeyManagerException {
        map.put(Constants.Parameter.KeyAlgorithm, this.algorithmCombo.getSelectedItem().toString());
        map.put(Constants.Parameter.KeySize, this.keySizeCombo.getSelectedItem());
        if (this.aliasRadio.isSelected()) {
            map.put(Constants.Parameter.Label, this.aliasField.getText());
            map.remove(Constants.Parameter.LabelRange);
        } else {
            map.put(Constants.Parameter.LabelRange, this.aliasField.getText());
            map.remove(Constants.Parameter.Label);
        }
    }

    public boolean isValidInput(StringBuffer errorMessage) {
        if (SecretKeyDataPanel.isEmpty(this.aliasField)) {
            errorMessage.append(MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.AliasField")));
            return false;
        }
        return true;
    }

    private static boolean isEmpty(JTextField field) {
        return field != null && field.getText().trim().equals("");
    }

    public void resetFields() {
        this.algorithmCombo.setSelectedIndex(0);
        this.keySizeCombo.setSelectedIndex(0);
        this.aliasRadio.setSelected(true);
        this.aliasField.setText("");
    }
}

