/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMap {
    private Constants.CommandType type;
    private Map<Constants.Parameter, Object> values = new HashMap<Constants.Parameter, Object>();
    private List<Constants.Option> options = new ArrayList<Constants.Option>();
    private DatabaseDescriptorFactory.DatabaseDescriptor sourceDescriptor = null;
    private DatabaseDescriptorFactory.DatabaseDescriptor targetDescriptor = null;

    public ParameterMap(Constants.CommandType type) {
        Debug.entering(type);
        this.type = type;
        Debug.exiting();
    }

    public ParameterMap() {
        Debug.entering();
        Debug.exiting();
    }

    public final void put(Constants.Parameter param, Object value) throws KeyManagerException {
        Debug.entering(param, value);
        this.values.put(param, param.validate(value));
        Debug.exiting();
    }

    public void put(Constants.CommandType type) {
        Debug.entering(type);
        this.type = type;
        Debug.exiting();
    }

    public void put(Constants.Option opt) {
        Debug.entering(new Object[]{opt});
        this.options.add(opt);
        Debug.exiting();
    }

    public void setSourceDescriptor(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) {
        Debug.entering(descriptor);
        this.sourceDescriptor = descriptor;
        Debug.exiting();
    }

    public void setTargetDescriptor(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) {
        Debug.entering(descriptor);
        this.targetDescriptor = descriptor;
        Debug.exiting();
    }

    public Constants.CommandType getCommandType() {
        return this.type;
    }

    public Set<Constants.Parameter> getParameters() {
        return this.values.keySet();
    }

    public CommandParameters getCommandParameters() {
        return new CommandParameters(this.values, this.sourceDescriptor, this.targetDescriptor);
    }

    public boolean containsKey(Constants.Parameter param) {
        Debug.entering(param);
        boolean returnVal = this.values.containsKey(param);
        Debug.exiting(returnVal);
        return returnVal;
    }

    public boolean containsOption(Constants.Option opt) {
        Debug.entering(new Object[]{opt});
        boolean returnVal = this.options.contains((Object)opt);
        Debug.exiting(returnVal);
        return returnVal;
    }

    public Object get(Constants.Parameter param) {
        return this.values.get(param);
    }

    public void putAll(ParameterMap params) {
        Debug.entering(params);
        this.values.putAll(params.values);
        if (params.sourceDescriptor != null) {
            this.sourceDescriptor = params.sourceDescriptor;
        }
        if (params.targetDescriptor != null) {
            this.targetDescriptor = params.targetDescriptor;
        }
        if (params.type != null) {
            this.type = params.type;
        }
        Debug.exiting();
    }

    public void remove(Constants.Parameter param) {
        Debug.entering(param);
        this.values.remove(param);
        Debug.exiting();
    }
}

