/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadRecordFlagException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.Buffer;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BufferFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.ByteSequenceInputStream;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.ByteSequenceInputStreamFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequence;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequenceFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RecordFlag;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncoding;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncodingFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.io.InputStream;

final class RequestRecordFactory {
    private RequestRecordFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static RequestRecord newRequestRecord(InputStream in, int length) throws NullPointerException, IllegalArgumentException, BadRecordFlagException, IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        ByteSequenceInputStream bsis = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        ByteSequence s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        RecordFlag recordFlag = RecordFlag.recordFlagFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(s));
        if (recordFlag == null) {
            throw new BadRecordFlagException();
        }
        s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence recordId = IntableByteSequenceFactory.newIntableByteSequence(s);
        RequestRecordEncoding encoding = RequestRecordEncodingFactory.newRequestRecordEncoding(BufferFactory.newBuffer(in));
        if (encoding == null) {
            return null;
        }
        Buffer label = BufferFactory.newBuffer(in);
        if (label == null) {
            return null;
        }
        Buffer subjectPublicKeyInfoHash = BufferFactory.newBuffer(in);
        if (subjectPublicKeyInfoHash == null) {
            return null;
        }
        int l = recordFlag.length() + recordId.length() + encoding.length() + label.length() + subjectPublicKeyInfoHash.length();
        int len = length - l;
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        in.skip(len);
        return new RequestRecordImpl(recordFlag, recordId, encoding, label, subjectPublicKeyInfoHash, len);
    }

    private static final class RequestRecordImpl
    implements RequestRecord {
        private final RecordFlag recordFlag;
        private final IntableByteSequence recordId;
        private final RequestRecordEncoding encoding;
        private final Buffer label;
        private final Buffer subjectPublicKeyInfoHash;
        private final ByteSequence sequence;

        RequestRecordImpl(RecordFlag recordFlag, IntableByteSequence recordId, RequestRecordEncoding encoding, Buffer label, Buffer subjectPublicKeyInfoHash, int length) {
            this.recordFlag = recordFlag;
            this.recordId = recordId;
            this.encoding = encoding;
            this.label = label;
            this.subjectPublicKeyInfoHash = subjectPublicKeyInfoHash;
            ByteSequence s = recordFlag.append(recordId).append(encoding).append(label).append(subjectPublicKeyInfoHash);
            this.sequence = length == 0 ? s : s.append(ByteSequenceFactory.newConstantByteSequence((byte)0, length));
        }

        public RecordFlag getRecordFlag() {
            return this.recordFlag;
        }

        public IntableByteSequence getRecordId() {
            return this.recordId;
        }

        public RequestRecordEncoding getEncoding() {
            return this.encoding;
        }

        public Buffer getLabel() {
            return this.label;
        }

        public Buffer getSubjectPublicKeyInfoHash() {
            return this.subjectPublicKeyInfoHash;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index);
        }

        public int length() {
            return this.sequence.length();
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return this.sequence.append(sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.sequence.length() || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.getSubSequence(fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return this.sequence.indexOf(b);
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.indexOf(position, b);
        }

        public int lastIndexOf(byte b) {
            return this.sequence.lastIndexOf(b);
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.lastIndexOf(position, b);
        }

        public boolean isEmpty() {
            return this.sequence.isEmpty();
        }

        public InputStream getInputStream() {
            return this.sequence.getInputStream();
        }

        public ByteSequenceIterator getIterator() {
            return this.sequence.getIterator();
        }

        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.getIterator(position);
        }

        public String toBinaryString() {
            return this.sequence.toBinaryString();
        }

        public String toOctalString() {
            return this.sequence.toOctalString();
        }

        public String toHexString() {
            return this.sequence.toHexString();
        }

        public String toString() {
            return ((Object)this.sequence).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                byte e2;
                byte e1 = it1.getNextByte();
                if (e1 == (e2 = it2.getNextByte())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ((Object)this.sequence).hashCode();
        }
    }
}

