/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadFileTypeException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadMagicNumberException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadRecordFlagException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadVersionNumberException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeaderFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordFactory;
import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.SequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

final class RequestDatabaseFactory {
    private RequestDatabaseFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static RequestDatabase newRequestDatabase(InputStream in) throws NullPointerException, BadMagicNumberException, BadVersionNumberException, BadFileTypeException, BadRecordFlagException, IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        FileHeader header = FileHeaderFactory.newFileHeader(in);
        if (header == null) {
            return null;
        }
        LinkedList<RequestRecord> records = new LinkedList<RequestRecord>();
        int numberRecords = header.getRecordsAllocated().toInt();
        for (int i = 0; i < numberRecords; ++i) {
            RequestRecord record = RequestRecordFactory.newRequestRecord(in, header.getFixedRecordLength().toInt());
            if (record == null) {
                return null;
            }
            records.add(record);
        }
        return new RequestDatabaseImpl(header, SequenceFactory.newSequence(records));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RequestDatabaseImpl
    implements RequestDatabase {
        private final FileHeader header;
        private final Sequence<RequestRecord> records;
        private final ByteSequence sequence;

        RequestDatabaseImpl(FileHeader header, Sequence<RequestRecord> records) {
            this.header = header;
            this.records = records;
            ByteSequence s = header;
            for (RequestRecord record : records) {
                s = s.append(record);
            }
            this.sequence = s;
        }

        @Override
        public FileHeader getHeader() {
            return this.header;
        }

        @Override
        public Sequence<RequestRecord> getRecords() {
            return this.records;
        }

        @Override
        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index);
        }

        @Override
        public int length() {
            return this.sequence.length();
        }

        @Override
        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return this.sequence.append(sequence);
        }

        @Override
        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.sequence.length() || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.getSubSequence(fromPosition, toPosition);
        }

        @Override
        public int indexOf(byte b) {
            return this.sequence.indexOf(b);
        }

        @Override
        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.indexOf(position, b);
        }

        @Override
        public int lastIndexOf(byte b) {
            return this.sequence.lastIndexOf(b);
        }

        @Override
        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.lastIndexOf(position, b);
        }

        @Override
        public boolean isEmpty() {
            return this.sequence.isEmpty();
        }

        @Override
        public InputStream getInputStream() {
            return this.sequence.getInputStream();
        }

        @Override
        public ByteSequenceIterator getIterator() {
            return this.sequence.getIterator();
        }

        @Override
        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.getIterator(position);
        }

        @Override
        public String toBinaryString() {
            return this.sequence.toBinaryString();
        }

        @Override
        public String toOctalString() {
            return this.sequence.toOctalString();
        }

        @Override
        public String toHexString() {
            return this.sequence.toHexString();
        }

        @Override
        public String toString() {
            return ((Object)this.sequence).toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                byte e2;
                byte e1 = it1.getNextByte();
                if (e1 == (e2 = it2.getNextByte())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return ((Object)this.sequence).hashCode();
        }
    }
}

