/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageSymbol;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class XKCommand
extends Command {
    public XKCommand(Output o) {
        super(o, "k", "displays the specified memory section as if it were a stack frame", "parameters: 0x<addr>\n\nDisplays the value of each section (whose size is defined by the pointer size of this architecture) of memory, adjusted for the endianness of the architecture this dump file is from, starting at the specified address.  It also displays a module with a module section and an offset from the start of that module section in memory if the pointer points to that module section.  If no symbol is found, it displays a \"*\" and an offset from the current address if the pointer points to an address within 4KB (4096 bytes) of the current address.\n\nWhile this command can work on an arbitrary section of memory, it is probably most useful when used on a section of memory that refers to a stack frame.  To find the memory section of a thread's stack frame, use the \"info thread\" command.\n\nNote: This command uses the number of items passed to it by the \"x/\" command, but ignores the unit size.\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        int numUnits = (Integer)args.pop();
        args.pop();
        if (args.isEmpty()) {
            this.out.error("\"x/k\" command takes exactly one parameter");
            return;
        }
        String param = (String)args.pop();
        if (!args.isEmpty()) {
            this.out.error("\"x/k\" only takes one parameter");
            return;
        }
        Long address = Utils.longFromStringWithPrefix(param);
        if (null == address) {
            this.out.error("invalid hex address specified; address must be specified as \"0x<hex_address>\"");
            return;
        }
        ImageAddressSpace ias = (ImageAddressSpace)properties.get("current_address_space");
        int pointerSize = this.getIASPointerSize(ias);
        int unitSize = pointerSize > 32 ? 8 : 4;
        this.out.print("\n");
        for (int index = 0; index < numUnits; ++index) {
            boolean found = false;
            long currAddr = address + (long)(index * unitSize);
            ImagePointer ip = ias.getPointer(currAddr);
            this.out.print("\t");
            this.out.print(Utils.toHex(currAddr));
            this.out.print("   ");
            long l = 0L;
            try {
                l = ip.getPointerAt(0L).getAddress();
                found = true;
            }
            catch (CorruptDataException e) {
                found = false;
            }
            catch (MemoryAccessException e) {
                found = false;
            }
            if (found) {
                long pointer = l;
                this.out.print(this.toAdjustedHex(l, pointerSize));
                this.out.print("   ");
                if (31 == pointerSize) {
                    pointer = (int)(pointer & (1L << pointerSize) - 1L);
                }
                if (this.printSymbol(pointer, l - currAddr, pointerSize, ias) || this.printStackPointer(pointer, l - currAddr, pointerSize, ias)) {
                    // empty if block
                }
                this.out.print("\n");
                continue;
            }
            this.out.print("<address not found in any address space or exception occurred>\n");
        }
        this.out.print("\n");
    }

    private boolean printSymbol(long pointer, long diff, int pointerSize, ImageAddressSpace ias) {
        Iterator itProcess = ias.getProcesses();
        while (itProcess.hasNext()) {
            Iterator itModule;
            ImageProcess ip = (ImageProcess)itProcess.next();
            try {
                itModule = ip.getLibraries();
            }
            catch (CorruptDataException e) {
                itModule = null;
            }
            catch (DataUnavailable e) {
                itModule = null;
            }
            while (null != itModule && itModule.hasNext()) {
                ImageModule im = (ImageModule)itModule.next();
                Iterator itImageSection = im.getSections();
                while (itImageSection.hasNext()) {
                    ImageSection is = (ImageSection)itImageSection.next();
                    long startAddr = is.getBaseAddress().getAddress();
                    long endAddr = startAddr + is.getSize();
                    if (pointer < startAddr || pointer >= endAddr) continue;
                    long maxDifference = pointer - startAddr;
                    ImageSymbol bestSymbol = null;
                    Iterator iter = im.getSymbols();
                    while (iter.hasNext()) {
                        ImageSymbol symbol;
                        long symbolAddress;
                        Object next = iter.next();
                        if (next instanceof CorruptData || (symbolAddress = (symbol = (ImageSymbol)next).getAddress().getAddress()) > pointer || pointer - symbolAddress >= maxDifference) continue;
                        maxDifference = pointer - symbolAddress;
                        bestSymbol = symbol;
                    }
                    try {
                        this.out.print(im.getName());
                    }
                    catch (CorruptDataException e) {
                        this.out.print(Exceptions.getCorruptDataExceptionString());
                    }
                    this.out.print("::");
                    if (bestSymbol == null) {
                        this.out.print(is.getName());
                    } else {
                        this.out.print(bestSymbol.getName());
                    }
                    this.out.print("+");
                    this.out.print(Long.toString(maxDifference));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean printStackPointer(long pointer, long diff, int pointerSize, ImageAddressSpace ias) {
        if (Math.abs(diff) <= 4096L) {
            if (diff < 0L) {
                this.out.print(" .");
                this.out.print(Long.toString(diff));
            } else {
                this.out.print(" .+");
                this.out.print(Long.toString(diff));
            }
            return true;
        }
        return false;
    }

    private int getIASPointerSize(ImageAddressSpace ias) {
        return ((ImageProcess)ias.getProcesses().next()).getPointerSize();
    }

    private String toAdjustedHex(long l, int pointerSize) {
        if (pointerSize > 32) {
            return Utils.toFixedWidthHex(l);
        }
        if (31 == pointerSize) {
            return Utils.toFixedWidthHex((int)(l & (1L << pointerSize) - 1L));
        }
        return Utils.toFixedWidthHex((int)l);
    }
}

