/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.runtime.ManagedRuntime;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.ClassOutput;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class InfoClassCommand
extends Command {
    public InfoClassCommand(Output o) {
        super(o, "class", "prints inheritance chain and other data for a given class", "parameters: none, class name\n\nif no parameters are passed to \"info class\", it prints the number of instances of each class and the total size of all instances of each class as well as the total number of instances of all classes and the total size of all objects.\n\nif a class name is passed to \"info class\", it prints the following information about that class:\n  - name\n  - ID\n  - superclass ID\n  - class loader ID\n  - modifiers\n  - number of instances and total size of instances\n  - inheritance chain\n  - fields with modifiers (and values for static fields)\n  - methods with modifiers\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap systemProperties) {
        if (args.isEmpty()) {
            this.printImageClasses(loadedImage);
            return;
        }
        String className = (String)args.pop();
        if (!args.isEmpty()) {
            this.out.error("\"info class\" takes at most one parameter, which, if specified, must be a class name");
            return;
        }
        this.printImageClass(loadedImage, className);
    }

    private void printImageClass(Image loadedImage, String className) {
        Iterator itRuntime = Utils.getRuntimes(loadedImage);
        int count = 1;
        this.out.print("\n");
        while (itRuntime.hasNext()) {
            ManagedRuntime mr = (ManagedRuntime)itRuntime.next();
            if (mr instanceof JavaRuntime) {
                this.out.print("Runtime #" + count + ": \n\n");
                this.printRuntimeClass((JavaRuntime)mr, className);
            }
            ++count;
        }
    }

    private void printRuntimeClass(JavaRuntime jr, String className) {
        String modifiersInfo;
        String classLoaderInfo;
        String superClassInfo;
        JavaClass jc = Utils.getClassGivenName(className, jr, this.out);
        if (null == jc) {
            this.out.print("\t  could not find class with name \"" + className + "\"\n\n");
            return;
        }
        String spaces = "    ";
        String cdeInfo = "N/A (CorruptDataException occurred)";
        this.out.print("name = " + className);
        this.out.print(spaces);
        this.out.print("\n\n\t");
        this.out.print("ID = 0x" + Long.toHexString(jc.getID().getAddress()));
        try {
            JavaClass superClass = jc.getSuperclass();
            superClassInfo = null == superClass ? "<no superclass>" : "0x" + Long.toHexString(superClass.getID().getAddress());
        }
        catch (CorruptDataException dce) {
            superClassInfo = cdeInfo;
        }
        this.out.print(spaces);
        this.out.print("superID = " + superClassInfo);
        try {
            JavaClassLoader jClassLoader = jc.getClassLoader();
            classLoaderInfo = "0x" + Long.toHexString(jClassLoader.getObject().getJavaClass().getID().getAddress());
        }
        catch (CorruptDataException cde) {
            classLoaderInfo = cdeInfo;
        }
        this.out.print(spaces);
        this.out.print("\n\t");
        this.out.print("classLoader = " + classLoaderInfo);
        try {
            int modifiers = jc.getModifiers();
            modifiersInfo = Utils.getModifierString(modifiers);
        }
        catch (CorruptDataException cde) {
            modifiersInfo = cdeInfo;
        }
        this.out.print(spaces);
        this.out.print("modifers: " + modifiersInfo);
        this.out.print("\n\n");
        HashMap<JavaClass, Datum> classMap = new HashMap<JavaClass, Datum>();
        classMap.put(jc, new Datum());
        this.updateInstanceCount(jr, classMap);
        Datum d = (Datum)classMap.get(jc);
        this.out.print("\tnumber of instances:     " + d.getCount() + "\n");
        this.out.print("\ttotal size of instances: " + d.getSize() + " bytes");
        this.out.print("\n\n");
        this.printClassHierarchy(jc);
        this.out.print("\n");
        this.printFields(jc);
        this.out.print("\n");
        this.printMethods(jc);
    }

    private void printClassHierarchy(JavaClass jClass) {
        Stack<String> stack = new Stack<String>();
        while (null != jClass) {
            try {
                stack.add(jClass.getName());
                jClass = jClass.getSuperclass();
            }
            catch (CorruptDataException cde) {
                stack.add("N/A (CorruptDataException occurred)");
                break;
            }
        }
        this.printStack(stack);
    }

    private void printStack(Stack stack) {
        this.out.print("Inheritance chain....\n\n");
        String tab = "\t";
        String spaces = "";
        while (stack.size() > 0) {
            this.out.print(tab + spaces + (String)stack.pop() + "\n");
            spaces = spaces + "   ";
        }
    }

    private void printFields(JavaClass jClass) {
        this.out.print("Fields......\n\n");
        ClassOutput.printStaticFields(jClass, this.out);
        ClassOutput.printNonStaticFields(jClass, this.out);
    }

    private void printMethods(JavaClass jClass) {
        this.out.print("Methods......\n\n");
        ClassOutput.printMethods(jClass.getDeclaredMethods(), this.out);
        this.out.print("\n");
    }

    private void printImageClasses(Image loadedImage) {
        Iterator itRuntime = Utils.getRuntimes(loadedImage);
        int count = 1;
        this.out.print("\n");
        while (itRuntime.hasNext()) {
            ManagedRuntime mr = (ManagedRuntime)itRuntime.next();
            if (mr instanceof JavaRuntime) {
                this.out.print("Runtime #" + count + ": \n\n");
                this.printRuntimeClasses((JavaRuntime)mr);
                this.out.print("\n\n");
            }
            ++count;
        }
    }

    private void printRuntimeClasses(JavaRuntime jr) {
        HashMap<JavaClass, Datum> javaClasses = new HashMap<JavaClass, Datum>();
        Iterator itClassLoader = jr.getJavaClassLoaders();
        while (itClassLoader.hasNext()) {
            JavaClassLoader jcl = (JavaClassLoader)itClassLoader.next();
            Iterator itCache = jcl.getCachedClasses();
            while (itCache.hasNext()) {
                Object next = itCache.next();
                if (!(next instanceof CorruptData)) continue;
                try {
                    long jclAddress = jcl.getObject().getID().getAddress();
                    this.out.print("\t classloader ID: " + Utils.toHex(jclAddress) + " " + Exceptions.getCorruptDataExceptionString() + "\n");
                }
                catch (CorruptDataException e) {
                    this.out.print("\t classloader ID: <unknown> " + Exceptions.getCorruptDataExceptionString() + "\n");
                }
                break;
            }
            Iterator itClass = jcl.getDefinedClasses();
            while (itClass.hasNext()) {
                javaClasses.put((JavaClass)itClass.next(), new Datum());
            }
        }
        this.updateInstanceCount(jr, javaClasses);
        long objCount = 0L;
        long totalSize = 0L;
        Iterator itClass = javaClasses.keySet().iterator();
        if (itClass.hasNext()) {
            this.printClassListHeader();
        } else {
            this.out.print("\n\t No information found for loaded classes\n");
        }
        while (itClass.hasNext()) {
            String className;
            JavaClass jc = (JavaClass)itClass.next();
            try {
                className = jc.getName();
            }
            catch (CorruptDataException cde) {
                className = Exceptions.getCorruptDataExceptionString();
            }
            Datum d = (Datum)javaClasses.get(jc);
            totalSize += d.getSize();
            objCount += (long)d.getCount();
            this.printOneClass(className, d);
        }
        this.out.print("\n");
        if (objCount > 0L) {
            this.out.print("\t Total number of objects: " + objCount + "\n");
            this.out.print("\t Total size of objects: " + totalSize + "\n");
        }
    }

    private void updateInstanceCount(JavaRuntime jr, Map javaClasses) {
        Iterator itHeap = jr.getHeaps();
        while (itHeap.hasNext()) {
            JavaHeap jh = (JavaHeap)itHeap.next();
            Iterator itObject = jh.getObjects();
            while (itObject.hasNext()) {
                JavaClass jc;
                Object next = itObject.next();
                if (!(next instanceof JavaObject)) continue;
                JavaObject jo = (JavaObject)next;
                Datum d = null;
                try {
                    jc = jo.getJavaClass();
                }
                catch (CorruptDataException cde) {
                    jc = null;
                }
                if (null != jc) {
                    long size;
                    d = (Datum)javaClasses.get(jc);
                    if (null == d) {
                        d = new Datum();
                        javaClasses.put(jc, d);
                    }
                    try {
                        size = jo.getSize();
                    }
                    catch (CorruptDataException cde) {
                        size = 0L;
                    }
                    d.addToSize(size);
                    d.incrementCount();
                    continue;
                }
                try {
                    this.out.print(jo.getJavaClass().getName() + "\n");
                }
                catch (CorruptDataException cde) {
                    this.out.print(Exceptions.getCorruptDataExceptionString() + "\n");
                }
            }
        }
    }

    private void printClassListHeader() {
        this.out.print("\t");
        this.out.print(Utils.prePadWithSpaces("instances", 16));
        this.out.print(Utils.prePadWithSpaces("total size", 16));
        this.out.print("  class name");
        this.out.print("\n");
    }

    private void printOneClass(String className, Datum datum) {
        this.out.print("\t");
        this.out.print(Utils.prePadWithSpaces(String.valueOf(datum.getCount()), 16));
        this.out.print(Utils.prePadWithSpaces(String.valueOf(datum.getSize()), 16));
        this.out.print("  " + className);
        this.out.print("\n");
    }

    public class Datum {
        private int count = 0;
        private long size = 0L;

        public int getCount() {
            return this.count;
        }

        public long getSize() {
            return this.size;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void addToSize(long sizeToAdd) {
            this.size += sizeToAdd;
        }
    }
}

